/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.commit_alert;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.commit_alert.CommitAlert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class CommitAlerts
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="alerts")
    private final List<CommitAlert> alerts = new ArrayList<CommitAlert>();
    @JsonProperty(value="executedChecks")
    private final Set<String> executedChecks = new HashSet<String>();

    public CommitAlerts(CommitDescriptor commit) {
        super(commit);
    }

    public int getAlertCount() {
        return this.alerts.size();
    }

    public UnmodifiableList<CommitAlert> getCommitAlerts() {
        return CollectionUtils.asUnmodifiable(this.alerts);
    }

    public void addAlert(CommitAlert commitAlert) {
        this.alerts.add(commitAlert);
    }

    public boolean hasBeenExecuted(String check) {
        return this.executedChecks.contains(check);
    }

    public void setExecuted(String check) {
        this.executedChecks.add(check);
    }
}

