/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Collection;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.intellij.lang.annotations.Language;

public class CompilationDatabasesConfiguration
extends AnalysisConfigurationBase {
    public static final String MACRO_FILTER_OPTION = "Compilation Command: Macro Filter";
    public static final String SEARCH_PATH_FILTER_OPTION = "Compilation Command: Search Path Filter";
    @Language(value="RegExp")
    public static final String MATCH_NOTHING_PATTERN = "(?!)";
    @ConfigExposed(name="Compilation Command: Macro Filter", description="Pattern that is applied on arguments of a compilation command.\nIt filters out macro definitions that are matched by this pattern before storing them in the database.\nFor example, when the option is set to `.*MACRO.*`, an argument like `-DMACRO=1` would be filtered.\nSetting this option may speed up the analysis, as changes to a compilation command lead to a full re-analysis of the source code.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private String macroFilter = "(?!)";
    @ConfigExposed(name="Compilation Command: Search Path Filter", description="Pattern that is applied on arguments of a compilation command.\nIt filters out include path arguments that are matched by this pattern before storing them in the database.\nFor example, when the option is set to `.*/path.*`, an argument like `-I/src/main/path/headers` would be filtered.\nSetting this option may speed up the analysis, as changes to a compilation command lead to a full re-analysis of the source code.\n", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private String searchPathFilter = "(?!)";

    public CompilationDatabasesConfiguration() {
        this.autoExpose();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{LanguageGroups.C_AND_DERIVATIVES}).isEmpty()) {
            return;
        }
        template.registerGlobalOption(this.getOptionForField("macroFilter"));
        template.registerGlobalOption(this.getOptionForField("searchPathFilter"));
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
    }
}

