/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.teamscale.index.report.EReportFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class IncludeExcludePatterns {
    @JsonProperty(value="includedFilePatterns")
    private final List<String> includedFilePatterns = new ArrayList<String>();
    @JsonProperty(value="excludedFilePatterns")
    private final List<String> excludedFilePatterns = new ArrayList<String>();
    @JsonProperty(value="excludedContentPatterns")
    private final List<String> excludedContentPatterns = new ArrayList<String>();
    @JsonProperty(value="textFilterPatterns")
    private final List<String> textFilterPatterns = new ArrayList<String>();
    @JsonProperty(value="reportMappings")
    private final List<String> reportMappings = new ArrayList<String>();
    @JsonProperty(value="partitionPattern")
    private String partitionPattern;
    @JsonProperty(value="testCodeIncludedFilePatterns")
    public final List<String> testCodeIncludedFilePatterns = new ArrayList<String>();
    @JsonProperty(value="testCodeExcludedFilePatterns")
    public final List<String> testCodeExcludedFilePatterns = new ArrayList<String>();

    public IncludeExcludePatterns appendIncludedFilePatterns(String ... includes) {
        Collections.addAll(this.includedFilePatterns, includes);
        return this;
    }

    public IncludeExcludePatterns appendExcludedFilePatterns(String ... excludes) {
        Collections.addAll(this.excludedFilePatterns, excludes);
        return this;
    }

    public void appendExcludedContentPatterns(String ... excludes) {
        Collections.addAll(this.excludedContentPatterns, excludes);
    }

    public IncludeExcludePatterns appendReportMapping(String pattern, EReportFormat reportFormat) {
        this.reportMappings.add(pattern + " -> " + reportFormat.name());
        return this;
    }

    public IncludeExcludePatterns withPartitionPattern(String pattern) {
        this.partitionPattern = pattern;
        return this;
    }

    public IncludeExcludePatterns appendTestIncludePatterns(String ... testIncludes) {
        Collections.addAll(this.testCodeIncludedFilePatterns, testIncludes);
        return this;
    }

    public ImmutableList<@NonNull String> getIncludedFilePatterns() {
        return ImmutableList.copyOf(this.includedFilePatterns);
    }

    public ImmutableList<@NonNull String> getExcludedFilePatterns() {
        return ImmutableList.copyOf(this.excludedFilePatterns);
    }

    public List<String> getExcludedContentPatterns() {
        return ImmutableList.copyOf(this.excludedContentPatterns);
    }

    public void merge(IncludeExcludePatterns patterns) {
        if (patterns == null) {
            return;
        }
        this.includedFilePatterns.addAll(patterns.includedFilePatterns);
        this.excludedFilePatterns.addAll(patterns.excludedFilePatterns);
        this.excludedContentPatterns.addAll(patterns.excludedContentPatterns);
        this.textFilterPatterns.addAll(patterns.textFilterPatterns);
        this.reportMappings.addAll(patterns.reportMappings);
        if (this.partitionPattern == null) {
            this.partitionPattern = patterns.partitionPattern;
        }
        this.testCodeIncludedFilePatterns.addAll(patterns.testCodeIncludedFilePatterns);
        this.testCodeExcludedFilePatterns.addAll(patterns.testCodeExcludedFilePatterns);
    }
}

