/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionGroup;
import com.teamscale.index.naming.NamingConventionSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

public class NamingConventionConfiguration
extends AnalysisConfigurationBase {
    private static final String ALLOW_ALL = ".*";
    private static final String UPPERCASE_START = "[A-Z][a-zA-Z0-9]*";
    private static final String CS_NAMESPACE = "@?[a-z_A-Z]\\w+(?:\\.@?[a-z_A-Z]\\w+)*";
    private static final String CPP_NAMESPACE = "[a-zA-Z][a-z_A-Z0-9]*(::[a-zA-Z][a-z_A-Z0-9]*)*";
    private static final String LOWERCASE_START = "[a-z][a-zA-Z0-9]*";
    private static final String OPTIONAL_UNDERSCORE = "_?";
    private static final String OR = "|";
    private static final String UNDERSCORE_ONLY = "_";
    private static final String LOWERCASE_START_AND_DOT = "[a-z][\\.a-zA-Z0-9]*";
    private static final String ALL_UPPERCASE = "[A-Z][_A-Z0-9]*";
    private static final String ALL_LOWERCASE_AND_DOT = "[a-z][a-z_0-9.]*";
    private static final String OPTIONAL_AT = "@?";
    private static final String DOLLAR = "\\$";
    private static final String OSCRIPT_TYPE_NAME = "([A-Z][a-zA-Z0-9]*|#'[a-zA-Z0-9 ]+'#)";
    private static final String OSCRIPT_PACKAGE_NAME = "[A-Z]+(::([A-Z][a-zA-Z0-9]*|#'[a-zA-Z0-9 ]+'#))*";
    private final List<NamingConventionDescriptor> conventions = new ArrayList<NamingConventionDescriptor>();
    private final CodeScopeAware<Map<PatternKey, Pattern>> regexes = CodeScopeAware.empty();

    public NamingConventionConfiguration() {
        this.conventions.add(this.createJavaConvention());
        this.conventions.add(this.createCppOrCConvention(ELanguage.CPP));
        this.conventions.add(this.createCppOrCConvention(ELanguage.CPP_MS_CLI));
        this.conventions.add(this.createCppOrCConvention(ELanguage.C));
        this.conventions.add(this.createCsConvention());
        this.conventions.add(this.createJavaScriptConvention());
        this.conventions.add(this.createMatlabConvention());
        this.conventions.add(this.createPhpConvention());
        this.conventions.add(this.createGosuConvention());
        this.conventions.add(this.createOScriptConvention());
        this.conventions.forEach(NamingConventionDescriptor::expose);
    }

    private NamingConventionDescriptor createConvention(ELanguage language, EnumMap<ENamingConventionTokenClass, String> ruleMap) {
        NamingConventionDescriptor convention = new NamingConventionDescriptor(this, language);
        for (ENamingConventionTokenClass tokenClass : ruleMap.keySet()) {
            String regex = ruleMap.get((Object)tokenClass);
            if (regex == null) continue;
            convention.addRule(NamingConventionGroup.create(language, tokenClass), regex);
        }
        return convention;
    }

    private NamingConventionDescriptor createGosuConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, ALL_LOWERCASE_AND_DOT);
        ruleMap.put(ENamingConventionTokenClass.TYPES, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, "_?[a-z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        return this.createConvention(ELanguage.GOSU, ruleMap);
    }

    private NamingConventionDescriptor createOScriptConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, OSCRIPT_PACKAGE_NAME);
        ruleMap.put(ENamingConventionTokenClass.TYPES, OSCRIPT_TYPE_NAME);
        ruleMap.put(ENamingConventionTokenClass.METHODS, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        return this.createConvention(ELanguage.OSCRIPT, ruleMap);
    }

    private NamingConventionDescriptor createJavaConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, ALL_LOWERCASE_AND_DOT);
        ruleMap.put(ENamingConventionTokenClass.TYPES, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, "[a-z][a-zA-Z0-9]*|_");
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        return this.createConvention(ELanguage.JAVA, ruleMap);
    }

    private NamingConventionDescriptor createMatlabConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.TYPES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.MODULES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALLOW_ALL);
        return this.createConvention(ELanguage.MATLAB, ruleMap);
    }

    private NamingConventionDescriptor createCppOrCConvention(ELanguage language) {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, CPP_NAMESPACE);
        ruleMap.put(ENamingConventionTokenClass.TYPES, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        return this.createConvention(language, ruleMap);
    }

    private NamingConventionDescriptor createCsConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, CS_NAMESPACE);
        ruleMap.put(ENamingConventionTokenClass.TYPES, "@?[A-Z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.METHODS, "@?[A-Z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, "@?[a-z][a-zA-Z0-9]*|_");
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, "@?[A-Z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, "@?[a-z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, "@?[A-Z][a-zA-Z0-9]*");
        return this.createConvention(ELanguage.CS, ruleMap);
    }

    private NamingConventionDescriptor createJavaScriptConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.TYPES, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START_AND_DOT);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        ruleMap.put(ENamingConventionTokenClass.FUNCTIONAL_COMPONENTS, UPPERCASE_START);
        return this.createConvention(ELanguage.JAVASCRIPT, ruleMap);
    }

    private NamingConventionDescriptor createPhpConvention() {
        EnumMap<ENamingConventionTokenClass, String> ruleMap = new EnumMap<ENamingConventionTokenClass, String>(ENamingConventionTokenClass.class);
        ruleMap.put(ENamingConventionTokenClass.MODULES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.TYPES, UPPERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHODS, LOWERCASE_START);
        ruleMap.put(ENamingConventionTokenClass.METHOD_PARAMETERS, "\\$[a-z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.ATTRIBUTES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.GLOBAL_VARIABLES, ALLOW_ALL);
        ruleMap.put(ENamingConventionTokenClass.LOCAL_VARIABLES, "\\$[a-z][a-zA-Z0-9]*");
        ruleMap.put(ENamingConventionTokenClass.CONSTANTS, ALL_UPPERCASE);
        return this.createConvention(ELanguage.PHP, ruleMap);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (this.isDisabled(proxy)) {
            return;
        }
        List codeScopeNames = proxy.getCodeScopeNames();
        TriggerBuilder trigger = new TriggerBuilder(NamingConventionSynchronizer.class, ETriggerConcurrency.PARALLEL);
        for (NamingConventionDescriptor convention : this.conventions) {
            convention.setTriggerParameters(trigger, codeScopeNames);
            convention.configureFindingsSchema(proxy);
        }
        proxy.createTrigger(trigger);
    }

    private boolean isDisabled(ProjectCreationProxy proxy) {
        return this.conventions.stream().noneMatch(convention -> convention.isActive(proxy.getCodeScopeNames()));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        for (NamingConventionDescriptor convention : this.conventions) {
            convention.exposeFindings(template.getCodeScope());
            if (!languages.contains(convention.language)) continue;
            Pair<String, List<ConfigurationItemBase>> groupItems = convention.createGroup(template.getCodeScope());
            template.registerConfigurationItemsCodeScopeAware((String)groupItems.getFirst(), "Comprehensibility", (Collection)groupItems.getSecond());
        }
    }

    private class NamingConventionDescriptor {
        private final ELanguage language;
        private final CodeScopeAware<FindingDescriptor> finding;
        private final EFindingEnablement defaultEnablement;
        private final Map<ENamingConventionTokenClass, NamingRegexOption> checkRegexOptions;
        final /* synthetic */ NamingConventionConfiguration this$0;

        private NamingConventionDescriptor(NamingConventionConfiguration namingConventionConfiguration, ELanguage language) {
            NamingConventionConfiguration namingConventionConfiguration2 = namingConventionConfiguration;
            Objects.requireNonNull(namingConventionConfiguration2);
            this.this$0 = namingConventionConfiguration2;
            this.finding = CodeScopeAware.empty();
            this.checkRegexOptions = new EnumMap<ENamingConventionTokenClass, NamingRegexOption>(ENamingConventionTokenClass.class);
            this.language = language;
            this.defaultEnablement = language == ELanguage.CS || language.isCppOrC() ? EFindingEnablement.OFF : EFindingEnablement.YELLOW;
        }

        private FindingDescriptor getFindingDescriptor(CodeScopeName codeScope) {
            return (FindingDescriptor)this.finding.getOrComputeValue(codeScope, ignored -> new FindingDescriptor(this.language.getReadableName() + " naming conventions", EAnalysisTool.TEAMSCALE, EnumSet.of(this.language), this.defaultEnablement, (String)CheckDescriptionLoader.getCheckDescription(this.getClass(), (String)"cqse-naming-convention.md").orElseThrow()));
        }

        private void addRule(NamingConventionGroup namingConventionGroup, String regex) {
            Pattern compiled;
            try {
                compiled = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new AssertionError("Default pattern should compile!", e);
            }
            this.checkRegexOptions.put(namingConventionGroup.tokenClass, new NamingRegexOption(this.language, namingConventionGroup.getUiStringPlural(), new NamingRegexBehavior(this.this$0, compiled, new PatternKey(this.language, namingConventionGroup.tokenClass))));
        }

        private void exposeFindings(CodeScopeName codeScope) {
            this.this$0.addFindingDescriptor(this.getFindingDescriptor(codeScope), codeScope);
        }

        private void expose() {
            for (NamingRegexOption option : this.checkRegexOptions.values()) {
                this.this$0.addOption(option);
            }
        }

        public boolean isActive(Collection<CodeScopeName> codeScopes) {
            return codeScopes.stream().anyMatch(this::isActive);
        }

        public boolean isActive(CodeScopeName codeScope) {
            return this.getFindingDescriptor(codeScope).getEnablement().isEnabled();
        }

        private Pair<String, List<ConfigurationItemBase>> createGroup(CodeScopeName codeScope) {
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(this.getFindingDescriptor(codeScope));
            for (ENamingConventionTokenClass tokenClass : ENamingConventionTokenClass.values()) {
                NamingRegexOption option = this.checkRegexOptions.get((Object)tokenClass);
                if (option == null) continue;
                items.add((Object)option);
            }
            return new Pair((Object)"Naming", items);
        }

        private void setTriggerParameters(TriggerBuilder trigger, List<CodeScopeName> codeScopeNames) {
            this.setTokenPatternParameter(trigger, codeScopeNames);
            this.setEnablementParameter(trigger, codeScopeNames);
        }

        private void setTokenPatternParameter(TriggerBuilder trigger, List<CodeScopeName> codeScopeNames) {
            CodeScopeAware parameterValue = CodeScopeAware.empty();
            for (ENamingConventionTokenClass tokenClass : ENamingConventionTokenClass.values()) {
                NamingRegexOption option = this.checkRegexOptions.get((Object)tokenClass);
                if (option == null) continue;
                for (CodeScopeName codeScope : codeScopeNames) {
                    Pattern regex = option.retrieveValue(codeScope);
                    if (regex == null) continue;
                    ((Map)parameterValue.getOrComputeValue(codeScope, ignored -> new HashMap())).put(tokenClass, regex);
                }
            }
            trigger.setTriggerParameter(NamingConventionSynchronizer.getPatternParameterName(this.language), (ITriggerParameter)parameterValue);
        }

        private void setEnablementParameter(TriggerBuilder trigger, List<CodeScopeName> codeScopeNames) {
            CodeScopeAware enabled = CodeScopeAware.empty();
            for (CodeScopeName codeScopeName : codeScopeNames) {
                enabled.setValue(codeScopeName, (Object)this.isActive(codeScopeName));
            }
            trigger.setTriggerParameter(NamingConventionSynchronizer.getEnablementParameterName(this.language), (ITriggerParameter)enabled);
        }

        private void configureFindingsSchema(ProjectCreationProxy proxy) {
            for (CodeScope codeScope : proxy.getCodeScopes()) {
                proxy.addFindingsSchemaEntry("Naming", this.language.name(), this.getFindingDescriptor(codeScope.getName()), codeScope.getName());
            }
        }
    }

    private static class NamingRegexOption
    extends ConfigOptionDescriptorBase {
        private static final long serialVersionUID = 1L;

        protected NamingRegexOption(ELanguage language, String name, NamingRegexBehavior behaviour) {
            super("Regex for " + language.getReadableName() + " " + name, "The regular expression used to check the names of " + name + ".", false, (IConfigOptionDescriptorBehaviour)behaviour);
        }

        public NamingConventionConfiguration getConfiguration() {
            return (NamingConventionConfiguration)super.getConfiguration();
        }

        protected void setConfiguration(ConfigurationBase configuration) {
            CCSMAssert.isInstanceOf((Object)configuration, NamingConventionConfiguration.class);
            super.setConfiguration(configuration);
        }

        public Pattern retrieveValue(CodeScopeName codeScopeName) {
            return (Pattern)super.retrieveValue(codeScopeName);
        }

        protected Pattern parseValue(String regex) throws ProjectConfigurationException {
            try {
                return Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new ProjectConfigurationException("Invalid regular expression '%s'".formatted(regex), (Throwable)e);
            }
        }
    }

    private static class NamingRegexBehavior
    implements IConfigOptionDescriptorBehaviour {
        private final NamingConventionConfiguration configuration;
        private final Pattern defaultPattern;
        private final PatternKey patternKey;

        private NamingRegexBehavior(NamingConventionConfiguration configuration, Pattern defaultPattern, PatternKey patternKey) {
            this.configuration = configuration;
            this.defaultPattern = defaultPattern;
            this.patternKey = patternKey;
        }

        public Pattern retrieveValue(CodeScopeName codeScopeName) {
            if (!this.configuration.regexes.contains(codeScopeName)) {
                return this.defaultPattern;
            }
            return ((Map)this.configuration.regexes.getValue(codeScopeName)).getOrDefault(this.patternKey, this.defaultPattern);
        }

        public Pattern retrieveDefaultValue() {
            return this.defaultPattern;
        }

        public @NonNull UnmodifiableList<Pattern> retrieveValues() {
            return (UnmodifiableList)this.configuration.regexes.getValues().stream().filter(m -> m.containsKey(this.patternKey)).map(m -> (Pattern)m.get(this.patternKey)).collect(CollectionUtils.toUnmodifiableList());
        }

        public void storeValue(Object value, CodeScopeName codeScopeName) {
            CCSMAssert.isInstanceOf((Object)value, Pattern.class);
            ((Map)this.configuration.regexes.getOrComputeValue(codeScopeName, ignored -> new HashMap())).put(this.patternKey, (Pattern)value);
        }

        public String getTypeName() {
            return Pattern.class.getTypeName();
        }
    }

    private record PatternKey(ELanguage language, ENamingConventionTokenClass tokenClass) {
    }
}

