/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.migrations;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.Arrays;
import java.util.List;

public class V213EnableClangCheckIds
implements IJsonMigration {
    public static final String EXTERNAL_CLANG_ANALYSIS_GROUP = "Static analysis (Clang)";
    public static final String OTHER_CHECK_ID = "Other";
    private static final List<String> NEW_CLANG_CHECK_IDS = Arrays.asList("Error handling", "Coding conventions (Apple)", "C++ object lifecycle", "C++ move semantics", "Security error", "Unused code", "Tainted data used", "Stream handling error", "Performance", "CERT Environment (ENV)", "Code clone", "WebKit coding guidelines", "Type Error", "Suspicious operation", "General", "Lock checker", "Fuchsia Handle Error", "Unix Stream API Error", "debug", "Core Foundation/Objective-C", "ARC and @properties", "ARC Casting Rules", "ARC Parse Issue", "ARC Retain Cycle", "ARC Semantic Issue", "ARC Weak References", "API Notes Issue", "AST Deserialization Issue", "AST Serialization Issue", "Backend Issue", "Codegen ABI Check", "Command line", "Concepts Issue", "Coroutines Issue", "Generics Issue", "Lambda Issue", "Cocoa API Issue", "Documentation Issue", "Format String Issue", "Dependency Directive Source Scanner Issue", "Modules Issue", "Deprecations", "#pragma message Directive", "Inline Assembly Issue", "Instrumentation Issue", "Lexical or Preprocessor Issue", "Parse Issue", "Nullability Issue", "OpenMP Issue", "Refactoring Invocation Issue", "Related Result Type Issue", "Semantic Issue", "SourceMgr Reported Issue", "Undefined Behavior Sanitizer", "Unused Entity Issue", "Value Conversion Issue", "User-Defined Issue", "Verification", "VTable ABI Issue");

    public static List<String> getCheckIdsToEnable() {
        return NEW_CLANG_CHECK_IDS;
    }

    public void migrateJson(ObjectNode analysisProfile) {
        ObjectNode clangGroup = AnalysisProfileMigrationUtils.getAnalysisGroup(analysisProfile, EXTERNAL_CLANG_ANALYSIS_GROUP);
        if (clangGroup == null) {
            return;
        }
        ObjectNode options = (ObjectNode)clangGroup.get("options");
        if (options == null || !options.has(OTHER_CHECK_ID)) {
            return;
        }
        String otherEnablement = options.get(OTHER_CHECK_ID).asText();
        if (EFindingEnablement.OFF.name().equals(otherEnablement) || EFindingEnablement.UNDECIDED.name().equals(otherEnablement)) {
            return;
        }
        for (String checkId : NEW_CLANG_CHECK_IDS) {
            if (options.has(checkId)) continue;
            options.put(checkId, otherEnablement);
        }
    }
}

