/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.migrations;

import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.migration.finding.ConfigurationOptionDeletion;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import com.teamscale.index.migration.finding.ConfigurationOptionValueReplacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.NonNull;

public class V215SwiftlintUpdateMigration
implements IJsonMigrator {
    public @NonNull String migrate(@Language(value="JSON") String json) throws MigrationException {
        ArrayList<IJsonMigration> migrations = new ArrayList<IJsonMigration>(V215SwiftlintUpdateMigration.getValueMigrations());
        migrations.addAll(V215SwiftlintUpdateMigration.getRemoveMigrations());
        migrations.addAll(V215SwiftlintUpdateMigration.getRenameMigrations());
        return new JsonMigrator(migrations).migrate(json);
    }

    private static @NonNull List<IJsonMigration> getValueMigrations() {
        return List.of(ConfigurationOptionValueReplacement.withCaseInsensitive("generic_type_name.validates_start_with_lowercase", "Naming", Map.of("false", "off", "true", "error")), ConfigurationOptionValueReplacement.withCaseInsensitive("identifier_name.validates_start_with_lowercase", "Naming", Map.of("false", "off", "true", "error")), ConfigurationOptionValueReplacement.withCaseInsensitive("type_name.validates_start_with_lowercase", "Naming", Map.of("false", "off", "true", "error")), ConfigurationOptionValueReplacement.withCaseInsensitive("expiring_todo.date_delimiters", "Task Tags", Map.of("opening: \"[\", closing: \"]\"", "opening: \"[\"\nclosing: \"]\"")));
    }

    private static @NonNull List<IJsonMigration> getRemoveMigrations() {
        return List.of(new ConfigurationOptionDeletion("anyobject_protocol", "Bad Practice"), new ConfigurationOptionDeletion("inert_defer", "Design Flaws"), new ConfigurationOptionDeletion("redundant_optional_initialization", "Bad Practice"), new ConfigurationOptionDeletion("unused_capture_list", "Unused Code"), new ConfigurationOptionDeletion("operator_whitespace", "Formatting"), new ConfigurationOptionDeletion("capture_variable", "Bad Practice"), new ConfigurationOptionDeletion("explicit_self", "Bad Practice"), new ConfigurationOptionDeletion("typesafe_array_init", "Error-prone Practices"), new ConfigurationOptionDeletion("unused_declaration", "Unused Code"), new ConfigurationOptionDeletion("unused_declaration.include_public_and_open", "Unused Code"), new ConfigurationOptionDeletion("unused_declaration.related_usrs_to_skip", "Unused Code"), new ConfigurationOptionDeletion("unused_import", "Unused Code"), new ConfigurationOptionDeletion("unused_import.require_explicit_imports", "Unused Code"), new ConfigurationOptionDeletion("unused_import.allowed_transitive_imports", "Unused Code"), new ConfigurationOptionDeletion("unused_import.always_keep_imports", "Unused Code"), new ConfigurationOptionDeletion("private_unit_test.regex", "Disabled Tests"));
    }

    private static @NonNull List<IJsonMigration> getRenameMigrations() {
        return List.of(new ConfigurationOptionReplacement("expiring_todo.date_delimiters", "expiring_todo.date_delimiters.yaml_config", "Task Tags"), new ConfigurationOptionReplacement("file_types_order.order", "file_types_order.order.yaml_config", "Member Ordering"), new ConfigurationOptionReplacement("type_contents_order.order", "type_contents_order.order.yaml_config", "Member Ordering"));
    }
}

