/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.findings.flake8.Flake8Synchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;

public class Flake8Configuration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "Flake8";
    private static final String MAPPINGS_TSV_ROOT_DIR = "flake8";
    public static final String EXPECTED_VERSION_FILE = "flake8/version.txt";
    private static final String DESCRIPTIONS_ROOT_DIR = "flake8";
    private static final String CHECKID_PREFIX = "flake8-";
    private static final List<String> SUPPORTED_PLUGINS = List.of("bugbear", "mccabe", "pycodestyle", "pyflakes");
    @ConfigExposed(name="Flake8: maximum line length", visibility=ConfigExposed.EConfigVisibility.DEFAULT, description="The maximum allowed line length")
    public CodeScopeAware<Integer> maxLineLength = CodeScopeAware.defaultCodeScopeWithValue((Object)79);
    @ConfigExposed(name="Flake8: maximum doc line length", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The maximum allowed doc line length. `-1` means unconfigured (default)")
    public CodeScopeAware<Integer> maxDocLineLength = CodeScopeAware.defaultCodeScopeWithValue((Object)-1);
    @ConfigExposed(name="Flake8: indent size", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Number of spaces used for indentation")
    public CodeScopeAware<Integer> indentSize = CodeScopeAware.defaultCodeScopeWithValue((Object)4);
    private final Map<String, CheckInfo> checksById;

    @Contract(pure=true)
    public static @NonNull String stripCheckIdPrefix(@NonNull String checkId) {
        return StringUtils.stripPrefix((String)checkId, (String)CHECKID_PREFIX);
    }

    @Contract(pure=true)
    public static @NonNull String addCheckIdPrefix(@NonNull String checkId) {
        return CHECKID_PREFIX + checkId;
    }

    public Flake8Configuration() throws ProjectConfigurationException {
        super(EAnalysisTool.FLAKE8, FINDING_CATEGORY);
        try {
            this.checksById = this.loadChecksForPlugins();
        }
        catch (IOException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
        this.declareCodeScopeAware();
    }

    @Contract(pure=true)
    private static @NonNull String getCheckMappingPathFor(@NonNull String plugin) {
        return "flake8/" + plugin + "/check-mappings.tsv";
    }

    @Contract(pure=true)
    private static @NonNull String getCheckOptionsPathFor(@NonNull String plugin) {
        return "flake8/" + plugin + "/check-options.tsv";
    }

    @Contract(pure=true)
    private static @NonNull String getCheckDescriptionBasePathFor(@NonNull String plugin) {
        return "flake8/" + plugin;
    }

    private @NonNull Map<String, CheckInfo> loadChecksForPlugins() throws IOException {
        HashMap<String, CheckInfo> checkInfos = new HashMap<String, CheckInfo>();
        for (String plugin : SUPPORTED_PLUGINS) {
            Map checkMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)Resource.of(Flake8Configuration.class, (String)Flake8Configuration.getCheckMappingPathFor(plugin)));
            Optional<Multimap> pluginOptions = Resource.asOptional(Flake8Configuration.class, (String)Flake8Configuration.getCheckOptionsPathFor(plugin)).map(CheckMappingAndCheckOptionTSVUtils::readCheckOptionsFromTsvByFullID);
            String descriptionBasePath = Flake8Configuration.getCheckDescriptionBasePathFor(plugin);
            for (CheckMapping mapping : checkMappings.values()) {
                String description = this.getDescription(mapping.checkId, descriptionBasePath);
                checkInfos.put(mapping.checkId, new CheckInfo(plugin, mapping, description, pluginOptions.map(o -> o.get((Object)mapping.checkId)).orElse(Collections.emptyList())));
            }
        }
        return checkInfos;
    }

    private void registerCheckInfoAsFinding(@NonNull CheckInfo checkInfo, CodeScopeName codeScope) throws ProjectConfigurationException {
        String group = this.getGroup(checkInfo.mapping.group);
        this.createFindingType(checkInfo.mapping.checkId, checkInfo.mapping.getReadableCheckName(), checkInfo.description, group, checkInfo.mapping.defaultEnablement, checkInfo.mapping.autoAllowed, checkInfo.options, codeScope);
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return this.getGroupToQualityIndicator(codeScopeName).getOrDefault(groupName, "Uncategorized Flake8 Check");
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder trigger = new TriggerBuilder(Flake8Synchronizer.class, ETriggerConcurrency.PARALLEL);
        trigger.setTriggerParameter("checks", ITriggerParameter.of((Object)activeChecksPerCodeScope));
        trigger.setTriggerParameter("max-line-length", this.maxLineLength);
        trigger.setTriggerParameter("max-doc-line-length", this.maxDocLineLength);
        trigger.setTriggerParameter("indent-size", this.indentSize);
        trigger.setTriggerParameter("check-options", ITriggerParameter.of(this.extractCheckOptions((CodeScopeAware<Collection<String>>)activeChecksPerCodeScope)));
        proxy.createTrigger(trigger);
        super.configureProjectInternal(proxy);
    }

    private CodeScopeAware<PairList<String, String>> extractCheckOptions(CodeScopeAware<Collection<String>> selectedChecks) {
        CodeScopeAware checkOptions = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : selectedChecks.getCodeScopeNames()) {
            Collection checksForCodeScope = (Collection)selectedChecks.getValue(codeScopeName);
            checkOptions.setValue(codeScopeName, (Object)new PairList());
            if (checksForCodeScope.isEmpty()) continue;
            for (Map.Entry entry : ((Map)this.valueByOptionsId.getValue(codeScopeName)).entrySet()) {
                String checkName;
                String value = Optional.ofNullable(entry.getValue()).map(String::valueOf).orElse(null);
                if (StringUtils.isEmpty((String)value) || !checksForCodeScope.contains(checkName = StringUtils.getFirstPart((String)((String)entry.getKey()), (String)"#"))) continue;
                String optionName = StringUtils.getLastPart((String)((String)entry.getKey()), (String)"#");
                ((PairList)checkOptions.getValue(codeScopeName)).add((Object)optionName, (Object)value);
            }
        }
        return checkOptions;
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            Flake8Synchronizer.verifyFlake8Version();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException("Flake8 tool validation failed", (Throwable)e);
        }
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(this.tool)) {
            return;
        }
        CodeScopeName codeScope = template.getCodeScope();
        this.autoExpose(codeScope);
        Map groupToQualityIndicator = this.getOrInitGroupToQualityIndicator(codeScope);
        for (CheckInfo check : this.checksById.values()) {
            EFindingEnablement enablement = check.mapping.defaultEnablement;
            if (enablement == null) continue;
            CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping((String)check.mapping.group, (String)check.mapping.category, (Map)groupToQualityIndicator);
            groupToQualityIndicator.put(check.mapping.group, check.mapping.category);
            this.registerCheckInfoAsFinding(check, codeScope);
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("maxLineLength", codeScope));
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("maxDocLineLength", codeScope));
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("indentSize", codeScope));
    }

    private record CheckInfo(String plugin, CheckMapping mapping, String description, Collection<ToolCheckOption> options) {
    }
}

