/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.ILattice;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public abstract class EnumLatticeBase<EnumT extends Enum<EnumT>>
implements ILattice<EnumT> {
    private final TwoDimHashMap<EnumT, EnumT, EnumT> leastUpperBound = new TwoDimHashMap();
    private Class<EnumT> enumClass;
    private EnumT bottom;

    public EnumLatticeBase(Class<EnumT> enumClass) {
        this.enumClass = enumClass;
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        this.bottom = values[0];
        Enum top = values[values.length - 1];
        for (Enum latticeValue : values) {
            this.leastUpperBound.putValue((Object)latticeValue, (Object)latticeValue, (Object)latticeValue);
            this.leastUpperBound.putValue(this.bottom, (Object)latticeValue, (Object)latticeValue);
            this.leastUpperBound.putValue((Object)latticeValue, (Object)top, (Object)top);
        }
        this.addNonTrivialCombinations(this.leastUpperBound);
    }

    protected abstract void addNonTrivialCombinations(TwoDimHashMap<EnumT, EnumT, EnumT> var1);

    @Override
    public EnumT leastUpperBound(EnumT value1, EnumT value2) {
        EnumT lower = value1;
        EnumT higher = value2;
        if (((Enum)value1).ordinal() > ((Enum)value2).ordinal()) {
            lower = value2;
            higher = value1;
        }
        return (EnumT)((Enum)this.leastUpperBound.getValue(lower, higher));
    }

    @Override
    public EnumT getBottom() {
        return this.bottom;
    }

    @Override
    public Class<EnumT> getValueType() {
        return this.enumClass;
    }
}

