/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.graph.GraphDebuggingUtils;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.VisitorUtils;

public class ControlFlowGraph {
    private static final Logger LOGGER = LogManager.getLogger(ControlFlowGraph.class);
    private final ControlFlowNode root;
    private final String methodName;
    private final List<ShallowEntity> entities;
    private final ControlFlowNode exitNode;
    private Set<String> definedVariables = null;
    private boolean isInitializerCode;
    private final Set<VariableWrite> definedGlobalVariables = new HashSet<VariableWrite>();
    private final Set<String> usedGlobalVariables = new HashSet<String>();
    private Map<String, List<IToken>> variablesToDeclarationTokens = null;
    private final Set<ControlFlowNode> infiniteLoopNodes = new HashSet<ControlFlowNode>();

    public Set<ControlFlowNode> getInfiniteLoopNodes() {
        return this.infiniteLoopNodes;
    }

    public ControlFlowGraph(ControlFlowNode root, ControlFlowNode exitNode, String methodName, List<ShallowEntity> entities, boolean isInitializerCode) {
        this.root = root;
        this.exitNode = exitNode;
        this.methodName = methodName;
        this.entities = entities;
        this.isInitializerCode = isInitializerCode;
    }

    public List<ShallowEntity> getEntities() {
        return this.entities;
    }

    public ControlFlowNode getRoot() {
        return this.root;
    }

    public String getMethodName() {
        if (this.methodName == null) {
            return "";
        }
        return this.methodName;
    }

    public ControlFlowNode getExitNode() {
        return this.exitNode;
    }

    public List<ControlFlowNode> listDepthFirst() {
        return VisitorUtils.listAllDepthFirst((Object)this.root, ControlFlowNode.DOWN_WALKER);
    }

    public List<ControlFlowNode> listDepthFirstIncludingLambdas() {
        return VisitorUtils.listAllDepthFirst((Object)this.root, ControlFlowNode.LAMBDA_WALKER);
    }

    public Set<String> getDefinedVariables() {
        if (this.definedVariables == null) {
            this.definedVariables = new HashSet<String>();
            for (ControlFlowNode node : this.listDepthFirst()) {
                for (VariableWrite write : node.getReadWriteInfo().getAllWrites()) {
                    this.definedVariables.add(write.getChangedVariable());
                }
            }
        }
        return this.definedVariables;
    }

    public Set<String> getUsedVariables() {
        HashSet<String> usedVariables = new HashSet<String>();
        for (ControlFlowNode node : this.listDepthFirst()) {
            usedVariables.addAll(node.getReadWriteInfo().getReads());
            usedVariables.addAll(node.getReadWriteInfo().getAllWrites().stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet()));
        }
        return usedVariables;
    }

    public String toString() {
        return "CFG for " + this.methodName + ":\n" + GraphDebuggingUtils.getString((Object)this.root, ControlFlowNode::getIdAsNullable, (IMeshWalker[])new IMeshWalker[]{ControlFlowNode.DOWN_WALKER});
    }

    public boolean isInitializerCode() {
        return this.isInitializerCode;
    }

    public Collection<VariableWrite> getDefinedGlobalVariables() {
        return this.definedGlobalVariables;
    }

    public Set<String> getUsedGlobalVariables() {
        return this.usedGlobalVariables;
    }

    public Optional<ControlFlowNode> getNodeById(int nodeId) {
        return this.listDepthFirst().stream().filter(node -> node.getId() == nodeId).findFirst();
    }

    public Optional<List<IToken>> getDeclarationTokens(String variableName) {
        if (this.entities.isEmpty()) {
            return Optional.empty();
        }
        if (this.variablesToDeclarationTokens == null) {
            this.variablesToDeclarationTokens = new HashMap<String, List<IToken>>();
            Optional featureParserOpt = CLikeLanguageFeatureParserBase.getInstance((ELanguage)TokenStreamUtils.getLanguage((Collection)this.entities.getFirst().getAllTokensOfFile()));
            if (featureParserOpt.isEmpty()) {
                return Optional.empty();
            }
            CLikeLanguageFeatureParserBase featureParser = (CLikeLanguageFeatureParserBase)featureParserOpt.get();
            for (ControlFlowNode node : this.listDepthFirst()) {
                List<IToken> variableDeclarationTokens = node.getTokens();
                if (!featureParser.isVariableDeclaration(variableDeclarationTokens)) continue;
                List parsedVariables = featureParser.getVariableNamesFromTokens(variableDeclarationTokens);
                for (IToken parsedVariable : parsedVariables) {
                    this.variablesToDeclarationTokens.putIfAbsent(parsedVariable.getText(), variableDeclarationTokens);
                }
            }
        }
        return Optional.ofNullable(this.variablesToDeclarationTokens.getOrDefault(variableName, null));
    }

    public void setInfiniteLoopNodes(Set<ControlFlowNode> infiniteLoopNodes) {
        this.infiniteLoopNodes.clear();
        ArrayList<ControlFlowNode> nodesWithoutIds = new ArrayList<ControlFlowNode>();
        int maxId = 0;
        for (ControlFlowNode node : infiniteLoopNodes) {
            Integer id = node.getIdAsNullable();
            if (id == null) {
                nodesWithoutIds.add(node);
                continue;
            }
            if (!node.equals(this.getNodeById(id).orElse(null))) {
                String location = this.methodName + " in " + this.getRoot().getTokens().get(0).getLineNumber();
                LOGGER.error("Failed to set infinite loop node in method " + location + ". Node id " + id + " already taken by another node.");
                return;
            }
            this.infiniteLoopNodes.add(node);
            maxId = Math.max(maxId, id);
        }
        if (nodesWithoutIds.isEmpty()) {
            return;
        }
        maxId = Math.max(maxId, this.listDepthFirstIncludingLambdas().stream().map(ControlFlowNode::getId).max(Comparator.naturalOrder()).orElse(0));
        for (ControlFlowNode nodeWithoutId : nodesWithoutIds) {
            nodeWithoutId.setId(++maxId);
            this.infiniteLoopNodes.add(nodeWithoutId);
        }
    }
}

