/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.string.StringUtils;

public class ConditionTreeNode {
    private static final EnumSet<ETokenType> TOKENS_AFTER_TYPE_CAST = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.THIS, ETokenType.LPAREN);
    private final List<IToken> tokens = new ArrayList<IToken>();
    private EOperator operator = null;
    private final List<ConditionTreeNode> children = new ArrayList<ConditionTreeNode>();

    public UnmodifiableList<IToken> getTokens() {
        return CollectionUtils.asUnmodifiable(this.tokens);
    }

    public void appendTokens(List<IToken> tokens) {
        this.tokens.addAll(tokens);
    }

    public boolean isLeafNode() {
        return this.children.isEmpty();
    }

    public EOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EOperator operator) {
        this.operator = operator;
    }

    public UnmodifiableList<ConditionTreeNode> getChildren() {
        return CollectionUtils.asUnmodifiable(this.children);
    }

    public void addChild(ConditionTreeNode node) {
        this.children.add(node);
    }

    public String toString() {
        if (this.isLeafNode()) {
            return StringUtils.concat((Iterable)TokenStreamTextUtils.getTokenTexts(this.tokens), (String)" ");
        }
        return String.valueOf((Object)this.operator) + "{" + StringUtils.concat(this.children, (String)", ") + "}";
    }

    public void removeTypeCasts() {
        if (this.tokens == null) {
            return;
        }
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(this.tokens, 0, Arrays.asList(ETokenType.LPAREN), Arrays.asList(ETokenType.RPAREN));
        ArrayList<OffsetBasedRegion> casts = new ArrayList<OffsetBasedRegion>();
        int start = -1;
        while (iterator.hasNext()) {
            IToken token = iterator.next();
            if (token.getType() == ETokenType.LPAREN && iterator.getNestingDepth() == 1) {
                start = iterator.getCurrentIndex();
            }
            if (token.getType() != ETokenType.RPAREN || iterator.getNestingDepth() != 1) continue;
            if (!iterator.hasNext()) break;
            IToken nextToken = iterator.next();
            if (TOKENS_AFTER_TYPE_CAST.contains(nextToken.getType())) {
                casts.add(new OffsetBasedRegion(start, iterator.getCurrentIndex() - 1));
            }
            if (nextToken.getType() != ETokenType.LPAREN || iterator.getNestingDepth() != 1) continue;
            start = iterator.getCurrentIndex();
        }
        this.removeTypeCastsFromTokens(casts);
    }

    private void removeTypeCastsFromTokens(List<OffsetBasedRegion> casts) {
        for (SimpleRegion region : CollectionUtils.reverse(casts)) {
            for (int i = region.getEnd(); i >= region.getStart(); --i) {
                this.tokens.remove(i);
            }
        }
    }

    public void flatten() {
        this.flatten(null);
    }

    private void flatten(ConditionTreeNode parent) {
        for (ConditionTreeNode child : new ArrayList<ConditionTreeNode>(this.children)) {
            child.flatten(this);
        }
        if (parent != null && parent.operator == this.operator && this.operator != EOperator.NOT) {
            int index = parent.children.indexOf(this);
            parent.children.remove(index);
            parent.children.addAll(index, this.children);
        }
    }

    public static enum EOperator {
        NOT,
        AND,
        OR,
        XOR;

    }
}

