/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeDefUseHeuristicBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class DefUseHeuristicUtils {
    public static void skipToNextCommaOrEnd(TokenStreamParser parser) {
        if (!parser.skipToFirstTopLevel(EnumSet.of(ETokenType.COMMA), Arrays.asList(ETokenType.LPAREN, ETokenType.LT, ETokenType.LBRACK, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.GT, ETokenType.RBRACK, ETokenType.RBRACE))) {
            parser.consumeAnyOf(EnumSet.allOf(ETokenType.class));
        }
        parser.consumeOneOrZeroOf(EnumSet.of(ETokenType.COMMA));
    }

    public static String createParameterListParsingErrorMessage(int startIndexOfParameter, TokenStreamParser parser, String type, ShallowEntity methodEntity) {
        List tokensOfCurrentParameter = parser.getTokens().subList(startIndexOfParameter, parser.getTokens().size());
        return SourceCodeMessageUtils.createMessage((String)("Expected an identifier after type " + type + " in the parameter list of method '" + String.valueOf(methodEntity) + "', not " + String.valueOf(parser.currentType())), tokensOfCurrentParameter, (ShallowEntity)methodEntity);
    }

    public static String extractSingleTokenText(List<IToken> tokens, ETokenType.ETokenClass klass) {
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.MULT})) {
            tokens = tokens.subList(1, tokens.size());
        }
        if (tokens.size() != 1) {
            return null;
        }
        IToken token = tokens.get(0);
        if (token.getType().getTokenClass() != klass) {
            return null;
        }
        return token.getText();
    }

    public static List<IToken> cloneWithoutParenthesesAroundAssignedVar(List<IToken> tokens) {
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, CLikeDefUseHeuristicBase.ASSIGNMENT_OPERATOR})) {
            ArrayList<IToken> assignmentStmtWithoutParens = new ArrayList<IToken>(tokens.subList(3, tokens.size()));
            assignmentStmtWithoutParens.add(0, tokens.get(1));
            tokens = CollectionUtils.asUnmodifiable(assignmentStmtWithoutParens);
        }
        return tokens;
    }

    private DefUseHeuristicUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

