/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import com.teamscale.index.dataflow.controlflowgraph.utils.matcher.IShallowEntityMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;

public class TryCatchFinallyRule
implements IControlFlowRule {
    private final IShallowEntityMatcher catchMatcher;
    private final IShallowEntityMatcher finallyMatcher;

    public TryCatchFinallyRule(IShallowEntityMatcher catchMatcher, IShallowEntityMatcher finallyMatcher) {
        this.catchMatcher = catchMatcher;
        this.finallyMatcher = finallyMatcher;
    }

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        int consumedEntities = 1;
        ShallowEntity tryEntity = entities.get(0);
        ControlFlowNode tryNode = this.createTryNodeFrom(tryEntity, context);
        RuleUtils.attachLambdaGraphs(tryEntity, context, creator, tryNode);
        context.saveCurrentReturnNodes();
        context.saveCurrentLoopNodes();
        IControlFlowRule.Result tryBranch = RuleUtils.transformInNewScope(creator, context, (List<ShallowEntity>)tryEntity.getChildren());
        ArrayList<ControlFlowNode> exitNodes = new ArrayList<ControlFlowNode>();
        exitNodes.addAll(tryBranch.getExitNodes());
        ControlFlowNode.link(tryNode, tryBranch.getEntryNode());
        ArrayList<ControlFlowNode> tryBranchReturnNodes = new ArrayList<ControlFlowNode>(context.getReturnNodes());
        List<IControlFlowRule.Result> catchBranches = this.parseCatchBranches(entities, context, creator);
        consumedEntities += catchBranches.size();
        for (IControlFlowRule.Result catchBranch : catchBranches) {
            ControlFlowNode.link(tryNode, catchBranch.getEntryNode());
            exitNodes.addAll(catchBranch.getExitNodes());
            tryBranchReturnNodes.forEach(returnInTry -> ControlFlowNode.link(returnInTry, catchBranch.getEntryNode()));
        }
        List<ControlFlowNode> returnNodes = context.getReturnNodes();
        context.restorePreviousReturnNodes();
        List<ControlFlowNode> continueNodes = context.getContinueNodes();
        List<ControlFlowNode> breakNodes = context.getBreakNodes();
        context.restorePreviousLoopNodes();
        IControlFlowRule.Result finallyBranch = RuleUtils.parseEntityIfExists(this.finallyMatcher, entities, creator, context, catchBranches.size() + 1);
        if (finallyBranch == null) {
            this.handleWithoutFinallyBranch(returnNodes, continueNodes, breakNodes, context);
        } else {
            ++consumedEntities;
            this.handleWithFinallyBranch(tryNode, tryBranch, exitNodes, catchBranches, returnNodes, continueNodes, breakNodes, finallyBranch, context);
        }
        TryCatchFinallyRule.linkCatchBranchesToNormalTryExitNodes(tryBranch, catchBranches);
        return new IControlFlowRule.Result(consumedEntities, tryNode, exitNodes);
    }

    private ControlFlowNode createTryNodeFrom(ShallowEntity tryEntity, DataFlowContext context) throws ConQATException {
        if (TokenStreamUtils.startsWith((List)tryEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.LPAREN})) {
            int rParenIndex = TokenStreamUtils.findMatchingClosingToken((List)tryEntity.includedTokens(), (int)2, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (rParenIndex == -1) {
                throw new ConQATException("Could not obtain closing parenthesis.");
            }
            return context.createNode((List<IToken>)tryEntity.includedTokens().subList(0, rParenIndex + 1), false);
        }
        return context.createNode((List<IToken>)tryEntity.ownStartTokens(), false);
    }

    private void handleWithoutFinallyBranch(List<ControlFlowNode> returnNodes, List<ControlFlowNode> continueNodes, List<ControlFlowNode> breakNodes, DataFlowContext context) {
        context.getReturnNodes().addAll(returnNodes);
        context.getContinueNodes().addAll(continueNodes);
        context.getBreakNodes().addAll(breakNodes);
    }

    private void handleWithFinallyBranch(ControlFlowNode tryNode, IControlFlowRule.Result tryBranch, List<ControlFlowNode> exitNodes, List<IControlFlowRule.Result> catchBranches, List<ControlFlowNode> returnNodes, List<ControlFlowNode> continueNodes, List<ControlFlowNode> breakNodes, IControlFlowRule.Result finallyBranch, DataFlowContext context) {
        VariableReadWriteInfo exceptionInAssume = new VariableReadWriteInfo();
        exceptionInAssume.getAssignments().add(new VariableWrite("$$$UNCAUGHT_EXCEPTION$$$").setNull());
        ControlFlowNode exceptionInPathNode = new ControlFlowNode(exceptionInAssume);
        VariableReadWriteInfo noExceptionInAssume = new VariableReadWriteInfo();
        noExceptionInAssume.getAssignments().add(new VariableWrite("$$$UNCAUGHT_EXCEPTION$$$").setValue("no exception"));
        ControlFlowNode noExceptionInPathNode = new ControlFlowNode(noExceptionInAssume);
        ControlFlowNode.link(exceptionInPathNode, finallyBranch.getEntryNode());
        ControlFlowNode.link(noExceptionInPathNode, finallyBranch.getEntryNode());
        VariableReadWriteInfo exceptionOutAssume = new VariableReadWriteInfo();
        exceptionOutAssume.getAssignments().add(new VariableWrite("$$$UNCAUGHT_EXCEPTION$$$").setNull());
        ControlFlowNode exceptionOutPathNode = new ControlFlowNode(exceptionOutAssume);
        VariableReadWriteInfo noExceptionOutAssume = new VariableReadWriteInfo();
        noExceptionOutAssume.getAssignments().add(new VariableWrite("$$$UNCAUGHT_EXCEPTION$$$").setValue("no exception"));
        ControlFlowNode noExceptionOutPathNode = new ControlFlowNode(noExceptionOutAssume);
        for (ControlFlowNode exitNode : finallyBranch.getExitNodes()) {
            ControlFlowNode.link(exitNode, exceptionOutPathNode);
            ControlFlowNode.link(exitNode, noExceptionOutPathNode);
        }
        this.linkFinallyBranchToSpecialExitNodes(returnNodes, continueNodes, breakNodes, noExceptionInPathNode, noExceptionOutPathNode, context);
        TryCatchFinallyRule.linkFinallyBranchToNormalExitNodes(tryBranch, catchBranches, noExceptionInPathNode);
        ControlFlowNode.link(tryNode, exceptionInPathNode);
        exitNodes.clear();
        exitNodes.add(noExceptionOutPathNode);
        context.getReturnNodes().add(exceptionOutPathNode);
    }

    private void linkFinallyBranchToSpecialExitNodes(List<ControlFlowNode> returnNodes, List<ControlFlowNode> continueNodes, List<ControlFlowNode> breakNodes, ControlFlowNode noExceptionInPathNode, ControlFlowNode noExceptionOutPathNode, DataFlowContext context) {
        for (ControlFlowNode node : returnNodes) {
            ControlFlowNode.link(node, noExceptionInPathNode);
        }
        if (!returnNodes.isEmpty()) {
            context.getReturnNodes().add(noExceptionOutPathNode);
        }
        for (ControlFlowNode node : continueNodes) {
            ControlFlowNode.link(node, noExceptionInPathNode);
        }
        if (!continueNodes.isEmpty()) {
            context.getContinueNodes().add(noExceptionOutPathNode);
        }
        for (ControlFlowNode node : breakNodes) {
            ControlFlowNode.link(node, noExceptionInPathNode);
        }
        if (!breakNodes.isEmpty()) {
            context.getBreakNodes().add(noExceptionOutPathNode);
        }
    }

    private static void linkFinallyBranchToNormalExitNodes(IControlFlowRule.Result tryBranch, List<IControlFlowRule.Result> catchBranches, ControlFlowNode noExceptionInPathNode) {
        for (ControlFlowNode exitNode : tryBranch.getExitNodes()) {
            ControlFlowNode.link(exitNode, noExceptionInPathNode);
        }
        for (IControlFlowRule.Result catchBranch : catchBranches) {
            for (ControlFlowNode exitNode : catchBranch.getExitNodes()) {
                ControlFlowNode.link(exitNode, noExceptionInPathNode);
            }
        }
    }

    private static void linkCatchBranchesToNormalTryExitNodes(IControlFlowRule.Result tryBranch, List<IControlFlowRule.Result> catchBranches) {
        Set<ControlFlowNode> catchBranchEntryNodes = catchBranches.stream().map(branch -> branch.getEntryNode()).collect(Collectors.toSet());
        for (ControlFlowNode exitNode : tryBranch.getExitNodes()) {
            ControlFlowNode.link(exitNode, catchBranchEntryNodes);
        }
    }

    private List<IControlFlowRule.Result> parseCatchBranches(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity catchEntity;
        ArrayList<IControlFlowRule.Result> results = new ArrayList<IControlFlowRule.Result>();
        for (int currentNode = 1; currentNode < entities.size() && this.catchMatcher.matches(catchEntity = entities.get(currentNode)); ++currentNode) {
            ControlFlowNode catchNode = context.createNode((List<IToken>)catchEntity.ownStartTokens(), false);
            IControlFlowRule.Result result = RuleUtils.transformInNewScope(creator, context, (List<ShallowEntity>)catchEntity.getChildren());
            ControlFlowNode.link(catchNode, result.getEntryNode());
            results.add(new IControlFlowRule.Result(result.getNumberOfConsumedEntities(), catchNode, result.getExitNodes()));
        }
        return results;
    }
}

