/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.deadstore;

import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.DataflowFindingsCreatorBase;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.deadstore.DeadStoreAnalysis;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.jetbrains.annotations.VisibleForTesting;

public class DeadStoreAnalysisFindingsCreator
extends DataflowFindingsCreatorBase<DataflowAnalysisResult<String, DeadStoreAnalysis.ELiveness>> {
    public static final String FINDINGS_GROUP = "Unused variable or parameter";

    public DeadStoreAnalysisFindingsCreator(List<IFalsePositiveFilter> filters) {
        super(filters, FINDINGS_GROUP);
    }

    @Override
    protected void createFindingsInGroup(TokenElementInfo element, DataflowAnalysisResult<String, DeadStoreAnalysis.ELiveness> result, List<ShallowEntity> fileEntities, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        ControlFlowGraph cfg = result.getControlFlowGraph();
        this.createFindingsForControlFlowGraph(element, result, cfg, fileEntities, offsetTransformer, rawLineOffsetConverter);
    }

    private void createFindingsForControlFlowGraph(TokenElementInfo element, DataflowAnalysisResult<String, DeadStoreAnalysis.ELiveness> result, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        ArrayDeque<ControlFlowGraph> cfgsToProcess = new ArrayDeque<ControlFlowGraph>(List.of(cfg));
        HashSet<ControlFlowGraph> seenGraphs = new HashSet<ControlFlowGraph>();
        while (!cfgsToProcess.isEmpty()) {
            ControlFlowGraph graph = (ControlFlowGraph)cfgsToProcess.pop();
            if (!seenGraphs.add(graph)) continue;
            for (ControlFlowNode node : graph.listDepthFirst()) {
                cfgsToProcess.addAll((Collection<ControlFlowGraph>)node.getLambdas());
                this.createFindingsForNode(element, result, graph, node, fileEntities, offsetTransformer, rawLineOffsetConverter);
            }
        }
    }

    private void createFindingsForNode(TokenElementInfo element, DataflowAnalysisResult<String, DeadStoreAnalysis.ELiveness> result, ControlFlowGraph cfg, ControlFlowNode node, List<ShallowEntity> fileEntities, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        if (node.isSynthetic()) {
            return;
        }
        for (VariableWrite write : node.getReadWriteInfo().getAllWrites()) {
            TextRegionLocation findingLocation;
            IndexFinding finding;
            String variable = write.getChangedVariable();
            DeadStoreAnalysis.ELiveness liveness = (DeadStoreAnalysis.ELiveness)((Object)result.getFacts().getValue((Object)node, (Object)variable));
            if (liveness != DeadStoreAnalysis.ELiveness.DEAD || DeadStoreAnalysisFindingsCreator.variableIsReadAfterWrite(node, variable, element.getLanguage()) || (finding = this.createFinding(element, cfg, node, variable, fileEntities, findingLocation = DeadStoreAnalysisFindingsCreator.getFindingLocation(variable, element, node, offsetTransformer, rawLineOffsetConverter))) == null) continue;
            DeadStoreAnalysisFindingsCreator.checkLinesForUnusedParameter(finding, element, node, variable, element.getLanguage(), offsetTransformer, rawLineOffsetConverter);
        }
    }

    private static void checkLinesForUnusedParameter(IndexFinding finding, TokenElementInfo element, ControlFlowNode node, String variable, ELanguage language, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        List<IToken> tokens = node.getTokens();
        int firstTokenLine = tokens.getFirst().getLineNumber();
        int lastTokenLine = tokens.getLast().getLineNumber();
        if (DeadStoreAnalysisFindingsCreator.isFindingOnParameter(node, language) && firstTokenLine != lastTokenLine) {
            List parameterTokens = TokenStreamUtils.split(tokens, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
            Object variableTokens = CollectionUtils.emptyList();
            for (List parameter : parameterTokens) {
                if (!TokenStreamTextUtils.contains((List)parameter, (String)variable)) continue;
                variableTokens = parameter;
                break;
            }
            TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens((List<IToken>)variableTokens, element, offsetTransformer, rawLineOffsetConverter);
            finding.setLocation((ElementLocation)location);
        }
    }

    private static boolean variableIsReadAfterWrite(ControlFlowNode node, String variable, ELanguage language) {
        if (node.isConditional() && language != ELanguage.CS) {
            return true;
        }
        List<IToken> nodeTokens = node.getTokens();
        if (nodeTokens.size() <= 3) {
            return false;
        }
        List positions = TokenStreamUtils.firstTokenOfTypeSequences(nodeTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.IDENTIFIER});
        return positions.stream().anyMatch(position -> ((IToken)nodeTokens.get(position + 1)).getText().equals(variable));
    }

    @Override
    protected String getMessage(String name, ControlFlowNode node, ELanguage language, Map<?, ?> states) {
        if (DeadStoreAnalysisFindingsCreator.isFindingOnParameter(node, language)) {
            return DeadStoreAnalysisFindingsCreator.createParameterMessage(name);
        }
        if (DeadStoreAnalysisFindingsCreator.definesVariableOfName(node, name)) {
            return DeadStoreAnalysisFindingsCreator.createUnusedDeclarationMessage(name);
        }
        return DeadStoreAnalysisFindingsCreator.createUnusedAssignmentMessage(name);
    }

    public static boolean isFindingOnParameter(ControlFlowNode node, ELanguage language) {
        return language != ELanguage.ABAP && node.getPredecessors().isEmpty();
    }

    public static boolean definesVariableOfName(ControlFlowNode node, String variable) {
        for (VariableWrite write : node.getReadWriteInfo().getDefinitions()) {
            if (!write.getChangedVariable().equals(variable)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static String createUnusedAssignmentMessage(String unusedVariable) {
        return "The value assigned to variable `" + unusedVariable + "` is never read";
    }

    @VisibleForTesting
    static String createUnusedDeclarationMessage(String unusedVariable) {
        return "The initial value of variable `" + unusedVariable + "` is never read";
    }

    static String createParameterMessage(String unusedParameter) {
        return "The value of parameter `" + unusedParameter + "` is never used";
    }
}

