/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.division_by_zero;

import com.teamscale.index.dataflow.DataFlowGraph;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.PathInsensitiveDataflowAnalysisBase;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.division_by_zero.AdvancedIntVariableWriteHeuristic;
import com.teamscale.index.dataflow.division_by_zero.AdvancedIntVariableWriteResolver;
import com.teamscale.index.dataflow.division_by_zero.DivisionByZeroAnalysisFindingsCreator;
import com.teamscale.index.dataflow.division_by_zero.DivisionByZeroLattice;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class DivisionByZeroAnalysis
extends PathInsensitiveDataflowAnalysisBase<String, DivisionByZeroLattice.DivByZeroAnalysisState> {
    @Override
    protected IDataFlowGraph createDataFlowGraph(ControlFlowGraph controlFlowGraph) {
        return new DataFlowGraph(controlFlowGraph);
    }

    @Override
    protected Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> getDefaultState(ControlFlowNode node) {
        Set variableNames = node.getReadWriteInfo().getAllWrites().stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet());
        HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> defaultState = new HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState>();
        for (String key : variableNames) {
            defaultState.put(key, DivisionByZeroLattice.getUnknownState());
        }
        return defaultState;
    }

    @Override
    public EDirection getDirection() {
        return EDirection.FORWARD;
    }

    @Override
    protected UnmodifiableMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> transform(ControlFlowNode node, UnmodifiableMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> inState) throws ConQATException {
        HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> outState = new HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState>((Map<String, DivisionByZeroLattice.DivByZeroAnalysisState>)inState);
        if (DivisionByZeroAnalysis.predecessorIsCondition(node)) {
            DivisionByZeroAnalysis.handlePredecessorCondition(node, outState);
        }
        List<VariableWrite> writes = DivisionByZeroAnalysis.getWrites(node.getReadWriteInfo());
        DivisionByZeroAnalysis.handleReads(node, outState, writes);
        while (!writes.isEmpty()) {
            VariableWrite assignment = writes.get(0);
            DivisionByZeroAnalysis.processAssignment(outState, assignment, node, writes);
        }
        DivisionByZeroAnalysis.reduceToDetectedWrites(outState, node, inState);
        return CollectionUtils.asUnmodifiable(outState);
    }

    private static void reduceToDetectedWrites(Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> outState, ControlFlowNode node, UnmodifiableMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> inState) {
        Set variablesWithWrite = node.getReadWriteInfo().getAllWrites().stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet());
        HashSet<String> inValidVariableNames = new HashSet<String>();
        for (Map.Entry<String, DivisionByZeroLattice.DivByZeroAnalysisState> e : outState.entrySet()) {
            if (variablesWithWrite.contains(e.getKey()) || inState.containsKey((Object)e.getKey()) || e.getValue().getState() == DivisionByZeroLattice.EVariableState.DIV_BY_ZERO || e.getValue().getState() == DivisionByZeroLattice.EVariableState.MOD_BY_ZERO) continue;
            inValidVariableNames.add(e.getKey());
        }
        outState.keySet().removeAll(inValidVariableNames);
    }

    private static boolean predecessorIsCondition(ControlFlowNode node) {
        return !node.getPredecessors().isEmpty() && node.getPredecessors().stream().anyMatch(ControlFlowNode::isConditional);
    }

    private static void handlePredecessorCondition(ControlFlowNode node, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName) {
        Optional<ControlFlowNode> parent = node.getPredecessors().stream().filter(ControlFlowNode::isConditional).findFirst();
        if (parent.isEmpty()) {
            return;
        }
        List<IToken> tokens = parent.get().getTokens();
        Set<String> readVariables = node.getReadWriteInfo().getReads();
        HashSet<Integer> variablesToChange = new HashSet<Integer>();
        if (DivisionByZeroAnalysis.nodeIsYesPath(node)) {
            DivisionByZeroAnalysis.addNotEqualZeroSubConditions(variablesToChange, tokens);
        } else if (DivisionByZeroAnalysis.nodeIsNoPath(node)) {
            variablesToChange.addAll(TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQEQ, ETokenType.INTEGER_LITERAL}));
        }
        DivisionByZeroAnalysis.adjustIntoNonZeroStates(variablesToChange, tokens, readVariables, statesByVariableName);
    }

    private static void addNotEqualZeroSubConditions(Set<Integer> variableIndices, List<IToken> tokens) {
        variableIndices.addAll(TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.NOTEQ, ETokenType.INTEGER_LITERAL}));
        variableIndices.addAll(TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.GT, ETokenType.INTEGER_LITERAL}));
        variableIndices.addAll(TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LT, ETokenType.INTEGER_LITERAL}));
    }

    private static void adjustIntoNonZeroStates(Set<Integer> variablesToChange, List<IToken> tokens, Set<String> readVariables, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName) {
        variablesToChange = variablesToChange.stream().filter(i -> readVariables.contains(((IToken)tokens.get((int)i)).getText()) && ((IToken)tokens.get(i + 2)).getText().equals("0") && (i - 1 < 0 || ((IToken)tokens.get(i - 1)).getType() == ETokenType.LPAREN || ((IToken)tokens.get(i - 1)).getType() == ETokenType.OROR || ((IToken)tokens.get(i - 1)).getType() == ETokenType.ANDAND)).collect(Collectors.toSet());
        for (Integer index : variablesToChange) {
            statesByVariableName.put(tokens.get(index).getText(), DivisionByZeroLattice.getOtherState());
        }
    }

    private static void handleConditionalReads(ControlFlowNode node, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> outStates, Set<String> readVariables) {
        HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState> temporaryStates = new HashMap<String, DivisionByZeroLattice.DivByZeroAnalysisState>(outStates);
        List<IToken> tokens = node.getTokens();
        HashSet<Integer> variablesToChange = new HashSet<Integer>();
        DivisionByZeroAnalysis.addNotEqualZeroSubConditions(variablesToChange, tokens);
        DivisionByZeroAnalysis.adjustIntoNonZeroStates(variablesToChange, tokens, readVariables, temporaryStates);
        AdvancedIntVariableWriteResolver.addExpressionsCausingDivByZero(node, temporaryStates, outStates);
    }

    private static boolean nodeIsYesPath(ControlFlowNode node) {
        return node.getPredecessors().stream().filter(ControlFlowNode::isConditional).map(ControlFlowNode::getYesBranch).anyMatch(n -> n == node);
    }

    private static boolean nodeIsNoPath(ControlFlowNode node) {
        return node.getPredecessors().stream().filter(ControlFlowNode::isConditional).map(ControlFlowNode::getNoBranch).anyMatch(n -> n == node);
    }

    private static List<VariableWrite> getWrites(VariableReadWriteInfo readWriteInfo) {
        ArrayList<VariableWrite> writes = new ArrayList<VariableWrite>(readWriteInfo.getAllWrites());
        ArrayList<VariableWrite> assignedVariable = new ArrayList<VariableWrite>();
        for (VariableWrite write : writes) {
            if (write.getType() != VariableWrite.EVariableWriteType.VARIABLE) continue;
            assignedVariable.add(write);
        }
        writes.removeAll(assignedVariable);
        writes.addAll(assignedVariable);
        return writes;
    }

    private static void handleReads(ControlFlowNode node, Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> outStates, List<VariableWrite> writes) {
        if (!writes.isEmpty()) {
            return;
        }
        VariableReadWriteInfo readWriteInfo = node.getReadWriteInfo();
        Set writtenVariables = writes.stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet());
        Set<String> readVariables = readWriteInfo.getReads();
        readVariables.removeAll(writtenVariables);
        if (readVariables.isEmpty()) {
            return;
        }
        if (node.isConditional()) {
            DivisionByZeroAnalysis.handleConditionalReads(node, outStates, readVariables);
        } else {
            AdvancedIntVariableWriteResolver.addExpressionsCausingDivByZero(node, outStates, outStates);
        }
    }

    private static void processAssignment(Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> outState, VariableWrite assignment, ControlFlowNode node, List<VariableWrite> writes) {
        String assignedValue = assignment.getAssignedValue();
        String variableName = assignment.getChangedVariable();
        DivisionByZeroLattice.DivByZeroAnalysisState newVariableState = switch (assignment.getType()) {
            case VariableWrite.EVariableWriteType.OTHER -> DivisionByZeroAnalysis.processOtherAssignment(outState, assignment, node, writes);
            case VariableWrite.EVariableWriteType.VALUE -> {
                Optional<DivisionByZeroLattice.DivByZeroAnalysisState> extractedVariableState = DivisionByZeroAnalysis.extractVariableValue(assignedValue, node.getId());
                if (extractedVariableState.isPresent()) {
                    yield extractedVariableState.get();
                }
            }
            case VariableWrite.EVariableWriteType.VARIABLE -> {
                if (outState.containsKey(assignment.getValueVariable())) {
                    DivisionByZeroLattice.DivByZeroAnalysisState assignedState = outState.get(assignment.getValueVariable());
                    if (assignedState.getState() == DivisionByZeroLattice.EVariableState.INT_VALUE) {
                        int newValue = outState.get(assignment.getValueVariable()).getValue();
                        yield DivisionByZeroLattice.getValueState(newValue, node.getId());
                    }
                    yield assignedState;
                }
            }
            default -> DivisionByZeroLattice.getOtherState();
        };
        writes.remove(assignment);
        outState.put(variableName, newVariableState);
    }

    private static DivisionByZeroLattice.DivByZeroAnalysisState processOtherAssignment(Map<String, DivisionByZeroLattice.DivByZeroAnalysisState> statesByVariableName, VariableWrite assignment, ControlFlowNode node, List<VariableWrite> writes) {
        Optional<Integer> result = AdvancedIntVariableWriteResolver.resolveWrite(assignment, node, statesByVariableName, writes);
        if (result.isEmpty()) {
            DivisionByZeroLattice.DivByZeroAnalysisState currentState = statesByVariableName.get(assignment.getValueVariable());
            if (currentState != null && (currentState.getState() == DivisionByZeroLattice.EVariableState.DIV_BY_ZERO || currentState.getState() == DivisionByZeroLattice.EVariableState.MOD_BY_ZERO)) {
                return currentState;
            }
            return DivisionByZeroLattice.getOtherState();
        }
        return DivisionByZeroLattice.getValueState(result.get(), node.getId());
    }

    private static Optional<DivisionByZeroLattice.DivByZeroAnalysisState> extractVariableValue(String assignedValue, int nodeId) {
        if (assignedValue != null && AdvancedIntVariableWriteHeuristic.canGetIntegerFromString(assignedValue)) {
            int value = AdvancedIntVariableWriteHeuristic.getIntegerFromString(assignedValue);
            return Optional.of(DivisionByZeroLattice.getValueState(value, nodeId));
        }
        return Optional.empty();
    }

    @Override
    protected ILattice<DivisionByZeroLattice.DivByZeroAnalysisState> getLattice() {
        return DivisionByZeroLattice.INSTANCE;
    }

    @Override
    protected IDataflowFindingsCreator<DataflowAnalysisResult<String, DivisionByZeroLattice.DivByZeroAnalysisState>> createFindingsCreator(List<IFalsePositiveFilter> filters) {
        return new DivisionByZeroAnalysisFindingsCreator(filters);
    }
}

