/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.deadstore.DeadStoreAnalysisFindingsCreator;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.visitor.VisitorUtils;

public class VarReadInInfiniteLoopDeadStoreFilter
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        List sortedInfiniteLoopNodes = CollectionUtils.sort(controlFlowGraph.getInfiniteLoopNodes(), Comparator.comparing(ControlFlowNode::getId));
        for (ControlFlowNode node : sortedInfiniteLoopNodes) {
            boolean readBeforeWrite;
            List loopNodes;
            if (node == statement || this.statementIsAfterLoop(statement, loopNodes = VisitorUtils.listAllDepthFirst((Object)node, ControlFlowNode.DOWN_WALKER)) || this.variableIsDefinedInsideLoop(variable, loopNodes)) continue;
            OptionalInt firstReadIndex = VarReadInInfiniteLoopDeadStoreFilter.findFirstReadIndex(variable, loopNodes);
            OptionalInt firstWriteIndex = VarReadInInfiniteLoopDeadStoreFilter.findFirstWriteIndex(variable, loopNodes);
            boolean onlyReadExists = firstReadIndex.isPresent() && firstWriteIndex.isEmpty();
            boolean bl = readBeforeWrite = firstReadIndex.isPresent() && firstWriteIndex.isPresent() && firstReadIndex.getAsInt() <= firstWriteIndex.getAsInt();
            if (!onlyReadExists && !readBeforeWrite) continue;
            return true;
        }
        return false;
    }

    private static OptionalInt findFirstReadIndex(String variable, List<ControlFlowNode> loopNodes) {
        for (int i = 0; i < loopNodes.size(); ++i) {
            if (!loopNodes.get(i).getReadWriteInfo().getReads().contains(variable)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static OptionalInt findFirstWriteIndex(String variable, List<ControlFlowNode> loopNodes) {
        for (int i = 0; i < loopNodes.size(); ++i) {
            if (!loopNodes.get(i).getReadWriteInfo().getAllWrites().stream().map(VariableWrite::getChangedVariable).anyMatch(s -> s.equals(variable))) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private boolean statementIsAfterLoop(ControlFlowNode statement, List<ControlFlowNode> loopNodes) {
        int maxLineNumber = loopNodes.stream().filter(node -> !node.getTokens().isEmpty()).mapToInt(node -> node.getTokens().get(0).getLineNumber()).max().orElse(0);
        return statement.getTokens().get(0).getLineNumber() > maxLineNumber;
    }

    private boolean variableIsDefinedInsideLoop(String variable, List<ControlFlowNode> loopNodes) {
        for (ControlFlowNode loopNode : loopNodes) {
            if (!DeadStoreAnalysisFindingsCreator.definesVariableOfName(loopNode, variable)) continue;
            return true;
        }
        return false;
    }
}

