/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.c;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ParameterUnusedAttributeFilter
implements IFalsePositiveFilter {
    public static final ETokenType[] CPP_ANNOTATION_TEMPLATE = new ETokenType[]{ETokenType.ATTRIBUTE, ETokenType.LPAREN, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.RPAREN};
    private static final Set<String> UNUSED_ANNOTATIONS = Set.of("unused", "maybe_unused");

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        if (controlFlowGraph.getEntities().isEmpty()) {
            return false;
        }
        List<IToken> statementTokens = statement.getTokens();
        IToken variableToken = statementTokens.stream().filter(token -> token.getText().equals(variable)).findFirst().orElse(null);
        if (variableToken == null) {
            return false;
        }
        List<IToken> preprocessedFileTokens = element.getPreprocessedTokens();
        if (TokenStreamUtils.contains(statementTokens, (ETokenType)ETokenType.SEMICOLON)) {
            return ParameterUnusedAttributeFilter.isVariableAnnotated(preprocessedFileTokens, variableToken, statementTokens.get(0));
        }
        return ParameterUnusedAttributeFilter.isParameterAnnotated(preprocessedFileTokens, variableToken);
    }

    private static boolean isVariableAnnotated(List<IToken> preprocessedFileTokens, IToken variableToken, IToken statementStartToken) {
        int statementStartIndex = TokenStreamUtils.indexOfByOffset(preprocessedFileTokens, (int)statementStartToken.getOffset());
        if (statementStartIndex >= CPP_ANNOTATION_TEMPLATE.length && ParameterUnusedAttributeFilter.containsUnusedAnnotation(preprocessedFileTokens.subList(statementStartIndex - CPP_ANNOTATION_TEMPLATE.length, statementStartIndex))) {
            return true;
        }
        if (statementStartIndex + CPP_ANNOTATION_TEMPLATE.length + 1 <= preprocessedFileTokens.size() && ParameterUnusedAttributeFilter.containsUnusedAnnotation(preprocessedFileTokens.subList(statementStartIndex + 1, statementStartIndex + CPP_ANNOTATION_TEMPLATE.length + 1))) {
            return true;
        }
        List variableTokens = TokenStreamUtils.tokensAround(preprocessedFileTokens, (int)TokenStreamUtils.indexOfByOffset(preprocessedFileTokens, (int)variableToken.getOffset()), EnumSet.of(ETokenType.COMMA, variableToken.getType()), EnumSet.of(ETokenType.COMMA, ETokenType.SEMICOLON));
        return ParameterUnusedAttributeFilter.containsUnusedAnnotation(variableTokens);
    }

    private static boolean isParameterAnnotated(List<IToken> preprocessedFileTokens, IToken variableToken) {
        int variableIndex = preprocessedFileTokens.indexOf(variableToken);
        List<IToken> parameterTokens = ParameterUnusedAttributeFilter.getMethodParameterTokens(preprocessedFileTokens, variableIndex);
        return ParameterUnusedAttributeFilter.containsUnusedAnnotation(parameterTokens);
    }

    private static boolean containsUnusedAnnotation(List<IToken> parameterTokens) {
        List startingIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence(parameterTokens, (int)0, (int)parameterTokens.size(), (ETokenType[])CPP_ANNOTATION_TEMPLATE);
        for (Integer startingIndex : startingIndices) {
            if (parameterTokens.get(startingIndex).getType() != ETokenType.ATTRIBUTE || !UNUSED_ANNOTATIONS.contains(parameterTokens.get(startingIndex + 3).getText())) continue;
            return true;
        }
        return false;
    }

    private static List<IToken> getMethodParameterTokens(List<IToken> tokens, int startTokenIndex) {
        int closingIndex;
        int openingIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, (int)startTokenIndex, EnumSet.of(ETokenType.COMMA, ETokenType.LPAREN), EnumSet.of(ETokenType.RPAREN));
        if (openingIndex == -1) {
            return CollectionUtils.emptyList();
        }
        if ((closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(++openingIndex), EnumSet.of(ETokenType.LPAREN), EnumSet.of(ETokenType.COMMA, ETokenType.RPAREN))) == -1) {
            return CollectionUtils.emptyList();
        }
        return tokens.subList(openingIndex, closingIndex);
    }
}

