/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CsLocalFunctionCapturedVariableDeadStoreFilter
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        List<ShallowEntity> methodEntities = controlFlowGraph.getEntities();
        if (this.isLocalFunction(methodEntities)) {
            return false;
        }
        List localFunctions = ShallowEntityTraversalUtils.selectEntities(methodEntities, entity -> entity.getType() == EShallowEntityType.METHOD && "local function".equals(entity.getSubtype()));
        for (ShallowEntity localFunction : localFunctions) {
            if (!this.isVariableUsedInLocalFunction(variable, localFunction)) continue;
            return true;
        }
        return false;
    }

    private boolean isLocalFunction(List<ShallowEntity> methodEntities) {
        return !methodEntities.isEmpty() && "local function".equals(methodEntities.get(0).getSubtype());
    }

    private boolean isVariableUsedInLocalFunction(String variable, ShallowEntity localFunction) {
        UnmodifiableList tokens = localFunction.includedTokens();
        boolean isUsed = false;
        boolean isDeclared = false;
        for (int i = 0; i < tokens.size(); ++i) {
            IToken token = (IToken)tokens.get(i);
            if (token.getType() != ETokenType.IDENTIFIER || !token.getText().equals(variable)) continue;
            isUsed = true;
            if (i <= 0 || !this.isTypeOrVarToken((IToken)tokens.get(i - 1))) continue;
            isDeclared = true;
        }
        return isUsed && !isDeclared;
    }

    private boolean isTypeOrVarToken(IToken token) {
        ETokenType type = token.getType();
        if (type == ETokenType.VAR || type == ETokenType.INT || type == ETokenType.LONG || type == ETokenType.SHORT || type == ETokenType.BYTE || type == ETokenType.FLOAT || type == ETokenType.DOUBLE || type == ETokenType.BOOL || type == ETokenType.CHAR || type == ETokenType.STRING || type == ETokenType.OBJECT || type == ETokenType.VOID || type == ETokenType.DECIMAL) {
            return true;
        }
        return type == ETokenType.IDENTIFIER || type == ETokenType.GT;
    }
}

