/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDataFlowHeuristic;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MethodIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodIndex methodIndex;

    public void execute() throws StorageException {
        this.methodIndex.removeFiles(this.contentDelta.getDeletedKeysAsStrings());
        List addedOrChangedFiles = this.contentDelta.getAddedOrChangedKeysAsStrings();
        PairList uniformPathToMethod = new PairList();
        List<TokenElementInfo> tokenElements = this.contentIndex.getTokenElements(addedOrChangedFiles);
        for (TokenElementInfo tokenElement : tokenElements) {
            IDataFlowHeuristic dataFlowHeuristic;
            if (!DataFlowHeuristicFactory.SUPPORTED_LANGUAGES.contains(tokenElement.getLanguage())) continue;
            try {
                dataFlowHeuristic = DataFlowHeuristicFactory.createDataFlowHeuristic(tokenElement.getLanguage());
            }
            catch (ConQATException e) {
                LOGGER.error("Could not create data-flow heuristic for " + String.valueOf(tokenElement.getLanguage()) + ": " + e.getMessage(), (Throwable)e);
                continue;
            }
            UnmodifiableList<ShallowEntity> entities = tokenElement.getShallowEntitiesWithPreprocessorTokens();
            PairList<String, List<ShallowEntity>> executables = dataFlowHeuristic.extractExecutables(tokenElement.getUniformPath(), (List<ShallowEntity>)entities);
            uniformPathToMethod.add((Object)tokenElement.getUniformPath(), (Object)executables.extractFirstList());
        }
        this.methodIndex.setValues((PairList<String, Collection<String>>)uniformPathToMethod);
    }
}

