/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.dependencies.TypeInfo;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="types", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED}, valueClasses={TypeInfo.class})
public class TypeIndex
extends IndexBase
implements IProjectIndex,
ITypeIndex {
    public static final String INDEX_NAME = "types";
    public static final String FILE_PREFIX = "file:";
    public static final String TYPE_PREFIX = "type:";

    public TypeIndex(IStore store) {
        super(store);
    }

    public List<List<String>> getTypeNamesForFiles(List<String> uniformPaths) throws StorageException {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (byte[] bytes : this.store.getWithStrings(TypeIndex.createFileKeys(uniformPaths))) {
            TypeInfo typeInfo = (TypeInfo)StorageUtils.deserialize((byte[])bytes);
            if (typeInfo != null) {
                result.add(new ArrayList<String>((Collection<String>)typeInfo.getTypeNames()));
                continue;
            }
            result.add((List<String>)CollectionUtils.emptyList());
        }
        return result;
    }

    @Override
    public List<List<String>> getFilesForTypes(Collection<String> typeNames) throws StorageException {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (byte[] value : this.store.getWithStrings(TypeIndex.createTypeKeys(typeNames))) {
            result.add(TypeIndex.getFileList(value));
        }
        return result;
    }

    private static List<String> getFileList(byte[] value) throws StorageException {
        if (value != null) {
            return TypeIndex.stringListFromBytes(value);
        }
        return CollectionUtils.emptyList();
    }

    @Override
    public Set<String> getAllTypeNames() throws StorageException {
        return this.scanKeysWithPrefix(TYPE_PREFIX);
    }

    public Set<String> getExistingFiles(List<String> uniformPaths) throws StorageException {
        List<String> keys = TypeIndex.createFileKeys(uniformPaths);
        List result = this.store.getWithStrings(keys);
        HashSet<String> existingUniformPaths = new HashSet<String>();
        for (int i = 0; i < keys.size(); ++i) {
            if (result.get(i) == null) continue;
            existingUniformPaths.add(uniformPaths.get(i));
        }
        return existingUniformPaths;
    }

    public Set<String> getAllFiles() throws StorageException {
        return this.scanKeysWithPrefix(FILE_PREFIX);
    }

    public Set<String> getFilesWithPathPrefix(String pathPrefix) throws StorageException {
        return this.scanKeysWithPrefix(FILE_PREFIX + pathPrefix).stream().map(path -> pathPrefix + path).collect(Collectors.toSet());
    }

    @Override
    public ListMap<String, String> getTypeFileLookupMap() throws StorageException {
        final ListMap lookupMap = new ListMap();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                String type = StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)TypeIndex.TYPE_PREFIX);
                List<String> files = TypeIndex.getFileList(value);
                if (!files.isEmpty()) {
                    lookupMap.addAll((Object)type, files);
                }
            }
        };
        this.store.scan(TYPE_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return lookupMap;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<String> getMissingTypes(List<String> uniformPaths) throws StorageException {
        ArrayList<String> missingTypes = new ArrayList<String>();
        List<String> keys = uniformPaths.stream().map(TypeIndex::createTypeKey).toList();
        @Nullable List typeInfos = this.store.getWithStrings(keys);
        for (int i = 0; i < typeInfos.size(); ++i) {
            byte[] typeInfo = (byte[])typeInfos.get(i);
            if (typeInfo != null) continue;
            missingTypes.add(uniformPaths.get(i));
        }
        return missingTypes;
    }

    public Map<String, TypeInfo> getUniformPathToTypesMap() throws StorageException {
        final HashMap<String, TypeInfo> uniformPathToTypes = new HashMap<String, TypeInfo>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                uniformPathToTypes.put(StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)TypeIndex.FILE_PREFIX), (TypeInfo)StorageUtils.deserialize((byte[])value));
            }
        };
        this.store.scan(FILE_PREFIX, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return uniformPathToTypes;
    }

    @Override
    public TypeInfo getTypeInfo(String uniformPath) throws StorageException {
        return (TypeInfo)StorageUtils.deserialize((byte[])this.store.getWithString(TypeIndex.createFileKey(uniformPath)));
    }

    private Set<String> scanKeysWithPrefix(@NonNull String prefix) throws StorageException {
        HashSet keys = new HashSet();
        KeyCollectingCallback callback = new KeyCollectingCallback(keys);
        this.store.scanKeys(StringUtils.stringToBytes((String)prefix), (IKeyValueCallback)callback);
        HashSet<String> result = new HashSet<String>();
        for (byte[] key : keys) {
            result.add(StringUtils.stripPrefix((String)StringUtils.bytesToString((byte[])key), (String)prefix));
        }
        return result;
    }

    public void setValues(PairList<String, TypeInfo> uniformPathToType) throws StorageException {
        this.removeInverseMappings(uniformPathToType.extractFirstList());
        PairList valuesToSet = new PairList();
        ListMap typeToPathMappings = new ListMap();
        for (int i = 0; i < uniformPathToType.size(); ++i) {
            String uniformPath = (String)uniformPathToType.getFirst(i);
            String fileKey = FILE_PREFIX + uniformPath;
            TypeInfo typeInfo = (TypeInfo)uniformPathToType.getSecond(i);
            valuesToSet.add((Object)fileKey, (Object)StorageUtils.serialize((Serializable)typeInfo));
            for (String type : typeInfo.getTypeNames()) {
                typeToPathMappings.add((Object)type, (Object)uniformPath);
            }
        }
        List<String> typeKeysToUpdate = TypeIndex.createTypeKeys((Collection<String>)typeToPathMappings.getKeys());
        List existingTypes = this.store.getWithStrings(typeKeysToUpdate);
        for (int i = 0; i < typeKeysToUpdate.size(); ++i) {
            String typeKey = StringUtils.stripPrefix((String)typeKeysToUpdate.get(i), (String)TYPE_PREFIX);
            HashSet<String> paths = new HashSet<String>();
            if (existingTypes.get(i) != null) {
                paths.addAll(TypeIndex.stringListFromBytes((byte[])existingTypes.get(i)));
            }
            paths.addAll(Objects.requireNonNull((List)typeToPathMappings.getCollection((Object)typeKey)));
            valuesToSet.add((Object)(TYPE_PREFIX + typeKey), (Object)TypeIndex.sortAndSerialize(paths));
        }
        this.store.putWithStrings(valuesToSet);
    }

    private static byte[] sortAndSerialize(Set<String> paths) throws StorageException {
        return StorageUtils.serialize(new ArrayList(CollectionUtils.sort(paths)));
    }

    public void removeFiles(List<String> uniformPaths) throws StorageException {
        this.removeInverseMappings(uniformPaths);
        this.store.removeWithStrings(TypeIndex.createFileKeys(uniformPaths));
    }

    private void removeInverseMappings(List<String> uniformPaths) throws StorageException {
        HashSet<String> types = new HashSet<String>();
        for (byte[] value : this.store.getWithStrings(TypeIndex.createFileKeys(uniformPaths))) {
            if (value == null) continue;
            types.addAll((Collection<String>)((TypeInfo)StorageUtils.deserialize((byte[])value)).getTypeNames());
        }
        PairList valuesToSet = new PairList();
        ArrayList<CallSite> keysToRemove = new ArrayList<CallSite>();
        ArrayList<String> typeList = new ArrayList<String>(types);
        List<List<String>> filesForTypes = this.getFilesForTypes(typeList);
        for (int i = 0; i < typeList.size(); ++i) {
            HashSet<String> newFiles = new HashSet<String>((Collection)filesForTypes.get(i));
            CollectionUtils.removeAll(newFiles, uniformPaths);
            if (newFiles.isEmpty()) {
                keysToRemove.add((CallSite)((Object)(TYPE_PREFIX + (String)typeList.get(i))));
                continue;
            }
            valuesToSet.add((Object)(TYPE_PREFIX + (String)typeList.get(i)), (Object)TypeIndex.sortAndSerialize(newFiles));
        }
        this.store.removeWithStrings(keysToRemove);
        this.store.putWithStrings(valuesToSet);
    }

    private static ArrayList<String> stringListFromBytes(byte[] bytes) throws StorageException {
        return (ArrayList)StorageUtils.deserialize((byte[])bytes);
    }

    private static List<String> createTypeKeys(Collection<String> typeNames) {
        return typeNames.stream().map(TypeIndex::createTypeKey).toList();
    }

    private static List<String> createFileKeys(List<String> uniformPaths) {
        return uniformPaths.stream().map(TypeIndex::createFileKey).toList();
    }

    private static String createFileKey(String uniformPath) {
        return FILE_PREFIX + uniformPath;
    }

    private static String createTypeKey(String uniformPath) {
        return TYPE_PREFIX + uniformPath;
    }
}

