/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap.cds;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.abap.AbapDependencyCollection;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class AbapCdsDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TokenTypePattern DDLS_SELECT_PATTERN = new TokenTypePattern("(<AS>|<UNION>)<SELECT>(<DISTINCT>)?<FROM><IDENTIFIER>");
    private static final TokenTypePattern DDLS_SELECT_JOIN_PATTERN = new TokenTypePattern("(<INNER>|<LEFT>|<RIGHT>|<OUTER>|<CROSS>)?<JOIN><IDENTIFIER>");
    private static final TokenTypePattern DDLS_PROJECTION_PATTERN = new TokenTypePattern("<AS><PROJECTION><ON><IDENTIFIER>");
    private static final TokenTypePattern DDLS_ANNOTATION_PATTERN = new TokenTypePattern("<AT_OPERATOR><IDENTIFIER><DOT><IDENTIFIER><COLON>");
    private static final TokenTypePattern DDLS_ATTRIBUTE_PATTERN = new TokenTypePattern("<IDENTIFIER><COLON><STRING_LITERAL>");
    private static final String DDLS_OBJECTMODEL_ANNOTATION_PREFIX = "ABAP:";
    private static final TokenTypePattern BDEF_ROOT_ENTITY_PATTERN = new TokenTypePattern("<DEFINE><BEHAVIOR><FOR><IDENTIFIER>");
    private static final TokenTypePattern BDEF_IMPLEMENTATION_PATTERN = new TokenTypePattern("<IMPLEMENTATION><IN><CLASS><IDENTIFIER>");
    private static final TokenTypePattern BDEF_PERSISTENT_TABLE_PATTERN = new TokenTypePattern("<PERSISTENT><TABLE><IDENTIFIER>");
    private static final TokenTypePattern BDEF_DRAFT_TABLE_PATTERN = new TokenTypePattern("<DRAFT><TABLE><IDENTIFIER>");
    private static final TokenTypePattern SRVD_EXPOSE_ENTITY_PATTERN = new TokenTypePattern("<EXPOSE><IDENTIFIER>");
    private static final TokenTypePattern DCLS_RULE_ENTITY_PATTERN = new TokenTypePattern("<GRANT><SELECT><ON><IDENTIFIER>");
    private AbapDependencyCollection dependencyCollection;

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        this.dependencyCollection = new AbapDependencyCollection(this.uniformPath, this.settings, this.typeLookupEnvironment, this.dependencyExtractionIndexes.abapThirdPartyPathsIndex);
        UniqueAbapElementName ownElementName = AbapUtils.createElementNameFromPath((String)this.uniformPath);
        if (ownElementName == null) {
            LOGGER.warn("Unable to extract dependencies from " + this.uniformPath + " as ABAP element path");
            return Collections.emptyList();
        }
        List<IToken> tokens = AbapCdsDependencyExtractor.getRawTokensWithoutComments(tokenElementInfo);
        UnmodifiableList<ShallowEntity> entities = tokenElementInfo.getShallowEntitiesWithPreprocessorTokens();
        switch (ownElementName.getObjectType()) {
            case DDLS: {
                this.processCdsViewOrCdsViewEntity(tokens, (List<ShallowEntity>)entities);
                break;
            }
            case BDEF: {
                this.processBehaviorDefinition(tokens);
                break;
            }
            case SRVD: {
                this.processServiceDefinition(tokens);
                break;
            }
            case DCLS: {
                this.processAccessControlObject(tokens);
                break;
            }
            default: {
                throw new StorageException("Unable to extract dependencies from " + this.uniformPath + " as ABAP element path. Object type not supported.");
            }
        }
        return Collections.singletonList(new TypeDependencies(ownElementName.getUniqueName(), this.dependencyCollection.getDependencies()));
    }

    private void processCdsViewOrCdsViewEntity(List<IToken> tokens, List<ShallowEntity> entities) throws StorageException {
        this.processDdlsDataSource(tokens);
        this.processDdlsProjections(tokens);
        this.processDdlsAssociationOrComposition(tokens);
        this.processDdlsConsumptionAnnotations(tokens);
        this.processDdlsCalculatedByAnnotations(tokens);
        for (ShallowEntity methodEntity : ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (!methodEntity.getSubtype().equals("Table Function Definition")) continue;
            this.processTableFunctionDefinition(methodEntity);
        }
    }

    private void processTableFunctionDefinition(ShallowEntity tableFunctionEntity) throws StorageException {
        UnmodifiableList tokens = tableFunctionEntity.includedTokens();
        int implementationNoteStartIndex = TokenStreamTextUtils.findSequence((List)tokens, (boolean)false, (String[])new String[]{"implemented", "by", "method"});
        int identifierTokenIndex = implementationNoteStartIndex + 3;
        if (identifierTokenIndex >= tokens.size() || ((IToken)tokens.get(identifierTokenIndex)).getType() != ETokenType.IDENTIFIER) {
            return;
        }
        IToken identifier = (IToken)tokens.get(identifierTokenIndex);
        this.dependencyCollection.addDependency(identifier.getText(), identifier, EnumSet.of(EAbapObjectType.CLAS));
    }

    private void processDdlsDataSource(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, DDLS_SELECT_PATTERN);
        this.addDependencyOfMatchingPattern(tokens, DDLS_SELECT_JOIN_PATTERN);
    }

    private void processDdlsProjections(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, DDLS_PROJECTION_PATTERN, EAbapObjectType.DDLS);
    }

    private void processDdlsAssociationOrComposition(List<IToken> tokens) throws StorageException {
        Iterator iterator = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMPOSITION, ETokenType.ASSOCIATION})).iterator();
        while (iterator.hasNext()) {
            int tokenIndex = (Integer)iterator.next();
            if (tokenIndex + 2 > tokens.size()) continue;
            TokenStreamParser parser = new TokenStreamParser(tokens, tokenIndex + 1);
            if (parser.currentType() == ETokenType.LBRACK) {
                parser.skipBalanced(ETokenType.LBRACK, ETokenType.RBRACK, EnumSet.complementOf(EnumSet.of(ETokenType.LBRACK, ETokenType.RBRACK)));
            }
            if (parser.consumeAnyOf(EnumSet.of(ETokenType.TO, ETokenType.OF)).isEmpty()) continue;
            if (parser.currentText().equalsIgnoreCase("parent")) {
                parser.consumeOneOrZeroOf(parser.currentType());
            }
            if (parser.isDone() || parser.currentType() != ETokenType.IDENTIFIER) continue;
            IToken targetNameToken = parser.getCurrentToken();
            this.dependencyCollection.processTypeReference(targetNameToken.getText(), targetNameToken);
        }
    }

    private void processDdlsConsumptionAnnotations(List<IToken> tokens) throws StorageException {
        for (List<IToken> consumptionTokens : AbapCdsDependencyExtractor.getAnnotationBodies(tokens, "Consumption", "valueHelpDefinition")) {
            for (List attributeTokens : DDLS_ATTRIBUTE_PATTERN.matchAll(consumptionTokens)) {
                if (!((IToken)attributeTokens.get(0)).getText().equals("name")) continue;
                IToken attributeValueToken = (IToken)CollectionUtils.getLast((List)attributeTokens);
                String targetName = StringUtils.removeSingleQuotes((String)attributeValueToken.getText());
                this.dependencyCollection.processTypeReference(targetName, attributeValueToken);
            }
        }
    }

    private void processDdlsCalculatedByAnnotations(List<IToken> tokens) throws StorageException {
        for (List<IToken> consumptionTokens : AbapCdsDependencyExtractor.getAnnotationBodies(tokens, "ObjectModel", "virtualElementCalculatedBy")) {
            IToken annotationValueToken;
            String annotationValue;
            if (consumptionTokens.size() != 1 || !(annotationValue = StringUtils.removeSingleQuotes((String)(annotationValueToken = consumptionTokens.get(0)).getText())).startsWith(DDLS_OBJECTMODEL_ANNOTATION_PREFIX)) continue;
            String boundClass = StringUtils.stripPrefix((String)annotationValue, (String)DDLS_OBJECTMODEL_ANNOTATION_PREFIX);
            this.dependencyCollection.addDependency(boundClass, annotationValueToken, EnumSet.of(EAbapObjectType.CLAS));
        }
    }

    private void processBehaviorDefinition(List<IToken> tokens) throws StorageException {
        this.processBdefRootEntity(tokens);
        this.processBdefHeader(tokens);
        this.processBdefPersistentTable(tokens);
        this.processBdefDraftTable(tokens);
    }

    private void processBdefRootEntity(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, BDEF_ROOT_ENTITY_PATTERN, EAbapObjectType.DDLS);
    }

    private void processBdefHeader(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, BDEF_IMPLEMENTATION_PATTERN, EAbapObjectType.CLAS);
    }

    private void processBdefPersistentTable(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, BDEF_PERSISTENT_TABLE_PATTERN);
    }

    private void processBdefDraftTable(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, BDEF_DRAFT_TABLE_PATTERN);
    }

    private void processServiceDefinition(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, SRVD_EXPOSE_ENTITY_PATTERN, EAbapObjectType.DDLS);
    }

    private void processAccessControlObject(List<IToken> tokens) throws StorageException {
        this.addDependencyOfMatchingPattern(tokens, DCLS_RULE_ENTITY_PATTERN, EAbapObjectType.DDLS);
    }

    private static List<List<IToken>> getAnnotationBodies(List<IToken> tokens, String mainAnnotation, String subAnnotation) {
        return DDLS_ANNOTATION_PATTERN.matchAll(tokens).stream().filter(matchedTokens -> ((IToken)matchedTokens.get(1)).getText().equals(mainAnnotation) && ((IToken)matchedTokens.get(3)).getText().equals(subAnnotation)).map(annotationTokens -> AbapCdsDependencyExtractor.getBodyTokens(tokens, annotationTokens)).filter(Predicate.not(List::isEmpty)).collect(Collectors.toList());
    }

    private static List<IToken> getBodyTokens(List<IToken> tokens, List<IToken> annotationTokens) {
        int bodyStartIndex = tokens.indexOf(CollectionUtils.getLast(annotationTokens));
        IToken firstBodyToken = tokens.get(bodyStartIndex + 1);
        if (firstBodyToken.getType() == ETokenType.STRING_LITERAL) {
            return List.of(firstBodyToken);
        }
        return TokenStreamUtils.tokensBetweenWithNesting(tokens, (int)bodyStartIndex, (ETokenType)ETokenType.LBRACK, (ETokenType)ETokenType.RBRACK);
    }

    private void addDependencyOfMatchingPattern(List<IToken> tokens, TokenTypePattern pattern, EAbapObjectType objectType) throws StorageException {
        for (List match : pattern.matchAll(tokens)) {
            IToken token = (IToken)CollectionUtils.getLast((List)match);
            String targetName = token.getText();
            this.dependencyCollection.addDependency(targetName, token, EnumSet.of(objectType));
        }
    }

    private void addDependencyOfMatchingPattern(List<IToken> tokens, TokenTypePattern pattern) throws StorageException {
        for (List match : pattern.matchAll(tokens)) {
            IToken token = (IToken)CollectionUtils.getLast((List)match);
            String targetName = token.getText();
            this.dependencyCollection.processTypeReference(targetName, token);
        }
    }
}

