/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.javascript.CommonJSDependencyExtractor;
import com.teamscale.index.dependencies.javascript.ES6DependencyExtractor;
import com.teamscale.index.dependencies.javascript.TypescriptPathMappings;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.javascript.JavascriptDependencyUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class JavascriptDependencyExtractor
extends DependencyExtractorBase {
    private static final String TYPESCRIPT_FILE_EXTENSION_REGEX = "(\\.tsx$|(\\.d)?\\.ts$)";
    private TypescriptPathMappings pathMappings;

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        this.pathMappings = this.dependencyExtractionIndexes.tsconfigPathsIndex.getKnownPathMappings(this.uniformPath);
        ListMap dependencyLocations = new ListMap();
        ES6DependencyExtractor es6Extractor = new ES6DependencyExtractor(this);
        CommonJSDependencyExtractor commonJSExtractor = new CommonJSDependencyExtractor(this);
        dependencyLocations.addAll(es6Extractor.getDependenciesLocations(tokenElementInfo));
        dependencyLocations.addAll(this.getTypeScriptDependencies(tokenElementInfo));
        dependencyLocations.addAll(commonJSExtractor.getDependenciesLocations(tokenElementInfo));
        return List.of(JavascriptDependencyExtractor.createTypeDependencies(tokenElementInfo, (ListMap<String, ElementLocation>)dependencyLocations));
    }

    private ListMap<String, ElementLocation> getTypeScriptDependencies(TokenElementInfo tokenElementInfo) {
        ListMap locations = new ListMap();
        for (ShallowEntity entity : tokenElementInfo.getShallowEntitiesWithoutPreprocessorTokens()) {
            String typeName;
            String fileType;
            if (entity.getType() != EShallowEntityType.META || !entity.getSubtype().equals("triple slash directive import")) continue;
            String referencePath = StringUtils.removeWhitespace((String)entity.getName());
            referencePath = StringUtils.getLastPart((String)referencePath, (char)'=');
            referencePath = StringUtils.removeAll((String)referencePath, (String[])new String[]{"/>", "\"", "'"});
            Matcher extensionMatcher = Pattern.compile(TYPESCRIPT_FILE_EXTENSION_REGEX).matcher(referencePath);
            if (!extensionMatcher.find() || !this.typeLookupEnvironment.hasTypeWithPrefix(fileType = JavascriptDependencyUtils.createFileType((String)(typeName = this.createTypeNameFromPathOrEntityName(referencePath = referencePath.substring(0, extensionMatcher.start())))))) continue;
            locations.add((Object)fileType, (Object)JavascriptDependencyExtractor.createDependencyLocation(tokenElementInfo, entity));
        }
        return locations;
    }

    private static TypeDependencies createTypeDependencies(TokenElementInfo tokenElementInfo, ListMap<String, ElementLocation> locations) {
        String fileTypePrefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)tokenElementInfo.getUniformPath());
        return new TypeDependencies(JavascriptDependencyUtils.createFileType((String)fileTypePrefix), locations);
    }

    protected static TextRegionLocation createDependencyLocation(TokenElementInfo tokenElementInfo, ShallowEntity entity) {
        return DependencyExtractorBase.createLocation(tokenElementInfo.getUniformPath(), (IToken)tokenElementInfo.getTokens().get(entity.getStartTokenIndex()));
    }

    private String createTypeNameFromPathOrEntityName(String relativePath) {
        relativePath = StringUtils.removeAll((String)relativePath, (String[])new String[]{"\"", "'"});
        String fullPath = UniformPathUtils.resolveRelativePath((String)this.uniformPath, (String)relativePath);
        return JavascriptDependencyUtils.normalizeSlashes((String)fullPath);
    }

    protected List<String> resolveStarDependency(String importString) {
        return this.resolveDependency(true, importString, Collections.emptyList());
    }

    protected List<String> resolveSingleDependency(String importString, String member) {
        return this.resolveMemberDependencies(importString, Collections.singletonList(member));
    }

    protected List<String> resolveMemberDependencies(String importString, List<String> members) {
        return this.resolveDependency(false, importString, members);
    }

    private List<String> resolveDependency(boolean starImport, String importString, List<String> suffixes) {
        String unquotedImportString = importString.substring(1, importString.length() - 1);
        if (this.isRelativePath(unquotedImportString = this.resolvePathMappings(unquotedImportString), starImport)) {
            return this.handleRelativePath(starImport, suffixes, unquotedImportString);
        }
        if (unquotedImportString.startsWith("file://")) {
            return this.handleAbsolutePath(starImport, suffixes, unquotedImportString.substring(7));
        }
        if (unquotedImportString.startsWith("/")) {
            return this.handleAbsolutePath(starImport, suffixes, unquotedImportString);
        }
        return this.handleUnanchoredPath(starImport, unquotedImportString, suffixes);
    }

    private boolean isRelativePath(String unquotedImportString, boolean starImport) {
        if (unquotedImportString.startsWith(".")) {
            return true;
        }
        String typePrefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)UniformPathUtils.resolveRelativePath((String)this.uniformPath, (String)unquotedImportString));
        if (starImport) {
            typePrefix = JavascriptDependencyUtils.createFileType((String)typePrefix);
        }
        return this.typeLookupEnvironment.hasTypeWithPrefix(typePrefix);
    }

    private String resolvePathMappings(String importString) {
        if (importString.startsWith(".")) {
            return importString;
        }
        List<String> potentialResolutions = this.pathMappings.resolvePathPrefix(importString);
        for (String potentialResolution : potentialResolutions) {
            String typeFormat = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)potentialResolution);
            if (!this.typeLookupEnvironment.hasTypeWithPrefix(typeFormat)) continue;
            Object relativePath = Path.of(UniformPathUtils.getParentPath((String)this.uniformPath), new String[0]).relativize(Path.of(potentialResolution, new String[0])).toString();
            if (!((String)relativePath).startsWith("../")) {
                relativePath = "./" + (String)relativePath;
            }
            return relativePath;
        }
        return importString;
    }

    private List<String> handleHeuristically(boolean starImport, String unquotedImportString, List<String> suffixes) {
        if (starImport) {
            return this.handleStarImportHeuristically(unquotedImportString);
        }
        return this.handleImportHeuristically(unquotedImportString, suffixes);
    }

    private List<String> handleStarImportHeuristically(String unquotedImportString) {
        String starImportType;
        String normalized = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)unquotedImportString).toLowerCase();
        if (this.typeLookupEnvironment.getTypeWithSuffixOverlap(normalized).isPresent()) {
            starImportType = this.typeLookupEnvironment.getTypeWithSuffixOverlap(normalized).get();
        } else if (this.typeLookupEnvironment.getTypeWithSuffixOverlap(String.join((CharSequence)".", normalized, "index")).isPresent()) {
            starImportType = this.typeLookupEnvironment.getTypeWithSuffixOverlap(String.join((CharSequence)".", normalized, "index")).get();
        } else {
            if (this.settings.includeThirdPartyDependencies) {
                return Collections.singletonList("file:".concat(normalized));
            }
            return Collections.emptyList();
        }
        if (starImportType.startsWith("file:")) {
            return Collections.singletonList(starImportType);
        }
        return Collections.emptyList();
    }

    private List<String> handleImportHeuristically(String unquotedImportString, List<String> suffixes) {
        if (suffixes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(suffixes.size());
        String prefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)unquotedImportString);
        String firstSuffix = suffixes.get(0);
        Optional<String> possibleTypeForFirstSuffix = this.typeLookupEnvironment.getTypeWithSuffixOverlap(String.join((CharSequence)".", prefix, firstSuffix));
        if (possibleTypeForFirstSuffix.isPresent()) {
            results.add(possibleTypeForFirstSuffix.get());
        } else {
            Optional<String> possibleTypeForFirstSuffixWithIndexAppended = this.typeLookupEnvironment.getTypeWithSuffixOverlap(String.join((CharSequence)".", prefix, "index", firstSuffix));
            if (!possibleTypeForFirstSuffixWithIndexAppended.isPresent()) {
                return this.prefixIfThirdPartyDependencyEnabled(prefix, suffixes);
            }
            results.add(possibleTypeForFirstSuffixWithIndexAppended.get());
            prefix = String.join((CharSequence)".", prefix, "index");
        }
        for (String suffix : suffixes.subList(1, suffixes.size())) {
            Optional<String> possibleTypeForSuffix = this.typeLookupEnvironment.getTypeWithSuffixOverlap(String.join((CharSequence)".", prefix, suffix));
            possibleTypeForSuffix.ifPresent(results::add);
        }
        return results;
    }

    private List<String> handleUnanchoredPath(boolean starImport, String unquotedImportString, List<String> suffixes) {
        return this.handleHeuristically(starImport, unquotedImportString, suffixes);
    }

    private List<String> handleAbsolutePath(boolean starImport, List<String> suffixes, String unquotedImportString) {
        return this.handleUnanchoredPath(starImport, unquotedImportString, suffixes);
    }

    private List<String> prefixIfThirdPartyDependencyEnabled(String thirdPartyPrefix, List<String> suffixes) {
        if (this.settings.includeThirdPartyDependencies) {
            return CollectionUtils.map(suffixes, suffix -> String.join((CharSequence)".", thirdPartyPrefix, suffix));
        }
        return Collections.emptyList();
    }

    private List<String> handleRelativePath(boolean starImport, List<String> suffixes, String unquotedImportString) {
        String typePrefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat((String)UniformPathUtils.resolveRelativePath((String)this.uniformPath, (String)unquotedImportString));
        if (starImport) {
            typePrefix = JavascriptDependencyUtils.createFileType((String)typePrefix);
        }
        if (!this.typeLookupEnvironment.hasTypeWithPrefix(typePrefix)) {
            return Collections.emptyList();
        }
        String possibleIndexTypePrefix = String.join((CharSequence)".", typePrefix, "index");
        if (this.typeLookupEnvironment.hasTypeWithPrefix(possibleIndexTypePrefix)) {
            typePrefix = possibleIndexTypePrefix;
        }
        if (starImport) {
            if (this.typeLookupEnvironment.isKnownType(typePrefix)) {
                return Collections.singletonList(typePrefix);
            }
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(suffixes.size());
        for (String suffix : suffixes) {
            String fullType = String.join((CharSequence)".", typePrefix, suffix);
            if (!this.typeLookupEnvironment.isKnownType(fullType)) continue;
            result.add(fullType);
        }
        return result;
    }
}

