/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.php;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.php.PhpDependencyAnalysisUtils;
import com.teamscale.index.dependencies.php.PhpShallowEntityVisitorBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PhpDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> REQUIRE_SUBTYPES = new HashSet<String>(Arrays.asList("require", "require_once", "include", "include_once"));
    private static final EnumSet<ETokenType> IGNORED_IDENTIFIER_PREDECESSORS = EnumSet.of(ETokenType.ARROW, ETokenType.CLASS, ETokenType.FUNCTION, ETokenType.DOUBLE_COLON);
    private final List<TypeDependencies> dependencies = new ArrayList<TypeDependencies>();

    public PhpDependencyExtractor() {
        super(ETokenType.BACKSLASH);
    }

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws ConQATException {
        DependencyExtractingPhpShallowEntityVisitor visitor = new DependencyExtractingPhpShallowEntityVisitor(this);
        ShallowEntity.traverse(tokenElementInfo.getRawShallowEntities(), (IShallowEntityVisitor)visitor);
        ListMap<String, ElementLocation> globalDependencies = visitor.getGlobalDependencies();
        if (!globalDependencies.getKeys().isEmpty()) {
            this.dependencies.add(new TypeDependencies(tokenElementInfo.getUniformPath(), globalDependencies));
        }
        return this.dependencies;
    }

    private class DependencyExtractingPhpShallowEntityVisitor
    extends PhpShallowEntityVisitorBase {
        private final Map<String, String> usedEntities;
        private final ListMap<String, ElementLocation> globalDependencies;
        final /* synthetic */ PhpDependencyExtractor this$0;

        private DependencyExtractingPhpShallowEntityVisitor(PhpDependencyExtractor phpDependencyExtractor) {
            PhpDependencyExtractor phpDependencyExtractor2 = phpDependencyExtractor;
            Objects.requireNonNull(phpDependencyExtractor2);
            this.this$0 = phpDependencyExtractor2;
            this.usedEntities = new HashMap<String, String>();
            this.globalDependencies = new ListMap();
        }

        @Override
        public boolean visit(ShallowEntity entity) {
            switch (entity.getType()) {
                case META: {
                    if (this.isUseStatement(entity)) {
                        this.handleUseStatement(entity);
                    } else if (this.isRequireStatement(entity)) {
                        this.handleRequireStatement(entity);
                    }
                    return false;
                }
                case METHOD: 
                case STATEMENT: {
                    this.handleTokens((Collection<IToken>)entity.includedTokens());
                    this.globalDependencies.addAll(this.collectDependencies());
                    return false;
                }
                case TYPE: {
                    this.handleTokens((Collection<IToken>)entity.includedTokens());
                    String qualifiedTypeName = this.getQualifiedName(entity.getName());
                    ListMap<String, ElementLocation> typeDependencies = this.collectDependencies();
                    typeDependencies.removeCollection((Object)qualifiedTypeName);
                    this.this$0.dependencies.add(new TypeDependencies(qualifiedTypeName, typeDependencies));
                    return false;
                }
            }
            return super.visit(entity);
        }

        private ListMap<String, ElementLocation> collectDependencies() {
            ListMap typeDependencies = new ListMap();
            for (int i = 0; i < this.this$0.identifiers.size(); ++i) {
                String identifier = (String)this.this$0.identifiers.getFirst(i);
                TextRegionLocation location = (TextRegionLocation)this.this$0.identifiers.getSecond(i);
                String resolvedType = this.resolveType(identifier, this.getCurrentNamespace());
                if (resolvedType == null) continue;
                typeDependencies.add((Object)resolvedType, (Object)location);
            }
            this.this$0.identifiers.clear();
            return typeDependencies;
        }

        public ListMap<String, ElementLocation> getGlobalDependencies() {
            return this.globalDependencies;
        }

        private void handleUseStatement(ShallowEntity useStatement) {
            StringBuilder originalName;
            StringBuilder typeAliasName = originalName = new StringBuilder();
            boolean inGroup = false;
            String groupNamespace = null;
            UnmodifiableList tokens = useStatement.includedTokens();
            for (IToken token : tokens) {
                ETokenType type = token.getType();
                if (type == ETokenType.USE || type == ETokenType.FUNCTION || type == ETokenType.CONST || type == ETokenType.RBRACE) continue;
                if (type == ETokenType.IDENTIFIER || type == ETokenType.BACKSLASH) {
                    typeAliasName.append(token.getText());
                    continue;
                }
                if (type == ETokenType.AS) {
                    typeAliasName = new StringBuilder();
                    continue;
                }
                if (type == ETokenType.SEMICOLON) break;
                if (type == ETokenType.LBRACE) {
                    inGroup = true;
                    groupNamespace = typeAliasName.toString();
                    continue;
                }
                if (type == ETokenType.COMMA && inGroup) {
                    this.usedEntities.put(typeAliasName.toString(), originalName.toString());
                    originalName = typeAliasName = new StringBuilder(groupNamespace);
                    continue;
                }
                LOGGER.warn("Unexpected token: {} in use statement: {}", (Object)token, (Object)useStatement);
                return;
            }
            this.usedEntities.put(typeAliasName.toString(), originalName.toString());
        }

        private void handleRequireStatement(ShallowEntity requireStatement) {
            UnmodifiableList tokens = requireStatement.includedTokens();
            for (IToken token : tokens) {
                if (token.getType() != ETokenType.STRING_LITERAL) continue;
                String text = token.getText();
                String requiredFile = text.substring(1, text.length() - 1);
                Optional<String> resolvedFile = Objects.requireNonNull(((PhpDependencyExtractor)this.this$0).dependencyExtractionIndexes.fileIncludeLookup).resolveIncludeToUniformPath(requiredFile, this.this$0.uniformPath);
                resolvedFile.ifPresent(s -> this.globalDependencies.add(s, (Object)DependencyExtractorBase.createLocation(this.this$0.uniformPath, token)));
            }
        }

        private boolean isUseStatement(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("use");
        }

        private boolean isRequireStatement(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.META && REQUIRE_SUBTYPES.contains(entity.getSubtype());
        }

        private void handleTokens(Collection<IToken> tokens) {
            for (IToken token : tokens) {
                switch (token.getType()) {
                    case IDENTIFIER: {
                        if (this.shouldIgnoreIdentifier(token)) break;
                        this.this$0.handleIdentifier(token);
                        break;
                    }
                    case BACKSLASH: {
                        this.this$0.currentIdentifierTokens.add(token);
                        break;
                    }
                    default: {
                        if (this.this$0.currentIdentifierTokens.isEmpty()) break;
                        this.this$0.addCurrentIdentifier(this.this$0.uniformPath);
                        this.this$0.currentIdentifierTokens.clear();
                    }
                }
                this.this$0.previousTokenType = token.getType();
            }
        }

        private boolean shouldIgnoreIdentifier(IToken identifier) {
            return this.isVariable(identifier) || IGNORED_IDENTIFIER_PREDECESSORS.contains(this.this$0.previousTokenType);
        }

        private boolean isVariable(IToken token) {
            return token.getText().startsWith("$");
        }

        private String resolveType(String identifier, String ownNamespace) {
            if (identifier.startsWith("\\")) {
                identifier = identifier.substring(1);
                if (this.this$0.typeLookupEnvironment.isKnownType(identifier)) {
                    return this.this$0.typeLookupEnvironment.lookupType(identifier).getName();
                }
                return null;
            }
            boolean qualifiedIdentifier = identifier.contains("\\");
            if (qualifiedIdentifier && this.this$0.typeLookupEnvironment.isKnownType(identifier)) {
                return this.this$0.typeLookupEnvironment.lookupType(identifier).getName();
            }
            return this.resolveUnqualifiedType(identifier, ownNamespace);
        }

        private String resolveUnqualifiedType(String identifier, String ownNamespace) {
            String type = PhpDependencyAnalysisUtils.toQualifiedName(ownNamespace, identifier);
            if (this.this$0.typeLookupEnvironment.isKnownType(type)) {
                return this.this$0.typeLookupEnvironment.lookupType(type).getName();
            }
            String string = this.usedEntities.get(identifier);
            if (string instanceof String) {
                String explicitType = string;
                if (this.this$0.typeLookupEnvironment.isKnownType(explicitType)) {
                    return this.this$0.typeLookupEnvironment.lookupType(explicitType).getName();
                }
            }
            for (String usedEntity : this.usedEntities.values()) {
                if (usedEntity.endsWith("\\" + identifier) && this.this$0.typeLookupEnvironment.isKnownType(usedEntity)) {
                    return this.this$0.typeLookupEnvironment.lookupType(usedEntity).getName();
                }
                type = PhpDependencyAnalysisUtils.toQualifiedName(usedEntity, identifier);
                if (!this.this$0.typeLookupEnvironment.isKnownType(type)) continue;
                return this.this$0.typeLookupEnvironment.lookupType(type).getName();
            }
            return null;
        }
    }
}

