/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.python;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.python.PythonTypeExtractor;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class PythonDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INIT_PY = "__init__.py";
    private final Map<String, String> folderToPackageCache = new HashMap<String, String>();

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws ConQATException {
        ArrayList<TypeDependencies> typeDependencies = new ArrayList<TypeDependencies>();
        if (INIT_PY.equals(this.uniformPath)) {
            LOGGER.error("Found a top-level __init__.py. Please re-configure your project such that the containing folder is below the root folder of the Teamscale project");
            return typeDependencies;
        }
        ArrayList<ShallowEntity> topLevelEntities = new ArrayList<ShallowEntity>();
        try {
            String packageName = PythonTypeExtractor.getPackageForFolder(UniformPathUtils.getParentPath((String)this.uniformPath), this.dependencyExtractionIndexes.contentIndex, this.folderToPackageCache);
            String moduleName = PythonDependencyExtractor.isInitPy(this.uniformPath) ? packageName : PythonTypeExtractor.getQualifiedModuleName(packageName, this.uniformPath);
            for (ShallowEntity shallowEntity : tokenElementInfo.getShallowEntitiesWithoutPreprocessorTokens()) {
                if (LanguageFeatureParser.PYTHON.isClass(shallowEntity)) {
                    this.extractDependenciesForClass(typeDependencies, packageName, moduleName, shallowEntity);
                    continue;
                }
                topLevelEntities.add(shallowEntity);
            }
            this.extractDependenciesForTopLevelEntities(typeDependencies, topLevelEntities, packageName, moduleName);
            return typeDependencies;
        }
        catch (StorageException e) {
            throw new ConQATException((Throwable)e);
        }
    }

    private void extractDependenciesForClass(List<TypeDependencies> typeDependencies, String packageName, String moduleName, ShallowEntity shallowEntity) {
        Pair<String, ListMap<String, ElementLocation>> classDependencies = this.extractDependenciesFromType(packageName, PythonTypeExtractor.getQualifiedName(moduleName, shallowEntity.getName()), (List<ShallowEntity>)shallowEntity.getChildren(), this.settings.includeThirdPartyDependencies);
        typeDependencies.add(new TypeDependencies((String)classDependencies.getFirst(), (ListMap<String, ElementLocation>)((ListMap)classDependencies.getSecond())));
    }

    private void extractDependenciesForTopLevelEntities(List<TypeDependencies> typeDependencies, List<ShallowEntity> topLevelEntities, String packageName, String moduleName) {
        if (!topLevelEntities.isEmpty()) {
            Pair<String, ListMap<String, ElementLocation>> topLevelDependencies = this.extractDependenciesFromType(packageName, moduleName, topLevelEntities, this.settings.includeThirdPartyDependencies);
            typeDependencies.add(new TypeDependencies((String)topLevelDependencies.getFirst(), (ListMap<String, ElementLocation>)((ListMap)topLevelDependencies.getSecond())));
        }
    }

    private Pair<String, ListMap<String, ElementLocation>> extractDependenciesFromType(String packageName, String importingType, List<ShallowEntity> content, boolean includeThirdPartyDependencies) {
        LinkedHashMap<String, List<IToken>> imports = new LinkedHashMap<String, List<IToken>>();
        PythonDependencyExtractor.extractAllImports(packageName, content, imports);
        ListMap dependencies = new ListMap();
        this.reformatAndFilterImports(includeThirdPartyDependencies, imports, (ListMap<String, ElementLocation>)dependencies);
        return new Pair((Object)importingType, (Object)dependencies);
    }

    private static void extractAllImports(String packageName, List<ShallowEntity> content, Map<String, List<IToken>> imports) {
        for (ShallowEntity shallowEntity : ShallowEntityTraversalUtils.getAllEntities(content)) {
            if (shallowEntity.getType() != EShallowEntityType.META || !shallowEntity.getSubtype().equals("import") && !shallowEntity.getSubtype().equals("from")) continue;
            imports.putAll(PythonDependencyExtractor.handleImport(packageName, shallowEntity));
        }
    }

    private void reformatAndFilterImports(boolean includeThirdPartyDependencies, Map<String, List<IToken>> imports, ListMap<String, ElementLocation> dependencies) {
        for (Map.Entry<String, List<IToken>> singleImport : imports.entrySet()) {
            String resolvedType = this.resolveImportedType(singleImport.getKey(), includeThirdPartyDependencies);
            if (resolvedType == null) continue;
            dependencies.add((Object)resolvedType, (Object)PythonDependencyExtractor.createLocation(this.uniformPath, singleImport.getValue()));
        }
    }

    private static Map<String, List<IToken>> handleImport(String packageName, ShallowEntity importEntity) {
        Object importTokens = importEntity.ownStartTokens();
        LinkedHashMap<String, List<IToken>> imports = new LinkedHashMap<String, List<IToken>>();
        if (TokenStreamUtils.contains((List)importTokens, (ETokenType)ETokenType.COMMA)) {
            List pathTokens = new ArrayList();
            if (TokenStreamUtils.contains((List)importTokens, (ETokenType)ETokenType.FROM)) {
                int splitPosition = TokenStreamUtils.firstTokenMatching((List)importTokens, (ITokenMatcher)ETokenType.IMPORT) + 1;
                pathTokens = importTokens.subList(0, splitPosition);
                importTokens = importTokens.subList(splitPosition, importTokens.size());
            }
            List importsSplit = TokenStreamUtils.split((List)importTokens, (ETokenType[])new ETokenType[]{ETokenType.COMMA});
            for (List tokenList : importsSplit) {
                List<IToken> tokens = Stream.concat(pathTokens.stream(), tokenList.stream()).collect(Collectors.toList());
                imports.put(PythonDependencyExtractor.extractImportType(packageName, tokens), tokens);
            }
        } else {
            imports.put(PythonDependencyExtractor.extractImportType(packageName, (List<IToken>)importTokens), (List<IToken>)importTokens);
        }
        return imports;
    }

    private static String extractImportType(String packageName, List<IToken> importTokens) {
        boolean previousMetaToken = false;
        StringBuilder importBuilder = new StringBuilder();
        for (IToken token : importTokens) {
            if (importBuilder.length() == 0 && token.getType() == ETokenType.DOT) {
                if (StringUtils.isEmpty((String)packageName)) continue;
                importBuilder.append(packageName);
                importBuilder.append(token.getText());
                continue;
            }
            if (token.getType() == ETokenType.DOT && importBuilder.charAt(importBuilder.length() - 1) == '.') {
                int previousDotIndex = importBuilder.lastIndexOf(".", importBuilder.length() - 2);
                if (previousDotIndex == -1) continue;
                importBuilder.delete(previousDotIndex + 1, importBuilder.length());
                continue;
            }
            if (token.getType() == ETokenType.IMPORT || token.getType() == ETokenType.FROM) {
                if (previousMetaToken && !importBuilder.toString().isEmpty()) {
                    importBuilder.append('.');
                }
                previousMetaToken = true;
                continue;
            }
            if (token.getType() == ETokenType.AS) break;
            PythonDependencyExtractor.appendTokenIfValid(previousMetaToken, importBuilder, token);
        }
        return importBuilder.toString();
    }

    private static void appendTokenIfValid(boolean previousMetaToken, StringBuilder importBuilder, IToken token) {
        if (previousMetaToken && (token.getType() == ETokenType.IDENTIFIER || token.getType() == ETokenType.DOT)) {
            importBuilder.append(token.getText());
        }
    }

    public static boolean isInitPy(String uniformPath) {
        return UniformPathUtils.getElementName((String)uniformPath).equals(INIT_PY);
    }
}

