/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.simulink;

import com.teamscale.index.dependencies.simulink.SimulinkParsingAndDependencyUtils;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkModel;

public class DataDictionaryLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BinaryElementIndex binaryElementIndex;
    private final SimulinkDataDictionaryIndex dataDictionaryIndex;
    private final SetMap<SimulinkModel, SimulinkDataDictionary> knownDictionariesReferences = new SetMap();
    private final Map<String, SimulinkDataDictionary> loadedDictionaries = new HashMap<String, SimulinkDataDictionary>();

    public DataDictionaryLoader(BinaryElementIndex binaryElementIndex, SimulinkDataDictionaryIndex dataDictionaryIndex) {
        this.binaryElementIndex = binaryElementIndex;
        this.dataDictionaryIndex = dataDictionaryIndex;
    }

    public void preloadDictionaries(List<String> uniformPaths) throws StorageException {
        List<byte[]> content = this.binaryElementIndex.getContents(uniformPaths);
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = uniformPaths.get(i);
            try {
                byte[] bytes = content.get(i);
                if (bytes == null) {
                    throw new SimulinkModelBuildingException(String.format("%s cannot be found.", uniformPath));
                }
                SimulinkDataDictionary dictionary = SimulinkParsingAndDependencyUtils.parseDataDictionaryFromData(uniformPath, bytes);
                String fileName = DataDictionaryLoader.getFilenameFromUniformPath(uniformPath);
                this.loadedDictionaries.put(fileName, dictionary);
                continue;
            }
            catch (IOException | SimulinkModelBuildingException e) {
                LOGGER.error("Could not parse model " + uniformPath + ": " + e.getMessage(), e);
                this.loadedDictionaries.put(uniformPath, null);
            }
        }
    }

    public Set<SimulinkDataDictionary> getReferencedDataDictionaries(SimulinkModel model) throws StorageException {
        String dataDictionaryFileName = model.getParameter("DataDictionary");
        Set indirectReferences = (Set)this.knownDictionariesReferences.getCollectionOrElse((Object)model, new HashSet());
        if (dataDictionaryFileName == null) {
            return indirectReferences;
        }
        HashSet<SimulinkDataDictionary> dictionarySet = new HashSet<SimulinkDataDictionary>();
        dictionarySet.addAll(indirectReferences);
        dictionarySet.addAll(this.getReferencedDataDictionaries(dataDictionaryFileName));
        return new HashSet<SimulinkDataDictionary>(dictionarySet);
    }

    public Set<SimulinkModel> getModelsThatReferenceDataDictionary(SimulinkDataDictionary dictionary) {
        Set<SimulinkModel> result = (Set<SimulinkModel>)this.knownDictionariesReferences.invert().getCollection((Object)dictionary);
        return result != null ? result : Collections.emptySet();
    }

    public void addReferences(SimulinkModel model, Set<SimulinkDataDictionary> dictionaries) {
        this.knownDictionariesReferences.addAll((Object)model, dictionaries);
    }

    public Optional<SimulinkDataDictionary> getDictionaryByUniformPath(String uniformPath) throws StorageException {
        String fileName = DataDictionaryLoader.getFilenameFromUniformPath(uniformPath);
        return this.getDictionaryBySimpleName(fileName);
    }

    private Optional<SimulinkDataDictionary> getDictionaryBySimpleName(String fileName) throws StorageException {
        if (!this.loadedDictionaries.containsKey(fileName)) {
            SimulinkDataDictionary dictionary = this.dataDictionaryIndex.getDataDictionaryByFileName(fileName);
            this.loadedDictionaries.put(fileName, dictionary);
        }
        return Optional.ofNullable(this.loadedDictionaries.get(fileName));
    }

    private List<SimulinkDataDictionary> getReferencedDataDictionaries(String fileName) throws StorageException {
        ArrayList<SimulinkDataDictionary> referencedDictionaries = new ArrayList<SimulinkDataDictionary>();
        Optional<SimulinkDataDictionary> dictionary = this.getDictionaryBySimpleName(fileName);
        if (dictionary.isEmpty()) {
            return referencedDictionaries;
        }
        referencedDictionaries.add(dictionary.get());
        for (String subFileName : dictionary.get().getSubDataDictionaries()) {
            referencedDictionaries.addAll(this.getReferencedDataDictionaries(subFileName));
        }
        return referencedDictionaries;
    }

    private static String getFilenameFromUniformPath(String uniformPath) {
        return Paths.get(uniformPath, new String[0]).getFileName().toString();
    }

    public List<SimulinkDataDictionary> getReferencedDataDictionariesSorted(SimulinkModel model) throws StorageException {
        return CollectionUtils.sort(this.getReferencedDataDictionaries(model), Comparator.comparing(SimulinkDataDictionary::getUniformPath));
    }
}

