/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.type;

import com.teamscale.index.dependencies.type.AttributeDefinition;
import com.teamscale.index.dependencies.type.MethodSignature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class Type
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<AttributeDefinition> attributes;
    private final List<String> superTypes;
    private final List<MethodSignature> methods;

    public Type(String name) {
        this(name, null);
    }

    public Type(String name, List<String> superTypes) {
        this(name, null, superTypes, null);
    }

    public Type(String name, List<AttributeDefinition> attributes, List<String> superTypes, List<MethodSignature> methods) {
        this.name = name;
        this.attributes = Optional.ofNullable(attributes).map(ArrayList::new).orElse(null);
        this.superTypes = Optional.ofNullable(superTypes).map(ArrayList::new).orElse(null);
        this.methods = Optional.ofNullable(methods).map(ArrayList::new).orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public List<AttributeDefinition> getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(this.attributes);
    }

    public List<String> getSuperTypes() {
        if (this.superTypes == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(this.superTypes);
    }

    public List<MethodSignature> getMethods() {
        if (this.methods == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(this.methods);
    }

    public Type merge(Type type, boolean caseInsensitive) {
        boolean nameMatches = caseInsensitive ? this.name.equalsIgnoreCase(type.getName()) : this.name.equals(type.getName());
        CCSMAssert.isTrue((boolean)nameMatches, (String)("Names of types do not match: " + this.name + " vs. " + type.getName()));
        ArrayList<AttributeDefinition> mergedAttributes = new ArrayList<AttributeDefinition>(CollectionUtils.unionSet(this.attributes, (Collection[])new Collection[]{type.getAttributes()}));
        ArrayList<String> mergedSuperTypes = new ArrayList<String>(CollectionUtils.unionSet(this.superTypes, (Collection[])new Collection[]{type.getSuperTypes()}));
        ArrayList<MethodSignature> mergedMethods = new ArrayList<MethodSignature>(CollectionUtils.unionSet(this.methods, (Collection[])new Collection[]{type.getMethods()}));
        return new Type(this.name, mergedAttributes, mergedSuperTypes, mergedMethods);
    }

    public Optional<AttributeDefinition> getAttributeByName(String name) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        for (AttributeDefinition attribute : this.attributes) {
            if (!attribute.name.equals(name)) continue;
            return Optional.of(attribute);
        }
        return Optional.empty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Type that = (Type)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.superTypes, that.superTypes) && Objects.equals(this.methods, that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes, this.superTypes, this.methods);
    }

    public String toString() {
        return this.name;
    }
}

