/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.tools.ExternalAnalysisResultIndexUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExternalUploadIndexUtils {
    public static <COMMIT extends Serializable> void copyCommit(String indexName, Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass, ParentedCommitDescriptor commit, IStore inputStore, IStore outputStore) throws StorageException, InconsistentCommitException {
        switch (indexName) {
            case "external-analysis-results": {
                ExternalAnalysisResultIndexUtils.copyCommit(commit, inputStore, outputStore);
                break;
            }
            case "external-architecture-uploads": 
            case "finding-blacklist-staging": 
            case "element-review-uploads": {
                ExternalUploadIndexUtils.copyGenericCommit(indexClass, commit.getCommit(), inputStore, outputStore);
                break;
            }
            default: {
                throw new AssertionError((Object)("No commit copy support available for index " + indexName));
            }
        }
    }

    private static <COMMIT extends Serializable> void copyGenericCommit(Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass, CommitDescriptor commit, IStore inputStore, IStore outputStore) throws StorageException, InconsistentCommitException {
        CommitAssociatedObjectBase inputCommitObject;
        IStore historizedInputStore = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()).createStore(inputStore, new SchemaEntry(indexClass));
        ExternalUploadIndexBase<COMMIT> inputIndex = ExternalUploadIndexUtils.createIndex(indexClass, historizedInputStore);
        COMMIT commitFromInputStore = inputIndex.getCommitInfo();
        if (commitFromInputStore instanceof CommitAssociatedObjectBase && !(inputCommitObject = (CommitAssociatedObjectBase)commitFromInputStore).getCommit().equals((Object)commit)) {
            throw new InconsistentCommitException(String.format("Unexpected commit object read from store: got '%s', but should be '%s'. Possibly inconsistent head commit on branch '%s'.", inputCommitObject.getCommit(), commit, commit.getBranchName()));
        }
        IStore historizedOutputStore = HistoryAccessOption.readHeadWriteTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()).createStore(outputStore, new SchemaEntry(indexClass));
        ExternalUploadIndexBase<COMMIT> outputIndex = ExternalUploadIndexUtils.createIndex(indexClass, historizedOutputStore);
        outputIndex.setCommitInfo(commitFromInputStore);
    }

    private static <COMMIT extends Serializable> ExternalUploadIndexBase<COMMIT> createIndex(Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass, IStore store) throws StorageException {
        try {
            return indexClass.getConstructor(IStore.class).newInstance(store);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new StorageException("Failed to open index: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void copyCommitWithRetry(ParentedCommitDescriptor commitToCopy, CommitCopyOperation copyCommit, RunnableWithException<StorageException> attemptRepair) throws StorageException {
        try {
            copyCommit.run();
        }
        catch (InconsistentCommitException e) {
            LogManager.getLogger().warn("Failed to copy commit '{}'. Attempting repair.", (Object)commitToCopy, (Object)e);
            attemptRepair.run();
            try {
                copyCommit.run();
            }
            catch (InconsistentCommitException e2) {
                throw new StorageException("Commit copy failed even after repair attempt.", (Throwable)e2);
            }
        }
    }

    private ExternalUploadIndexUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    @FunctionalInterface
    public static interface CommitCopyOperation {
        public void run() throws InconsistentCommitException, StorageException;
    }
}

