/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.external.input.AnalysisProfileUpdater;
import com.teamscale.index.external.input.ImportInfoPath;
import com.teamscale.index.external.input.PathCorrector;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.info.ExternalAnalysisReportParsingResult;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionModifier;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.ReportParserFactory;
import com.teamscale.index.report.parser.IPathPrefixedReportParser;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.upload.IExternalToolRule;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.sonar.api.internal.apachecommons.io.FileUtils;

class ReportIntegrator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExternalAnalysisImportSessionIndex sessionIndex;
    private final IMatchingPathsLookup matchingPathsLookup;
    private final TypeIndex typeIndex;
    private final ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex;
    private final BasicTokenElementIndex basicTokenElementIndex;
    private final TokenElementIndexCache contentIndexCache;
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final BinaryElementIndex binaryElementIndex;
    private final PathCorrector pathCorrector;
    private final MetaIndex projectMetaIndex;
    private final boolean disablePlausibilityCheckForPathMapping;
    private final ExecuteInParallelBatchesFunction parallelExecutor;
    private final AnalysisProfileUpdater analysisProfileUpdater;
    private final ProjectStorageSystem projectStorageSystem;

    public ReportIntegrator(ExternalAnalysisImportSessionIndex sessionIndex, IMatchingPathsLookup matchingPathsLookup, TypeIndex typeIndex, ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex, BasicTokenElementIndex basicTokenElementIndex, TokenElementIndexCache contentIndexCache, TokenElementLineInfoIndex tokenElementLineInfoIndex, BinaryElementIndex binaryElementIndex, PathCorrector pathCorrector, MetaIndex projectMetaIndex, boolean disablePlausibilityCheckForPathMapping, ExecuteInParallelBatchesFunction parallelExecutor, AnalysisProfileUpdater analysisProfileUpdater, ProjectStorageSystem projectStorageSystem) {
        this.sessionIndex = sessionIndex;
        this.matchingPathsLookup = matchingPathsLookup;
        this.typeIndex = typeIndex;
        this.externalFindingsGroupDescriptionIndex = externalFindingsGroupDescriptionIndex;
        this.basicTokenElementIndex = basicTokenElementIndex;
        this.contentIndexCache = contentIndexCache;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.binaryElementIndex = binaryElementIndex;
        this.pathCorrector = pathCorrector;
        this.projectMetaIndex = projectMetaIndex;
        this.disablePlausibilityCheckForPathMapping = disablePlausibilityCheckForPathMapping;
        this.parallelExecutor = parallelExecutor;
        this.analysisProfileUpdater = analysisProfileUpdater;
        this.projectStorageSystem = projectStorageSystem;
    }

    public ExternalAnalysisReportParsingResult processReports(Set<ImportInfoPath> paths, ExternalAnalysisSessionInfo session, CommitDescriptor writeCommit, ExternalAnalysisReportArchiveIndex reportArchiveIndex, long maxReportArchiveIndexSize) throws StorageException {
        Set reportPaths = CollectionUtils.filterToSet(paths, path -> ExternalAnalysisImportInfoReport.isRawReportPath(path.getOriginalPath()));
        if (reportPaths.isEmpty()) {
            return new ExternalAnalysisReportParsingResult(new ArrayList<ExternalAnalysisImportInfos>(), true);
        }
        paths.removeAll(reportPaths);
        Map<String, ExternalAnalysisImportInfos> importInfosByOriginalPath = this.sessionIndex.getImportInfos(session, CollectionUtils.map((Collection)reportPaths, ImportInfoPath::getOriginalPath));
        ArrayList<ExternalAnalysisImportInfos> newImportInfos = new ArrayList<ExternalAnalysisImportInfos>();
        boolean sessionHasParsingErrors = false;
        for (ImportInfoPath reportPath : reportPaths) {
            ExternalAnalysisImportInfos importInfos = importInfosByOriginalPath.get(reportPath.getOriginalPath());
            CCSMAssert.isNotNull((Object)importInfos, (String)("No import info found for " + reportPath.getOriginalPath()));
            sessionHasParsingErrors = this.processImportInfos(paths, session, writeCommit, reportArchiveIndex, maxReportArchiveIndexSize, importInfos, newImportInfos, sessionHasParsingErrors);
        }
        new ExternalAnalysisImportSessionModifier(this.sessionIndex).storeNewImportInfosForSession(session, newImportInfos);
        return new ExternalAnalysisReportParsingResult(newImportInfos, !sessionHasParsingErrors);
    }

    private boolean processImportInfos(Set<ImportInfoPath> paths, ExternalAnalysisSessionInfo session, CommitDescriptor writeCommit, ExternalAnalysisReportArchiveIndex reportArchiveIndex, long maxReportArchiveIndexSize, ExternalAnalysisImportInfos importInfos, List<ExternalAnalysisImportInfos> newImportInfos, boolean sessionHasParsingErrors) throws StorageException {
        for (ExternalAnalysisImportInfoReport reportInfo : importInfos.filterByType(ExternalAnalysisImportInfoReport.class)) {
            ReportIntegrator.archiveReportFiles(reportInfo, writeCommit, reportArchiveIndex, maxReportArchiveIndexSize);
            try {
                ParserResult result = this.parseReport(reportInfo, session, this.disablePlausibilityCheckForPathMapping);
                if (!result.rules().isEmpty()) {
                    List<@NonNull AnalysisProfile> profiles = AnalysisProfileUtils.getEmbeddedAnalysisProfiles(this.projectStorageSystem);
                    this.analysisProfileUpdater.updateAnalysisProfiles(result.tool(), result.rules(), profiles);
                }
                ExternalAnalysisImportInfos parseResult = result.infos();
                newImportInfos.add(parseResult);
                paths.addAll(this.pathCorrector.correctPaths(parseResult.getContainedPaths()));
            }
            catch (ReportParserException e) {
                sessionHasParsingErrors = true;
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to parse report '{}'. Skipping this report.", reportInfo.getReportUniformPaths());
            }
            catch (ProjectConfigurationException e) {
                LOGGER.error("Could not update analysis profile. Skipping this report.", (Throwable)e);
            }
        }
        return sessionHasParsingErrors;
    }

    private static void archiveReportFiles(ExternalAnalysisImportInfoReport reportInfo, CommitDescriptor writeCommit, ExternalAnalysisReportArchiveIndex reportArchiveIndex, long maxReportArchiveIndexSize) throws StorageException {
        if (maxReportArchiveIndexSize == 0L) {
            return;
        }
        LOGGER.debug("Archiving uploaded reports: {}", (Object)reportInfo);
        ExternalAnalysisReportArchiveIndex determineSizeIndex = new ExternalAnalysisReportArchiveIndex((IStore)new InMemoryStore());
        determineSizeIndex.storeReport(writeCommit, reportInfo.getReportUniformPath(), reportInfo.getData());
        long storeSize = determineSizeIndex.computeStoreSizeBytes();
        if (storeSize < maxReportArchiveIndexSize) {
            reportArchiveIndex.storeReport(writeCommit, reportInfo.getReportUniformPath(), reportInfo.getData());
        } else {
            LOGGER.warn("The reports associated with upload commit {} are too big and will not be archived (maximum allowed size: {}, actual size: {})", (Object)writeCommit, (Object)FileUtils.byteCountToDisplaySize((long)maxReportArchiveIndexSize), (Object)FileUtils.byteCountToDisplaySize((long)storeSize));
        }
    }

    private ParserResult parseReport(ExternalAnalysisImportInfoReport rawReportInfo, ExternalAnalysisSessionInfo session, boolean disablePlausibilityCheckForPathMapping) throws ReportParserException {
        IReportParser reportParser = this.createReportParser(rawReportInfo, session, disablePlausibilityCheckForPathMapping);
        reportParser.parseStringReport(rawReportInfo.getData(), null);
        return new ParserResult(reportParser.getAnalysisTool(), reportParser.getInfos(), reportParser.getRules());
    }

    private IReportParser createReportParser(ExternalAnalysisImportInfoReport importInfo, ExternalAnalysisSessionInfo session, boolean disablePlausibilityCheckForPathMapping) {
        EReportFormat reportFormat = (EReportFormat)EnumUtils.valueOfIgnoreCase(EReportFormat.class, (String)importInfo.getReportFormat());
        IReportParser reportParser = ReportParserFactory.createParser(reportFormat);
        reportParser.init(this.basicTokenElementIndex, this.contentIndexCache, this.tokenElementLineInfoIndex, this.binaryElementIndex, this.matchingPathsLookup, this.typeIndex, this.externalFindingsGroupDescriptionIndex, ReportIntegrator.getConnectorId(session), this.projectMetaIndex, disablePlausibilityCheckForPathMapping, this.parallelExecutor, session.getRepository().orElse(null));
        String pathPrefix = importInfo.getPathPrefix();
        if (reportParser instanceof IPathPrefixedReportParser && !StringUtils.isEmpty((String)pathPrefix)) {
            ((IPathPrefixedReportParser)((Object)reportParser)).setPathPrefix(pathPrefix);
        }
        return reportParser;
    }

    private static String getConnectorId(ExternalAnalysisSessionInfo session) {
        return session.getPartition();
    }

    private record ParserResult(EAnalysisTool tool, ExternalAnalysisImportInfos infos, Collection<IExternalToolRule> rules) {
    }
}

