/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.commons.StreamUtils;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalStorageFile;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.repository.artifact_store.external_storage.ExternalStorageConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OutgoingExternalStorageArchive
implements IOutgoingExternalStorageFile {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PATH_SEPARATOR = "/";
    private final String targetPath;
    private final byte[] content;
    private final long contentSizeInBytes;

    public OutgoingExternalStorageArchive(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, Collection<ExternalAnalysisImportInfoReport> reports) throws IOException {
        this.targetPath = OutgoingExternalStorageArchive.buildTargetPath(session, projectConfiguration);
        try (ByteArrayOutputStream contentStream = new ByteArrayOutputStream();){
            this.contentSizeInBytes = StreamUtils.writeWithByteCounter((OutputStream)contentStream, stream -> OutgoingExternalStorageArchive.writeArchive(reports, stream));
            this.content = contentStream.toByteArray();
        }
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getContentSizeInBytes() {
        return this.contentSizeInBytes;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    private static String buildTargetPath(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration) {
        return OutgoingExternalStorageArchive.concatenatePathElements(OutgoingExternalStorageArchive.createPathElements(session, projectConfiguration, OutgoingExternalStorageArchive.getTargetStorage(session, session.getSessionId()), session.getSessionId()), session.getSessionId());
    }

    private static List<String> createPathElements(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorage, String sessionId) {
        ArrayList<Object> pathElements = new ArrayList<Object>();
        pathElements.add(externalStorage.uploadPathPrefix());
        pathElements.add(projectConfiguration.getExternalStorageProjectMappingId().toString());
        pathElements.add(OutgoingExternalStorageArchive.getCurrentDate());
        pathElements.addAll(OutgoingExternalStorageArchive.getCommitIdentifyingPathElements(session));
        pathElements.addAll(List.of("__partitions__", session.getPartition(), "__reports__", sessionId + ".zip"));
        return pathElements.stream().filter(Predicate.not(StringUtils::isEmpty)).toList();
    }

    private static ExternalStorageBackend getTargetStorage(ExternalAnalysisSessionInfo session, String sessionId) {
        return session.getTargetStorage().orElseThrow(() -> new IllegalStateException("Attempted to upload session '%s' to external storage, but target storage is empty.".formatted(sessionId)));
    }

    private static String concatenatePathElements(List<String> pathElements, String sessionId) {
        return pathElements.stream().filter(element -> {
            if (StringUtils.isEmpty((String)element)) {
                LOGGER.warn("Upload path with elements [{}] for session '{}' contained empty element! Skipping empty element.", new Supplier[]{() -> String.join((CharSequence)" | ", pathElements), () -> sessionId});
                return false;
            }
            return true;
        }).map(element -> StringUtils.strip((String)element, (String)PATH_SEPARATOR)).collect(Collectors.joining(PATH_SEPARATOR));
    }

    private static String getCurrentDate() {
        return DateTimeUtils.formatTimestamp((long)DateTimeUtils.now().toEpochMilli(), (DateTimeFormatter)ExternalStorageConstants.DATE_DIRECTORY_FORMATTER);
    }

    private static List<String> getCommitIdentifyingPathElements(ExternalAnalysisSessionInfo session) {
        return session.getRevision().map(OutgoingExternalStorageArchive::getRevisionBasedTargetPathElements).orElseGet(() -> OutgoingExternalStorageArchive.getTimestampAndBranchBasedTargetPathElements(session.getCommit()));
    }

    private static List<String> getTimestampAndBranchBasedTargetPathElements(CommitDescriptor commit) {
        return List.of("__branches__", commit.getBranchName(), "__timestamps__", Long.toString(commit.getTimestamp()));
    }

    private static List<String> getRevisionBasedTargetPathElements(String revision) {
        return List.of("__revisions__", revision);
    }

    private static void writeArchive(Collection<ExternalAnalysisImportInfoReport> reports, OutputStream stream) throws IOException {
        try (ZipArchiveOutputStream archive = new ZipArchiveOutputStream(stream);){
            for (ExternalAnalysisImportInfoReport report : reports) {
                Pair pathSplitByFileEnding = StringUtils.splitAtLast((String)report.getReportUniformPath(), (char)'.');
                long hash = XXHashUtils.xxhash64((String)report.getData());
                String uniqueReportUniformPath = (String)pathSplitByFileEnding.getFirst() + "_" + hash + "." + (String)pathSplitByFileEnding.getSecond();
                ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)archive, (String)String.join((CharSequence)PATH_SEPARATOR, report.getReportFormat(), uniqueReportUniformPath), (CharSequence)report.getData());
            }
        }
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

