/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultMultiFileRangeCoverage;
import java.util.Map;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisImportInfoMultiFileRangeCoverage
extends ExternalAnalysisImportInfo<MultiFileRangeCoverageInfo> {
    private static final long serialVersionUID = 1L;
    private static final String COVERAGE_PROBE_INFO_PROPERTY = "coverageProbeInfo";
    private static final String PART_OF_PARTIAL_REPORT_PROPERTY = "partOfPartialReport";
    private static final String PART_OF_METHOD_ACCURATE_REPORT_PROPERTY = "partOfMethodAccurateReport";
    @JsonProperty(value="coverageProbeInfo")
    private final MultiFileRangeCoverageInfo coverageProbeInfo;
    @JsonProperty(value="partOfPartialReport")
    private final boolean partOfPartialReport;
    @JsonProperty(value="partOfMethodAccurateReport")
    private final @Nullable Boolean partOfMethodAccurateReport;

    @JsonCreator
    public ExternalAnalysisImportInfoMultiFileRangeCoverage(@JsonProperty(value="uniformPath") String coverageUnitUniformPath, @JsonProperty(value="coverageProbeInfo") MultiFileRangeCoverageInfo coverageProbeInfo, @JsonProperty(value="partOfPartialReport") boolean partOfPartialReport, @JsonProperty(value="partOfMethodAccurateReport") boolean partOfMethodAccurateReport) {
        super(coverageUnitUniformPath);
        this.coverageProbeInfo = coverageProbeInfo;
        this.partOfPartialReport = partOfPartialReport;
        this.partOfMethodAccurateReport = partOfMethodAccurateReport;
    }

    @Override
    public MultiFileRangeCoverageInfo getData() {
        return this.coverageProbeInfo;
    }

    public ExternalAnalysisResultMultiFileRangeCoverage createAnalysisResult() {
        return new ExternalAnalysisResultMultiFileRangeCoverage(this.coverageProbeInfo, this.partOfPartialReport, this.partOfMethodAccurateReport);
    }

    @Override
    public long getEstimatedSizeBytes() {
        return this.coverageProbeInfo.getEstimatedSizeBytes() + super.getEstimatedSizeBytes();
    }

    private boolean isPartOfMethodAccurateReport() {
        return this.partOfMethodAccurateReport != null && this.partOfMethodAccurateReport != false;
    }

    public void appendLineCoverageTo(Map<String, LineCoverageInfo> coverage) {
        for (Map.Entry coveredRangesPerFile : this.coverageProbeInfo.getCoverage().entrySet()) {
            String uniformPath = (String)coveredRangesPerFile.getKey();
            LineCoverageInfo lineCoverageInfo = coverage.computeIfAbsent(uniformPath, path -> new LineCoverageInfo(this.coverageProbeInfo.getTimestamp(), this.coverageProbeInfo.getTimestamp(), this.isPartOfMethodAccurateReport()));
            lineCoverageInfo.addLineCoverage((CompactLines)coveredRangesPerFile.getValue(), ELineCoverage.FULLY_COVERED);
            this.addNotCoveredLinesFromKnownCoverableLines(uniformPath, lineCoverageInfo);
        }
    }

    private void addNotCoveredLinesFromKnownCoverableLines(String uniformPath, LineCoverageInfo lineCoverageInfo) {
        if (!this.coverageProbeInfo.getCoverableLines().containsKey(uniformPath)) {
            return;
        }
        CompactLines coverableLines = (CompactLines)this.coverageProbeInfo.getCoverableLines().get(uniformPath);
        lineCoverageInfo.addLineCoverage(coverableLines, ELineCoverage.NOT_COVERED);
    }
}

