/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tests;

import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.external.tests.ITestExecutionMetric;
import com.teamscale.index.external.tests.TestCountMetric;
import com.teamscale.index.external.tests.TestDurationMetric;
import com.teamscale.index.external.tests.TestFailureMetric;
import com.teamscale.index.external.tests.TestInconclusiveMetric;
import com.teamscale.index.external.tests.TestResultAssessmentMetric;
import com.teamscale.index.external.tests.TestSkippedMetric;
import com.teamscale.index.external.tests.TestSuccessMetric;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.tests.TestExecution;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class TestMetricsManager {
    private final MetricsIndex testMetricsIndex;
    private final TestCountMetric testCountMetric = new TestCountMetric();
    private final List<ITestExecutionMetric> testExecutionMetrics = new ArrayList<ITestExecutionMetric>();

    public TestMetricsManager(MetricsIndex testMetricsIndex) {
        this.testMetricsIndex = testMetricsIndex;
        this.testExecutionMetrics.add(new TestFailureMetric());
        this.testExecutionMetrics.add(new TestSuccessMetric());
        this.testExecutionMetrics.add(new TestSkippedMetric());
        this.testExecutionMetrics.add(new TestResultAssessmentMetric());
        this.testExecutionMetrics.add(new TestDurationMetric());
        this.testExecutionMetrics.add(new TestInconclusiveMetric());
    }

    public void calculateAndStoreTestExecutionMetrics(CommitDescriptor commit, PairList<String, TestExecution> testExecutionsAndMetricPath) throws StorageException {
        for (Pair pathAndExecution : testExecutionsAndMetricPath) {
            String testMetricPath = (String)pathAndExecution.getFirst();
            TestExecution testExecution = (TestExecution)pathAndExecution.getSecond();
            for (ITestExecutionMetric metricComputation : this.testExecutionMetrics) {
                metricComputation.computeAndCacheResult(testMetricPath, commit, testExecution);
            }
        }
        for (ITestExecutionMetric testExecutionMetric : this.testExecutionMetrics) {
            this.testMetricsIndex.setMetricValues(testExecutionMetric.getCachedMetricValues(), testExecutionMetric.getMetricPartition());
        }
    }

    public void calculateAndStoreTestCountMetric(List<String> tests) throws StorageException {
        for (String test : tests) {
            this.testCountMetric.computeAndCacheResult(test);
        }
        this.testMetricsIndex.setMetricValues(this.testCountMetric.getCachedMetricValues(), this.testCountMetric.getMetricPartition());
    }

    public List<String> getPartitions() {
        List partitions = CollectionUtils.map(this.testExecutionMetrics, ITestExecutionMetric::getMetricPartition);
        partitions.add(this.testCountMetric.getMetricPartition());
        return partitions;
    }

    public void deleteMetricsForDeletedKeys(List<String> deletedUniformPaths) throws StorageException {
        this.testMetricsIndex.removeEntries(deletedUniformPaths, this.getPartitions());
    }

    public void deleteMetricsForDeletedExecutions(List<String> testExecutions) throws StorageException {
        this.testMetricsIndex.removeEntries(testExecutions, this.getPartitions());
    }
}

