/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.tools.ExternalAnalysisResultIndexUtils;
import com.teamscale.index.external.tools.StoreModifierBase;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.options.Option;
import org.jspecify.annotations.Nullable;

public class ExternalAnalysisResultsBackupMinimizer
extends StoreModifierBase {
    private static final SchemaEntry EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA = new SchemaEntry(ExternalAnalysisResultIndex.class);
    private final Set<Long> ignoredTimestamps = new HashSet<Long>();
    private final Set<String> ignoredPartitions = new HashSet<String>();
    private final IncludeExcludeAntPatternSupport includeExcludeBranches = new IncludeExcludeAntPatternSupport();
    private final Set<String> categories = new HashSet<String>();
    private boolean deleteEmptyResults = false;
    private final IncludeExcludeAntPatternSupport includeExclude = new IncludeExcludeAntPatternSupport();
    private long startTimestamp = 0L;
    private final StringTransformation partitionRenames = new StringTransformation();

    @Override
    protected Set<String> getChangedStoreNames() {
        return Set.of("external-analysis-results");
    }

    @Override
    protected void modifyStore(String storeName, CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        if (this.includeExcludeBranches.getIncludePatterns().isEmpty()) {
            this.includeExcludeBranches.addMatchAllIncludePattern();
        }
        int totalBranchCount = commitsByBranch.size();
        int currentBranchIndex = 0;
        for (Map.Entry<String, List<ParentedCommitDescriptor>> entry : commitsByBranch.entrySet()) {
            ++currentBranchIndex;
            String branch = entry.getKey();
            if (!this.includeExcludeBranches.isIncluded(branch)) {
                ExternalAnalysisResultsBackupMinimizer.printInfo((String)"Skipping ignored branch: %s %d of %d%n".formatted(branch, currentBranchIndex, totalBranchCount));
                continue;
            }
            List<ParentedCommitDescriptor> commits = entry.getValue();
            int count = 0;
            ParentedCommitDescriptor lastAddedCommitDescriptor = null;
            for (ParentedCommitDescriptor commitDescriptor : commits) {
                ExternalAnalysisResultsBackupMinimizer.printInfo((String)"  Commit %d of %d (branch: %s %d of %d)%n".formatted(++count, commits.size(), branch, currentBranchIndex, totalBranchCount));
                lastAddedCommitDescriptor = this.getParentedCommitDescriptor(inputStore, outputStore, commitDescriptor, lastAddedCommitDescriptor);
            }
        }
    }

    private ParentedCommitDescriptor getParentedCommitDescriptor(CompressingStore inputStore, CompressingStore outputStore, ParentedCommitDescriptor commitDescriptor, @Nullable ParentedCommitDescriptor lastAddedCommitDescriptor) throws StorageException {
        String partition;
        List<String> results;
        ExternalAnalysisResultIndex index = new ExternalAnalysisResultIndex(HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()).createStore((IStore)inputStore, EXTERNAL_ANALYSIS_RESULT_INDEX_SCHEMA));
        ExternalAnalysisCommitInfo commit = (ExternalAnalysisCommitInfo)((Object)index.getCommitInfo());
        if (this.deleteEmptyResults && (results = index.getAllElementPaths(partition = commit.getPartition())).isEmpty()) {
            ExternalAnalysisResultsBackupMinimizer.printInfo((String)("    Removing empty data: " + String.valueOf(commit.getCommit())));
            return lastAddedCommitDescriptor;
        }
        if (this.isIncluded(commit)) {
            commitDescriptor = ExternalAnalysisResultsBackupMinimizer.fixParentCommits(Optional.ofNullable(lastAddedCommitDescriptor).map(ParentedCommitDescriptor::getCommit).orElse(null), commitDescriptor);
            ExternalAnalysisResultsBackupMinimizer.printlnCommit("in:  ", commit);
            lastAddedCommitDescriptor = commitDescriptor;
            try {
                ExternalAnalysisResultsBackupMinimizer.printlnCommit("out: ", ExternalAnalysisResultIndexUtils.copyCommit(commitDescriptor, (IStore)inputStore, (IStore)outputStore, this.includeExclude, this.categories, Function.identity(), this.partitionRenames));
            }
            catch (InconsistentCommitException e) {
                throw new StorageException("Commit copy failed.", (Throwable)e);
            }
        } else {
            ExternalAnalysisResultsBackupMinimizer.printInfo((String)("    Removing data for ignored commit: " + String.valueOf(commit.getCommit())));
        }
        return lastAddedCommitDescriptor;
    }

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        ExternalAnalysisResultsBackupMinimizer.execute(ExternalAnalysisResultsBackupMinimizer::new, (String[])args);
    }

    private boolean isIncluded(ExternalAnalysisCommitInfo commit) {
        if (this.ignoredPartitions.contains(commit.getPartition())) {
            return false;
        }
        long timestamp = commit.getTimestamp();
        return !this.ignoredTimestamps.contains(timestamp) && timestamp >= this.startTimestamp && timestamp <= this.endTimestamp;
    }

    @Option(shortName=115, longName="start", description="The timestamp to start from.")
    public void setStartTimestamp(long timestamp) {
        ExternalAnalysisResultsBackupMinimizer.exitIfFalse((this.startTimestamp == 0L ? 1 : 0) != 0, (String)"May only set start timestamp once!");
        this.startTimestamp = timestamp;
    }

    @Option(shortName=105, longName="ignore", description="Adds a timestamp to be ignored.")
    public void addIgnoredTimestamp(long timestamp) {
        this.ignoredTimestamps.add(timestamp);
    }

    @Option(longName="branch-include", description="Adds a branch include ANT pattern.")
    public void addBranchIncludeAntPattern(String branch) {
        this.includeExcludeBranches.addIncludePattern(branch);
    }

    @Option(shortName=98, longName="branch-exclude", description="Adds a branch exclude ANT pattern.")
    public void addBranchExcludeAntPattern(String branch) {
        this.includeExcludeBranches.addExcludePattern(branch);
    }

    @Option(shortName=112, longName="partition", description="Adds a partition to be ignored.")
    public void addIgnoredPartition(String partition) {
        this.ignoredPartitions.add(partition);
    }

    @Option(shortName=110, longName="include", description="Adds a path include ANT pattern.")
    public void addIncludeAntPattern(String pattern) {
        this.includeExclude.addIncludePattern(pattern);
    }

    @Option(shortName=120, longName="exclude", description="Adds a path exclude ANT pattern.")
    public void addExcludeAndPattern(String pattern) {
        this.includeExclude.addExcludePattern(pattern);
    }

    @Option(shortName=114, longName="remove", description="Adds a category for which to remove findings, e.g., FxCop.")
    public void addCategory(String category) {
        this.categories.add(category);
    }

    @Option(shortName=100, longName="delete", description="Delete empty results")
    public void setDeleteEmptyResults() {
        this.deleteEmptyResults = true;
    }

    @Option(longName="renamePartitions", description="Rules for renaming partitions, e.g., 'MyPartition -> Unit Tests' to rename the partition \"MyPartition\"\nto \"Unit Tests\" or '(.*) Tests -> $1' to strip the suffix \" Tests\" from all partition names.\nThis parameter may be supplied multiple times.\n\nRename rules are applied *after* evaluating whether a given partition should be ignored.\n")
    public void addPartitionMapping(String mappings) throws ProjectConfigurationException {
        StringValuePairListOptionDescriptor.parseFromString((String)mappings).stream().forEach(pair -> this.partitionRenames.add(Pattern.compile((String)pair.getFirst()), (String)pair.getSecond()));
    }
}

