/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.tools.ExternalAnalysisResultIndexUtils;
import com.teamscale.index.external.tools.StoreModifierBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.string.StringUtils;

public class ExternalUploadPathTransformer
extends StoreModifierBase {
    private static final Pattern NAMED_GROUP_CANDIDATE_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private final List<Pattern> inputPatterns = new ArrayList<Pattern>();
    private final List<List<String>> groupNames = new ArrayList<List<String>>();
    private final List<String> outputFormats = new ArrayList<String>();
    private final Map<String, String> replacements = new HashMap<String, String>();

    @Option(shortName=105, longName="inputPatterns", description="Input regex which must be matched. Named groups replace the placeholders <matcher-group-name> in the output path.")
    public void setInputRegex(String inputRegex) {
        this.inputPatterns.add(Pattern.compile(inputRegex));
        this.groupNames.add(ExternalUploadPathTransformer.getNamedGroupCandidates(inputRegex));
    }

    @Option(shortName=111, longName="outputFormat", description="The output format. Use place holders <matcher-group-name> to replace the matches from the regex in the format.")
    public void setOutputFormat(String outputFormat) {
        this.outputFormats.add(outputFormat);
    }

    @Override
    protected File checkPreconditions() {
        ExternalUploadPathTransformer.exitIfFalse((this.inputPatterns.size() == this.outputFormats.size() ? 1 : 0) != 0, (String)"Number of input regexes and output formats must match.");
        ExternalUploadPathTransformer.exitIfTrue((boolean)this.inputPatterns.isEmpty(), (String)"Must supply at least one input regex.");
        return super.checkPreconditions();
    }

    @Override
    protected Set<String> getChangedStoreNames() {
        return Set.of("external-analysis-results");
    }

    @Override
    protected void modifyStore(String storeName, CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        List<ParentedCommitDescriptor> commits = commitsByBranch.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(ParentedCommitDescriptor::getTimestamp)).toList();
        int count = 0;
        for (ParentedCommitDescriptor commitDescriptor : commits) {
            ExternalUploadPathTransformer.printInfo((String)("\rCommit " + ++count + "/" + commits.size()));
            try {
                ExternalAnalysisResultIndexUtils.copyCommit(commitDescriptor, (IStore)inputStore, (IStore)outputStore, new IncludeExcludeAntPatternSupport(), new HashSet<String>(), this::transformPath, new StringTransformation());
            }
            catch (InconsistentCommitException e) {
                throw new StorageException("Commit copy failed.", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        ExternalUploadPathTransformer.execute(ExternalUploadPathTransformer::new, (String[])args);
    }

    private String transformPath(String path) {
        for (int i = 0; i < this.inputPatterns.size(); ++i) {
            Matcher matcher = this.inputPatterns.get(i).matcher(path);
            if (!matcher.find()) continue;
            this.replacements.clear();
            for (String groupName : this.groupNames.get(i)) {
                String groupValue = matcher.group(groupName);
                if (groupValue == null) continue;
                this.replacements.put("<" + groupName + ">", groupValue);
            }
            return StringUtils.replaceFromMap((String)this.outputFormats.get(i), this.replacements);
        }
        throw new AssertionError((Object)("No input regex matches for path: " + path));
    }

    private static List<String> getNamedGroupCandidates(String regex) {
        TreeSet<String> namedGroups = new TreeSet<String>();
        Matcher m = NAMED_GROUP_CANDIDATE_PATTERN.matcher(regex);
        while (m.find()) {
            namedGroups.add(m.group(1));
        }
        return new ArrayList<String>(namedGroups);
    }
}

