/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.tools.BackupModifierToolBase;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class StoreModifierBase
extends BackupModifierToolBase {
    protected static void printlnCommit(String prefix, ExternalAnalysisCommitInfo commit) {
        StoreModifierBase.printInfo((String)("    " + prefix + commit.getTimestamp() + " (" + String.valueOf(new Date(commit.getTimestamp())) + "): " + commit.getPartition() + ", +" + commit.getFileDelta().getAddedOrChangedKeys().size() + ", -" + commit.getFileDelta().getDeletedKeys().size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processStore(String storeName, IStore store, ZipArchiveOutputStream zos, BackupModifierToolBase.StoreFactory storeFactory) throws StorageException, IOException {
        CompressingStore compressedInputStore = new CompressingStore(store);
        List commits = HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)new CommitLayeringBranchingLayer((IStore)compressedInputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout()));
        Map<String, List<ParentedCommitDescriptor>> commitsByBranch = commits.stream().collect(Collectors.groupingBy(ParentedCommitDescriptor::getBranchName));
        IStore outputStore = storeFactory.createNewStore();
        try {
            CompressingStore compressedOutputStore = new CompressingStore(outputStore);
            this.modifyStore(storeName, compressedInputStore, compressedOutputStore, commitsByBranch);
            StoreModifierBase.writeOutputStore(zos, outputStore);
        }
        finally {
            storeFactory.removeStore(outputStore);
        }
    }

    protected abstract void modifyStore(String var1, CompressingStore var2, CompressingStore var3, Map<String, List<ParentedCommitDescriptor>> var4) throws StorageException;

    public static ParentedCommitDescriptor fixParentCommits(CommitDescriptor lastAddedCommitDescriptor, ParentedCommitDescriptor commitDescriptor) throws AssertionError {
        CommitDescriptor parentCommit = commitDescriptor.getFirstParentCommit();
        CCSMAssert.isTrue((commitDescriptor.getParentCommits().size() <= 1 ? 1 : 0) != 0, (String)"did not expect more than one parent in an external commit.");
        if (parentCommit != null && !parentCommit.equals((Object)lastAddedCommitDescriptor)) {
            if (lastAddedCommitDescriptor == null) {
                return new ParentedCommitDescriptor(commitDescriptor.getCommit(), new CommitDescriptor[0]);
            }
            return new ParentedCommitDescriptor(commitDescriptor.getCommit(), new CommitDescriptor[]{lastAddedCommitDescriptor});
        }
        return commitDescriptor;
    }
}

