/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitResolverWithPreOpenedIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoCompilationCommand;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoDependencyInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMetrics;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultMetricSchemaChange;
import com.teamscale.index.external.result.ExternalAnalysisResults;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.external.update.ExternalUploadPersisterBase;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.index.report.result.metrics.MetricEntryUpdater;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultCompileCommandProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultDependencyInfoProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultFindingsProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultMetricsProcessor;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorManager;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryContentUpdaterUtils;
import com.teamscale.index.repository.RepositoryLastChangeUtils;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

public class ExternalAnalysisResultsPersister
extends ExternalUploadPersisterBase<ExternalAnalysisCommitInfo> {
    private static final int ELEMENT_CHUNK_SIZE = 200;
    private static final Logger LOGGER = LogManager.getLogger();
    @BranchingLayerAccess(value=ExternalAnalysisResultIndex.class)
    private IBranchingLayer externalAnalysisResultBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisPartitionIndex externalAnalysisPartitionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_WRITE, name="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalResultsPartitionLastUpdateIndex partitionLastUpdateIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodLastTestedIndex methodLastTestedIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalAnalysisStatusIndex statusIndex;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="external-analysis-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @DeltaSource.Named(index=CommitTreeIndex.class, name="external-analysis-commit-tree")
    private KeyDelta commitTreeDelta;
    private final Map<String, Boolean> keepExistingDataInPartition = new HashMap<String, Boolean>();
    private String schedulingCommitPartition = null;
    private CommitDescriptor codeCommit;
    @StepParameterObject
    private final ExternalAnalysisResultProcessorManager processorManager = new ExternalAnalysisResultProcessorManager();
    @StepParameterObject
    private final ExternalAnalysisResultDependencyInfoProcessor dependencyProcessor = new ExternalAnalysisResultDependencyInfoProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultCompileCommandProcessor compilationCommandsProcessor = new ExternalAnalysisResultCompileCommandProcessor();
    @StepParameterObject
    private final ExternalAnalysisResultMetricsProcessor metricsProcessor = new ExternalAnalysisResultMetricsProcessor();

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "external analysis";
    }

    @Override
    protected ECommitType getCommitType() {
        if (ExternalAnalysisResultFindingsProcessor.isReviewFindingPartition(this.schedulingCommitPartition)) {
            return ECommitType.CODE_REVIEW;
        }
        return ECommitType.EXTERNAL_ANALYSIS;
    }

    @Override
    protected KeyDelta getCommitTreeDelta() {
        return this.commitTreeDelta;
    }

    @Override
    protected void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        HashMap<CommitTreeRevision, ExternalAnalysisCommitInfo> commitInfoByRevision = new HashMap<CommitTreeRevision, ExternalAnalysisCommitInfo>();
        try {
            for (ICommitTreeNode node : commitTreeNodes) {
                ExternalAnalysisCommitInfo externalCommit = (ExternalAnalysisCommitInfo)((Object)this.getExternalUploadIndex(node).getCommitInfo());
                commitInfoByRevision.put(node.getRevision(), externalCommit);
            }
            this.processCommitsForNodes(commitTreeNodes, commitInfoByRevision);
            this.updateExternalAnalysisStatus(null, commitTreeNodes, commitInfoByRevision);
        }
        catch (Throwable t) {
            this.updateExternalAnalysisStatus(t, commitTreeNodes, commitInfoByRevision);
            throw t;
        }
    }

    private void updateExternalAnalysisStatus(Throwable error, List<ICommitTreeNode> commitTreeNodes, Map<CommitTreeRevision, ExternalAnalysisCommitInfo> commitInfoByRevision) throws StorageException {
        ExternalAnalysisProcessingStepInfo step = new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.PROCESSED, error == null);
        if (error != null) {
            step.addMessage("Fatal: " + error.getMessage());
        }
        for (ExternalAnalysisResultProcessorBase<?> processor : this.processorManager.getAllProcessors()) {
            List<String> uploadStatusMessages = processor.getUploadStatusMessages();
            if (uploadStatusMessages.isEmpty()) continue;
            step.addMessages(uploadStatusMessages);
        }
        List commits = CollectionUtils.map(commitTreeNodes, ICommitTreeNode::getCommitDescriptorWithOriginalTimestamp);
        this.statusIndex.runWithLock(lockedIndex -> ExternalAnalysisResultsPersister.updateStatusInIndex(lockedIndex, commitTreeNodes, commitInfoByRevision, commits, step));
    }

    private static void updateStatusInIndex(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndexAccess, List<ICommitTreeNode> commitTreeNodes, Map<CommitTreeRevision, ExternalAnalysisCommitInfo> commitInfoByRevision, List<CommitDescriptor> commits, ExternalAnalysisProcessingStepInfo step) throws StorageException {
        List<ExternalAnalysisStatusInfo> oldStatuses = lockedIndexAccess.getStatus(commits);
        PairList oldAndNewStatuses = new PairList();
        for (int i = 0; i < commitTreeNodes.size(); ++i) {
            ICommitTreeNode node = commitTreeNodes.get(i);
            CommitDescriptor commit = commits.get(i);
            ExternalAnalysisStatusInfo oldStatus = oldStatuses.get(i);
            ExternalAnalysisCommitInfo commitInfo = commitInfoByRevision.get(node.getRevision());
            ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(commit, true, commitInfo.getUploadTimestamp(), false));
            status.setMessage(commitInfo.getMessage());
            status.addPartition(commitInfo.getPartition());
            commitInfo.getTypes().forEach(status::addType);
            status.addProcessingStep(step);
            oldAndNewStatuses.add((Object)oldStatus, (Object)status);
        }
        lockedIndexAccess.updateStatuses((PairList<ExternalAnalysisStatusInfo, ExternalAnalysisStatusInfo>)oldAndNewStatuses);
    }

    @Override
    protected void markUploadAsFailed(String errorMessage, CommitDescriptor currentCommit) throws StorageException {
        ExternalAnalysisProcessingStepInfo step = new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.FAILED, false);
        step.addMessage("Fatal: " + errorMessage);
        this.statusIndex.runWithLock(lockedIndex -> {
            ExternalAnalysisStatusInfo oldStatus = lockedIndex.getStatus(currentCommit);
            ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(currentCommit, true, 0L, false));
            status.addProcessingStep(step);
            lockedIndex.updateStatusWithKnownOldStatus(oldStatus, status);
        });
    }

    private void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes, Map<CommitTreeRevision, ExternalAnalysisCommitInfo> commitInfoByRevision) throws StorageException {
        LOGGER.debug("Processing commits for nodes: {}", commitTreeNodes);
        this.processorManager.register(ExternalAnalysisImportInfoMetrics.class, this.metricsProcessor);
        this.processorManager.register(ExternalAnalysisImportInfoCompilationCommand.class, this.compilationCommandsProcessor);
        this.processorManager.register(ExternalAnalysisImportInfoDependencyInfo.class, this.dependencyProcessor);
        this.codeCommit = RepositoryLastChangeUtils.findLastCommitOfType(this.getSchedulingCommit(), ECommitType.CODE_COMMIT, this.logIndex, this.commitDescriptorIndex).orElse(this.getSchedulingCommit());
        PairList partitionLastUpdates = new PairList();
        HashMap<String, KeyDelta> changesByPartition = new HashMap<String, KeyDelta>();
        HashMap<String, List<ICommitTreeNode>> nodesByPartition = new HashMap<String, List<ICommitTreeNode>>();
        ExternalAnalysisCommitInfo schedulingCommitInfo = ExternalAnalysisResultsPersister.collectChangesByPartition(commitTreeNodes, commitInfoByRevision, (PairList<String, CommitDescriptor>)partitionLastUpdates, changesByPartition, nodesByPartition);
        if (schedulingCommitInfo == null) {
            return;
        }
        this.schedulingCommitPartition = schedulingCommitInfo.getPartition();
        boolean containsInitialExternalCommit = CollectionUtils.anyMatch(commitTreeNodes, node -> node.getParentRevisions().isEmpty());
        HashSet<String> allAddedOrEditedPaths = new HashSet<String>();
        HashSet<String> allDeletedPaths = new HashSet<String>();
        ICommitTreeNode last = (ICommitTreeNode)CollectionUtils.getLast(commitTreeNodes);
        ExternalAnalysisResultIndex externalUploadIndex = this.getExternalUploadIndex(last);
        ExternalAnalysisResultIndex parentExternalUploadIndex = null;
        if (!this.parentedSchedulingCommit.getParentCommits().isEmpty()) {
            parentExternalUploadIndex = this.openExternalAnalysisResultIndexForResolvedParentCommit();
        }
        ArrayList<String> partitionsToProcess = new ArrayList<String>(changesByPartition.keySet());
        Map<String, CommitDescriptor> previousLastUpdateByPartition = this.partitionLastUpdateIndex.getPartitionToLastUpdateMap(partitionsToProcess);
        for (String partition : partitionsToProcess) {
            LOGGER.debug("Processing partition {}", (Object)partition);
            Set<String> additionalChangedPaths = this.determineAdditionalChangedPaths(schedulingCommitInfo, externalUploadIndex, (List)nodesByPartition.get(partition), previousLastUpdateByPartition.get(partition));
            LOGGER.debug("Determined additional changed paths: {}", additionalChangedPaths);
            LOGGER.debug("Original delta: {}", changesByPartition.get(partition));
            KeyDelta keyDelta = ExternalAnalysisResultsPersister.determineKeyDeltaForPartition(partition, changesByPartition, containsInitialExternalCommit, additionalChangedPaths, externalUploadIndex, parentExternalUploadIndex);
            LOGGER.debug("Extended delta: {}", (Object)keyDelta);
            Set<UniformPath> filesWithoutAnalysisResults = this.storeOrExtractAddedOrChangedResults(keyDelta, partition, externalUploadIndex, additionalChangedPaths, previousLastUpdateByPartition.get(partition));
            LOGGER.debug("Files without analysis result: {}", filesWithoutAnalysisResults);
            allAddedOrEditedPaths.addAll(keyDelta.getAddedOrChangedKeysAsStrings());
            this.externalAnalysisPartitionIndex.addPartition(partition, this.getSchedulingCommit(), schedulingCommitInfo.getTypes());
            this.deleteRemovedEntries(filesWithoutAnalysisResults, keyDelta.getDeletedKeysAsStrings(), partition);
            allDeletedPaths.addAll(keyDelta.getDeletedKeysAsStrings());
        }
        this.partitionLastUpdateIndex.setPartitionsLastUpdated((PairList<String, CommitDescriptor>)partitionLastUpdates);
        this.methodLastTestedIndex.setPartitionsLastUpload((PairList<String, CommitDescriptor>)partitionLastUpdates);
        this.generateAndStoreElementHistoryEntries(allAddedOrEditedPaths);
        this.writeRepositoryLogEntry(schedulingCommitInfo, commitTreeNodes, changesByPartition.keySet(), allAddedOrEditedPaths, allDeletedPaths);
    }

    private ExternalAnalysisResultIndex openExternalAnalysisResultIndexForResolvedParentCommit() throws StorageException {
        CommitResolverWithPreOpenedIndex resolver = new CommitResolverWithPreOpenedIndex(this.commitDescriptorIndex);
        CommitDescriptor resolvedCommit = resolver.resolveCommit(this.parentedSchedulingCommit.getFirstParentCommit(), this.getExternalUploadBranchingLayer()).orElse(this.parentedSchedulingCommit.getCommit());
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)resolvedCommit.getBranchName(), (long)resolvedCommit.getTimestamp());
        return this.createExternalUploadIndex(this.getExternalUploadBranchingLayer().openStore(historyAccessOption));
    }

    private static KeyDelta determineKeyDeltaForPartition(String partition, Map<String, KeyDelta> changesByPartition, boolean containsInitialExternalCommit, Set<String> additionalChangedPaths, ExternalAnalysisResultIndex externalUploadIndex, @Nullable ExternalAnalysisResultIndex parentExternalUploadIndex) throws StorageException {
        KeyDelta keyDelta = changesByPartition.get(partition);
        if (!additionalChangedPaths.isEmpty()) {
            keyDelta = KeyDelta.aggregateDeltas(List.of(KeyDelta.fromStrings(additionalChangedPaths, Collections.emptySet()), keyDelta));
        }
        if (!containsInitialExternalCommit && !EFeatureToggle.FORCE_FULL_EXTERNAL_UPLOAD_DELTA.isEnabled() || parentExternalUploadIndex == null) {
            return keyDelta;
        }
        Set keysOfCurrentUploads = CollectionUtils.mapToSet(externalUploadIndex.getAllElementPaths(partition), StorageKey::new);
        Set keysOfPreviousUploads = CollectionUtils.mapToSet(parentExternalUploadIndex.getAllElementPaths(partition), StorageKey::new);
        Sets.SetView deletedFileKeys = Sets.difference((Set)keysOfPreviousUploads, (Set)keysOfCurrentUploads);
        KeyDelta externalUploadIndexDelta = new KeyDelta((Collection)keysOfCurrentUploads, (Collection)deletedFileKeys);
        LOGGER.debug("Using external upload delta {}", (Object)externalUploadIndexDelta);
        return KeyDelta.aggregateDeltas(List.of(keyDelta, externalUploadIndexDelta));
    }

    private boolean shouldHandleDeletesFor(String partition) {
        return this.keepExistingDataInPartition.getOrDefault(partition, false) == false;
    }

    private boolean isFirstUploadAfterCodeCommit(CommitDescriptor lastPartitionUpdate) {
        return lastPartitionUpdate == null || lastPartitionUpdate.getTimestamp() < this.codeCommit.getTimestamp();
    }

    private static @Nullable ExternalAnalysisCommitInfo collectChangesByPartition(List<ICommitTreeNode> commitTreeNodes, Map<CommitTreeRevision, ExternalAnalysisCommitInfo> commitInfoByRevision, PairList<String, CommitDescriptor> partitionLastUpdates, Map<String, KeyDelta> changesByPartition, Map<String, List<ICommitTreeNode>> nodesByPartition) {
        ExternalAnalysisCommitInfo commit = null;
        for (ICommitTreeNode node : commitTreeNodes) {
            commit = commitInfoByRevision.get(node.getRevision());
            partitionLastUpdates.add((Object)commit.getPartition(), (Object)commit.getCommit());
            KeyDelta delta = commit.getFileDelta();
            UnmodifiableList deltaDeletes = delta.getDeletedKeys();
            changesByPartition.merge(commit.getPartition(), new KeyDelta((Collection)delta.getAddedOrChangedKeys(), (Collection)deltaDeletes), (d1, d2) -> KeyDelta.aggregateDeltas(List.of(d1, d2)));
            nodesByPartition.computeIfAbsent(commit.getPartition(), x -> new ArrayList()).add(node);
        }
        return commit;
    }

    private Set<String> determineAdditionalChangedPaths(ExternalAnalysisCommitInfo commit, ExternalAnalysisResultIndex externalUploadIndex, List<ICommitTreeNode> nodes, @Nullable CommitDescriptor previousLastUpdateCommit) throws StorageException {
        String partition = commit.getPartition();
        if (CollectionUtils.anyMatch(nodes, node -> node.getParentRevisions().size() > 1)) {
            LOGGER.debug("Found merge commit, so full analysis of this partition is needed");
            return new HashSet<String>(externalUploadIndex.getAllElementPaths(partition));
        }
        if (previousLastUpdateCommit == null) {
            LOGGER.debug("No previous commit found, so nothing to do");
            return Collections.emptySet();
        }
        Optional latestCommitOnBranch = this.commitDescriptorIndex.getLatestCommitForBranch(commit.getCommit().getBranchName());
        if (latestCommitOnBranch.isEmpty()) {
            LOGGER.debug("No latest commit found, so nothing to do");
            return Collections.emptySet();
        }
        List<RepositoryLogFileEntry> entries = RepositoryContentUpdaterUtils.getRepositoryLogFileEntries(previousLastUpdateCommit.getTimestamp(), ((ParentedCommitDescriptor)latestCommitOnBranch.get()).getCommit(), this.commitDescriptorIndex, this.logIndex, this.logFileIndex);
        LOGGER.debug("Found {} repository entries: {}", (Object)entries.size(), entries);
        return UniformPathCompatibilityUtil.asUniformPathStringSet(RepositoryContentUpdaterUtils.determineChangedAndStillPresentFiles(entries));
    }

    private void writeRepositoryLogEntry(ExternalAnalysisCommitInfo commit, List<ICommitTreeNode> commitTreeNodes, Set<String> partitions, Set<String> addedOrEditedPaths, Set<String> deletedPaths) throws StorageException {
        Object message = commit.getMessage();
        if (commitTreeNodes.size() > 1) {
            Set additionalPartitions = CollectionUtils.subtract(partitions, Set.of(commit.getPartition()));
            message = (String)message + ". Integrating previously uploaded data from " + StringUtils.concat((Iterable)CollectionUtils.mapDistinct(commitTreeNodes, node -> DateTimeUtils.getUiFormattedDateString((long)node.getOriginalTimestamp())), (String)", ");
            if (!additionalPartitions.isEmpty()) {
                message = (String)message + " in partitions " + StringUtils.concat((Iterable)additionalPartitions, (String)", ");
            }
        }
        this.writeRepositoryLogEntry(this.getSchedulingCommit(), "EA", (String)message, commit.getUsername(), 0, addedOrEditedPaths.size(), deletedPaths.size(), commit.getUploadTimestamp());
        this.writeRepositoryLogFileEntries(this.getSchedulingCommit(), UniformPathCompatibilityUtil.convertCollection(addedOrEditedPaths), UniformPathCompatibilityUtil.convertCollection(deletedPaths), this.getCommitType());
    }

    private Set<UniformPath> storeOrExtractAddedOrChangedResults(KeyDelta delta, String partition, ExternalAnalysisResultIndex externalUploadIndex, Set<String> additionalChangedPaths, CommitDescriptor lastPartitionUpdate) throws StorageException {
        HashSet<UniformPath> filesWithNoAnalysisResults = new HashSet<UniformPath>();
        List addedFilesChunks = Lists.partition((List)delta.getAddedOrChangedKeysAsStrings(), (int)200);
        for (List addedFilesChunk : addedFilesChunks) {
            List<ExternalAnalysisResults> analysisResults = externalUploadIndex.getAnalysisResults(partition, addedFilesChunk);
            ExternalAnalysisResultsPersister.warnIfAnalysisResultIsMissing(additionalChangedPaths, addedFilesChunk, analysisResults);
            this.storeUnbufferedResults(analysisResults);
            filesWithNoAnalysisResults.addAll(this.extractProcessorBasedResults(UniformPathCompatibilityUtil.convertCollection((Collection)addedFilesChunk), analysisResults, partition, lastPartitionUpdate));
        }
        return filesWithNoAnalysisResults;
    }

    private static void warnIfAnalysisResultIsMissing(Set<String> additionalChangedPaths, List<String> addedFiles, List<ExternalAnalysisResults> analysisResults) {
        for (int i = 0; i < addedFiles.size(); ++i) {
            String uniformPath = addedFiles.get(i);
            ExternalAnalysisResults analysisResult = analysisResults.get(i);
            if (!ExternalAnalysisResultsPersister.isAnalysisResultMissing(analysisResult) || additionalChangedPaths.contains(uniformPath)) continue;
            LOGGER.warn("Missing value for file {}", (Object)uniformPath);
        }
    }

    private void storeUnbufferedResults(List<ExternalAnalysisResults> analysisResultsByFile) throws StorageException {
        for (ExternalAnalysisResults analysisResult : analysisResultsByFile) {
            if (ExternalAnalysisResultsPersister.isAnalysisResultMissing(analysisResult)) continue;
            for (ExternalAnalysisResultMetricSchemaChange entry : analysisResult.getByType(ExternalAnalysisResultMetricSchemaChange.class)) {
                this.storeMetricSchemaChanges(entry);
            }
        }
    }

    private Set<UniformPath> extractProcessorBasedResults(List<UniformPath> addedFiles, List<ExternalAnalysisResults> analysisResultsByFile, String partition, CommitDescriptor lastPartitionUpdate) throws StorageException {
        Map<UniformPath, BasicTokenElementInfo> elementLookup = this.buildBasicTokenElementInfoLookup(addedFiles);
        HashSet<UniformPath> filesWithNoAnalysisResults = new HashSet<UniformPath>();
        for (int i = 0; i < addedFiles.size(); ++i) {
            UniformPath uniformPath = addedFiles.get(i);
            ExternalAnalysisResults analysisValues = analysisResultsByFile.get(i);
            if (ExternalAnalysisResultsPersister.isAnalysisResultMissing(analysisValues)) {
                filesWithNoAnalysisResults.add(uniformPath);
                continue;
            }
            BasicTokenElementInfo element = elementLookup.get(uniformPath);
            if (uniformPath.isCodePath() && element == null) {
                LOGGER.warn("Missing file content for {}", (Object)uniformPath);
                continue;
            }
            for (ExternalAnalysisResultProcessorBase<?> processor : this.processorManager.getAllProcessors()) {
                this.applyProcessor(partition, uniformPath, element, processor, analysisValues.getByType(processor.getResultClass()), lastPartitionUpdate);
            }
        }
        this.processorManager.persistAll(this.getSchedulingCommit());
        return filesWithNoAnalysisResults;
    }

    private void applyProcessor(String partition, UniformPath uniformPath, BasicTokenElementInfo element, ExternalAnalysisResultProcessorBase processor, List<? extends ExternalAnalysisResult<?>> analysisResults, CommitDescriptor lastPartitionUpdate) {
        for (ExternalAnalysisResult<?> analysisResult : analysisResults) {
            if (this.shouldKeepExistingData(processor, partition, analysisResult, lastPartitionUpdate)) {
                this.keepExistingDataInPartition.put(partition, true);
            }
            processor.extract(partition, uniformPath, analysisResult, this.getSchedulingCommit(), this.codeCommit, element);
        }
    }

    private boolean shouldKeepExistingData(ExternalAnalysisResultProcessorBase processor, String partition, ExternalAnalysisResult<?> analysisResult, CommitDescriptor lastPartitionUpdate) {
        if (processor.isPartOfPartialReport(partition, analysisResult)) {
            return true;
        }
        return !this.isFirstUploadAfterCodeCommit(lastPartitionUpdate) && processor.shouldAggregateDataOfSuccessiveUploads();
    }

    private Map<UniformPath, BasicTokenElementInfo> buildBasicTokenElementInfoLookup(List<UniformPath> addedFiles) throws StorageException {
        HashMap<UniformPath, BasicTokenElementInfo> lookup = new HashMap<UniformPath, BasicTokenElementInfo>();
        List codePaths = CollectionUtils.filter(addedFiles, UniformPath::isCodePath);
        List<BasicTokenElementInfo> elements = this.basicTokenElementIndex.getTokenElements(UniformPathCompatibilityUtil.asUniformPathStrings((Collection)codePaths));
        CollectionUtils.forEach((Iterable)codePaths, elements, lookup::put);
        return lookup;
    }

    private static boolean isAnalysisResultMissing(ExternalAnalysisResults analysisValues) {
        return analysisValues == null || analysisValues.isEmpty();
    }

    private void storeMetricSchemaChanges(ExternalAnalysisResultMetricSchemaChange analysisResult) throws StorageException {
        Object metricSchemaChangeEntries = analysisResult.getData();
        MetricEntryUpdater.updateMetricEntries((Collection<MetricSchemaChangeEntry>)metricSchemaChangeEntries, this.metricsIndex, this.metricSchemaIndex, this.basicTokenElementIndex);
    }

    private void generateAndStoreElementHistoryEntries(Set<String> addedOrChangedFiles) throws StorageException {
        PairList historyEntries = new PairList();
        for (String string : addedOrChangedFiles) {
            historyEntries.add((Object)string, (Object)new ElementHistoryEntry(EElementHistoryChangeType.EXTERNAL_ANALYSIS_UPLOAD, this.getSchedulingCommit(), EChangeEntryOrigin.EXTERNAL_UPLOAD));
        }
        this.elementHistoryIndex.setHistoryEntries((PairList<String, ElementHistoryEntry>)historyEntries);
    }

    private void deleteRemovedEntries(Set<UniformPath> filesWithoutAnalysisResults, List<String> removedEntryUniformPaths, String partition) throws StorageException {
        if (!this.shouldHandleDeletesFor(partition)) {
            return;
        }
        List<String> pathsToDelete = Stream.concat(filesWithoutAnalysisResults.stream().map(UniformPath::toString), removedEntryUniformPaths.stream()).distinct().toList();
        for (ExternalAnalysisResultProcessorBase<?> processor : this.processorManager.getAllProcessors()) {
            List<String> filteredPaths = processor.filterToRelevantStringPaths(pathsToDelete);
            if (filteredPaths.isEmpty()) continue;
            LOGGER.debug("Removing {} relevant files from {} {}", (Object)filteredPaths.size(), (Object)partition, (Object)processor.getResultType().getReadableName());
            List deletedPartitionAndPaths = CollectionUtils.map(filteredPaths, path -> new PartitionAndPath(partition, path));
            processor.processDeleted(deletedPartitionAndPaths, this.getSchedulingCommit());
        }
    }

    @Override
    protected IBranchingLayer getExternalUploadBranchingLayer() {
        return this.externalAnalysisResultBranchingLayer;
    }

    protected ExternalAnalysisResultIndex createExternalUploadIndex(IStore store) {
        return new ExternalAnalysisResultIndex(store);
    }

    protected ExternalAnalysisResultIndex getExternalUploadIndex(ICommitTreeNode node) throws StorageException {
        return (ExternalAnalysisResultIndex)super.getExternalUploadIndex(node);
    }
}

