/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class TokenElementIndexesUpdater {
    private final TokenElementIndex elementIndex;
    private final ElementHistoryIndex elementHistoryIndex;
    private final EChangeEntryOrigin changeOrigin;

    public TokenElementIndexesUpdater(TokenElementIndex elementIndex, ElementHistoryIndex elementHistoryIndex, EChangeEntryOrigin changeOrigin) {
        this.elementIndex = elementIndex;
        this.elementHistoryIndex = elementHistoryIndex;
        this.changeOrigin = changeOrigin;
    }

    public void calculateAndStoreAddedOrChangedHistory(CommitDescriptor commit, PairList<String, TokenElementInfo> elements) throws StorageException {
        List<TokenElementInfo> existingEntries = this.elementIndex.getTokenElements(elements.extractFirstList());
        PairList historyEntries = new PairList();
        PairList changedOrNewElements = new PairList();
        for (int i = 0; i < elements.size(); ++i) {
            TokenElementInfo existingEntry = existingEntries.get(i);
            String uniformPath = (String)elements.getFirst(i);
            if (existingEntry != null) {
                if (existingEntry.getText().equals(((TokenElementInfo)((Object)elements.getSecond(i))).getText())) continue;
                historyEntries.add((Object)uniformPath, (Object)new ElementHistoryEntry(EElementHistoryChangeType.EDIT, commit, this.changeOrigin));
                changedOrNewElements.add((Object)uniformPath, (Object)((TokenElementInfo)((Object)elements.getSecond(i))));
                continue;
            }
            historyEntries.add((Object)uniformPath, (Object)new ElementHistoryEntry(EElementHistoryChangeType.ADD, commit, this.changeOrigin));
            changedOrNewElements.add((Object)uniformPath, (Object)((TokenElementInfo)((Object)elements.getSecond(i))));
        }
        this.elementHistoryIndex.setHistoryEntries((PairList<String, ElementHistoryEntry>)historyEntries);
        this.elementIndex.setTokenElements((PairList<String, TokenElementInfo>)changedOrNewElements);
    }
}

