/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.abaplint;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.configuration.tools.ABAPLintConfiguration;
import com.teamscale.index.findings.UpdaterUtils;
import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFileUtils;
import com.teamscale.index.findings.abaplint.ABAPLintRuleDescriptionGenerator;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.resources.Resource;
import org.jetbrains.annotations.VisibleForTesting;

public class ABAPLintUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PACKAGE_DIRECTORY = "server/com.teamscale.index/";
    private static final String CLASS_RESOURCE_DIRECTORY = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/";
    private static final Path CHECK_MAPPINGS_TSV = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/", "abaplint/check-mappings.tsv");
    private static final Path CHECK_OPTIONS_TSV = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/", "abaplint/check-options.tsv");
    private static final String CHECKS_OPTIONS_DEFAULT_VALUES = "abaplint/check-options-default-values.tsv";
    private static final String CHECK_DESCRIPTIONS_DIRECTORY = "check-descriptions/abaplint/";
    private static final String ABAP_LINT_INSTALL_DIRECTORY = "tools/abaplint/";
    public static final String ABAP_LINT_SCHEMA_URL = "https://schema.abaplint.org/schema.json";
    private static final Map<String, String> CHECK_ID_BY_SCHEMA_REFERENCE = new HashMap<String, String>();

    public static void main(String ... arguments) throws IOException, JsonSerializationException {
        JsonNode schema = UpdaterUtils.downloadJsonSchemaFromUrl(ABAP_LINT_SCHEMA_URL, false);
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)CHECK_MAPPINGS_TSV, ABAPLintUpdater.generateCheckMappings(schema));
        CheckMappingAndCheckOptionTSVUtils.writeCheckOptionsToFile((Path)CHECK_OPTIONS_TSV, ABAPLintUpdater.generateCheckOptions(schema));
        ABAPLintRuleDescriptionGenerator.generateDescriptions(CHECK_ID_BY_SCHEMA_REFERENCE.keySet(), ABAPLintUpdater.prefixWithPackageDirectoryIfNeeded(CHECK_DESCRIPTIONS_DIRECTORY), true);
    }

    @VisibleForTesting
    public static List<CheckMapping> generateCheckMappings(JsonNode schema) {
        LOGGER.info("Generating check mappings");
        Resource checkMappingsFile = Resource.of(ABAPLintConfiguration.class, (String)"abaplint/check-mappings.tsv");
        TreeMap oldVersionChecksById = new TreeMap(CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)checkMappingsFile, (boolean)true, (boolean)true));
        Map<String, CheckMapping> newVersionChecksById = ABAPLintUpdater.extractNewCheckMappings(schema);
        ArrayList<CheckMapping> checkMappings = new ArrayList<CheckMapping>();
        for (Map.Entry entry : oldVersionChecksById.entrySet()) {
            String check = (String)entry.getKey();
            CheckMapping existingCheckMapping = (CheckMapping)entry.getValue();
            if (!newVersionChecksById.containsKey(check)) continue;
            checkMappings.add(new CheckMapping(newVersionChecksById.get(check), existingCheckMapping.getReadableCheckName(), existingCheckMapping.category, existingCheckMapping.group, existingCheckMapping.defaultEnablement));
        }
        for (String check : newVersionChecksById.keySet()) {
            if (oldVersionChecksById.containsKey(check)) continue;
            checkMappings.add(newVersionChecksById.get(check));
        }
        return checkMappings;
    }

    private static Map<String, CheckMapping> extractNewCheckMappings(JsonNode schema) {
        TreeMap<String, CheckMapping> checkMappings = new TreeMap<String, CheckMapping>();
        JsonNode checks = schema.get("definitions").get("IConfig").get("properties").get("rules").get("properties");
        Iterator iterator = checks.fields();
        iterator.forEachRemaining(check -> {
            String name = (String)check.getKey();
            String schemaReference = ((JsonNode)check.getValue()).get("anyOf").findValue("$ref").textValue();
            String descriptionNodeText = ((JsonNode)check.getValue()).get("description").asText();
            checkMappings.put(name, new CheckMapping(name, "TODO", "TODO", "TODO", null, descriptionNodeText.substring(0, descriptionNodeText.indexOf("\n")), descriptionNodeText.substring(descriptionNodeText.lastIndexOf("\n") + 1), false));
            CHECK_ID_BY_SCHEMA_REFERENCE.put(name, schemaReference.substring(schemaReference.lastIndexOf("/") + 1));
        });
        return checkMappings;
    }

    @VisibleForTesting
    public static List<ToolCheckOption> generateCheckOptions(JsonNode schema) throws IOException {
        LOGGER.info("Generating check options");
        ArrayList<ToolCheckOption> options = new ArrayList<ToolCheckOption>();
        for (Map.Entry<String, String> checkIdAndSchemaReference : CHECK_ID_BY_SCHEMA_REFERENCE.entrySet()) {
            Iterator optionsIterator = schema.get("definitions").get(checkIdAndSchemaReference.getValue()).get("properties").fields();
            optionsIterator.forEachRemaining(optionNode -> {
                if (!((String)optionNode.getKey()).equals("exclude") && !((String)optionNode.getKey()).equals("severity")) {
                    options.add(ABAPLintUpdater.extractCheckOptionWithoutDefaultValue(optionNode, (String)checkIdAndSchemaReference.getKey()));
                }
            });
        }
        ABAPLintUpdater.setCheckOptionsDefaultValues(options);
        return options;
    }

    private static ToolCheckOption extractCheckOptionWithoutDefaultValue(Map.Entry<String, JsonNode> option, String checkId) {
        String description = "";
        EToolCheckOptionType type = EToolCheckOptionType.STRING;
        JsonNode descriptionNode = option.getValue().get("description");
        JsonNode typeNode = option.getValue().get("type");
        if (descriptionNode != null) {
            description = descriptionNode.asText().replace("\n", " ");
        }
        if (typeNode != null) {
            JsonNode optionTypeNode;
            type = typeNode.asText().equalsIgnoreCase("number") ? EToolCheckOptionType.INTEGER : (typeNode.asText().equalsIgnoreCase("array") ? ((optionTypeNode = option.getValue().get("items").get("type")) != null && "object".equals(optionTypeNode.textValue()) || option.getValue().get("items").get("$ref") != null ? EToolCheckOptionType.JSON : EToolCheckOptionType.STRING_LIST) : EToolCheckOptionType.valueOf((String)typeNode.asText().toUpperCase()));
        }
        String optionId = ABAPLintConfigurationFileUtils.prefixCheckOptionId(checkId, option.getKey());
        return new ToolCheckOption(checkId, optionId, optionId, description, type, null);
    }

    private static Map<String, Map<String, Object>> getCheckOptionsDefaultValuesFromFile() throws IOException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Resource resource = Resource.of(ABAPLintConfiguration.class, (String)CHECKS_OPTIONS_DEFAULT_VALUES);
        List lines = resource.getLines();
        lines.remove(0);
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            String[] parts = line.split("\t");
            CCSMAssert.isTrue((parts.length == 3 ? 1 : 0) != 0, (String)"Each line must indicate the check id, its option and a default value.");
            String checkId = parts[0].trim();
            if (!result.containsKey(checkId)) {
                result.put(checkId, new HashMap());
            }
            ((Map)result.get(checkId)).put(parts[1].trim(), parts[2].trim());
        }
        return result;
    }

    private static void setCheckOptionsDefaultValues(List<ToolCheckOption> optionsWithoutDefaultValues) throws IOException {
        try {
            File installDirectory = ABAPLintUpdater.prefixWithPackageDirectoryIfNeeded(ABAP_LINT_INSTALL_DIRECTORY).toFile();
            ProcessUtils.executeInDirectory((String[])new String[]{"pnpm", "install"}, (File)installDirectory);
            ProcessUtils.ExecutionResult result = ProcessUtils.executeInDirectory((String[])new String[]{"pnpm", "default-config"}, (File)installDirectory);
            String defaultValuesTrimmed = result.getStdout().substring(result.getStdout().indexOf("{"));
            ABAPLintConfigurationFileUtils.setDefaultValuesForCheckOptions(defaultValuesTrimmed, optionsWithoutDefaultValues, ABAPLintUpdater.getCheckOptionsDefaultValuesFromFile());
        }
        catch (IOException | JsonSerializationException e) {
            throw new IOException("Error during generation or deserialization of ABAPLint check options default values.", e);
        }
    }

    private static Path prefixWithPackageDirectoryIfNeeded(String path) {
        if (System.getProperty("user.dir").endsWith("com.teamscale.index")) {
            return Path.of(path, new String[0]);
        }
        return Path.of(PACKAGE_DIRECTORY, path);
    }
}

