/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.bandit;

import com.teamscale.core.utils.TempFileFactory;
import com.teamscale.index.findings.UpdaterUtils;
import com.teamscale.index.findings.bandit.BanditCheckDescription;
import com.teamscale.index.findings.bandit.BanditRestructuredTextToMarkdownConverter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileExtensionFilter;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.yaml.snakeyaml.Yaml;

class BanditUpdater {
    private static final String CHECK_MAPPING_NAME = "check-mappings.tsv";
    private static final String CHECK_OPTIONS_NAME = "check-options.tsv";
    private static final String CONFIG_RESOURCE_DIRECTORY = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/bandit/";
    private static final Path DESCRIPTION_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/bandit/", new String[0]);
    private static final Map<String, String> CHECK_NAME_TO_ID = new HashMap<String, String>();
    private static final Map<String, String> CHECKID_TO_NAME = new HashMap<String, String>();
    private static final Pattern REGEX_LEADING_NUMBER = Pattern.compile("^\\d+\\s?");
    private static final Pattern REGEX_LEADING_NUMBER_COMPLETE_LINE = Pattern.compile("^\\d.*");
    private static final Pattern CHECK_ID_PATTERN = Pattern.compile("B\\d\\d\\d:");

    BanditUpdater() {
    }

    private static CanonicalFile getTempWorkingDirectory(String name) throws IOException {
        File tmpDir = FileSystemUtils.getTmpDir();
        TempFileFactory tempFileFactory = new TempFileFactory(tmpDir);
        return tempFileFactory.getTempFile(name, "");
    }

    public static void main(String[] args) throws IOException, FormatException {
        File file = BanditUpdater.generateConfigFile();
        List<CheckMapping> availableChecks = BanditUpdater.getAvailableChecks(file);
        BanditUpdater.generateCheckOptions(file);
        BanditUpdater.getCheckDescriptions();
        availableChecks = BanditUpdater.updateReadableNames(availableChecks);
        BanditUpdater.generateCheckMappings(availableChecks);
    }

    private static List<CheckMapping> updateReadableNames(List<CheckMapping> availableChecks) {
        ArrayList<CheckMapping> updatedChecks = new ArrayList<CheckMapping>();
        for (CheckMapping checkMapping : availableChecks) {
            String id = StringUtils.stripPrefix((String)checkMapping.checkId, (String)"bandit.");
            String newName = CHECKID_TO_NAME.get(id);
            if (newName == null) continue;
            CheckMapping newMapping = new CheckMapping(checkMapping.checkId, newName, checkMapping.category, checkMapping.group, checkMapping.defaultEnablement);
            updatedChecks.add(newMapping);
        }
        return updatedChecks;
    }

    private static void generateCheckMappings(List<CheckMapping> availableChecks) throws IOException {
        Path checkMappings = Path.of(CONFIG_RESOURCE_DIRECTORY, CHECK_MAPPING_NAME);
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)checkMappings, availableChecks);
    }

    private static void generateCheckOptions(File file) throws IOException {
        List<ToolCheckOption> availableOptions = BanditUpdater.getAvailableOptions(file);
        Path checkOptionMappings = Path.of(CONFIG_RESOURCE_DIRECTORY, CHECK_OPTIONS_NAME);
        CheckMappingAndCheckOptionTSVUtils.writeCheckOptionsToFile((Path)checkOptionMappings, availableOptions);
    }

    private static List<CheckMapping> getAvailableChecks(File file) throws IOException {
        List lines = FileSystemUtils.readLinesUTF8((File)file);
        ArrayList<CheckMapping> mappings = new ArrayList<CheckMapping>();
        for (String line : lines) {
            if (!line.startsWith("# B")) continue;
            mappings.add(BanditUpdater.parseLine(line));
        }
        return mappings;
    }

    private static void getCheckDescriptions() throws IOException {
        Comparable<Path> file;
        Path filename;
        Path tempWorkingDirectory = BanditUpdater.getTempWorkingDirectory("bandit-repo").toPath();
        UpdaterUtils.cloneOrUpdateRepository("https://github.com/PyCQA/bandit", tempWorkingDirectory, "1.7.7");
        FileExtensionFilter filter = new FileExtensionFilter(new String[]{"py"});
        Path pluginDir = tempWorkingDirectory.resolve("bandit/plugins");
        List files = FileSystemUtils.listFilesRecursively((File)pluginDir.toFile(), (FileFilter)filter);
        List<String> comments = BanditUpdater.extractRST(files);
        Map<String, String> markdownByCheckId = BanditUpdater.convertToMarkdown(comments);
        Path blacklistDir = tempWorkingDirectory.resolve("bandit/blacklists");
        List blacklistFiles = FileSystemUtils.listFilesRecursively((File)blacklistDir.toFile(), (FileFilter)filter);
        List<String> blacklistComments = BanditUpdater.extractRST(blacklistFiles);
        Map<String, String> markdownByCheckIdFromBlackList = BanditUpdater.convertToMarkdownFromBlacklist(blacklistComments);
        for (Map.Entry<String, String> entry : markdownByCheckId.entrySet()) {
            filename = Path.of("bandit." + entry.getKey() + ".md", new String[0]);
            file = DESCRIPTION_DIRECTORY.resolve(filename);
            FileSystemUtils.writeFileUTF8((Path)file, (String)entry.getValue());
        }
        for (Map.Entry<String, String> entry : markdownByCheckIdFromBlackList.entrySet()) {
            filename = Path.of("bandit." + entry.getKey() + ".md", new String[0]);
            file = DESCRIPTION_DIRECTORY.resolve(filename).toFile();
            FileSystemUtils.writeFileUTF8((File)file, (String)entry.getValue());
        }
    }

    private static Map<String, String> convertToMarkdownFromBlacklist(List<String> comments) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String rst : comments) {
            rst = StringUtils.strip((String)rst, (String)"\"\"\"");
            rst = StringUtils.stripPrefix((String)rst, (String)"r\"\"\"");
            result.putAll(BanditUpdater.extractProlog(rst));
        }
        return result;
    }

    private static Map<String, String> extractProlog(String rst) {
        StringBuilder prolog = new StringBuilder();
        HashMap<String, String> result = new HashMap<String, String>();
        String lastId = null;
        StringBuilder lastBuilder = null;
        for (String line : StringUtils.splitLines((String)rst)) {
            String markdown;
            BanditCheckDescription check;
            String lastText;
            Matcher checkIdMatcher = CHECK_ID_PATTERN.matcher(line);
            boolean foundCheckId = checkIdMatcher.find();
            if (!foundCheckId && lastBuilder == null) {
                prolog.append(line).append("\n");
                continue;
            }
            if (foundCheckId) {
                if (lastBuilder != null) {
                    lastText = String.valueOf(prolog) + lastBuilder.toString();
                    check = BanditRestructuredTextToMarkdownConverter.convertRSTToMarkDown(lastText, CHECK_NAME_TO_ID);
                    markdown = check.description();
                    result.put(lastId, markdown);
                }
                String checkId = StringUtils.getFirstPart((String)line, (String)":");
                lastBuilder = new StringBuilder();
                lastId = checkId;
                continue;
            }
            lastText = String.valueOf(prolog) + lastBuilder.toString();
            check = BanditRestructuredTextToMarkdownConverter.convertRSTToMarkDown(lastText, CHECK_NAME_TO_ID);
            markdown = check.description();
            for (String id : BanditUpdater.splitIds(lastId)) {
                String readableName = id + ": Blacklist various Python calls known to be dangerous";
                CHECKID_TO_NAME.put(id, readableName);
                result.put(lastId, markdown);
            }
            lastBuilder.append(line).append("\n");
        }
        return result;
    }

    private static List<String> splitIds(String combinedId) {
        if (!combinedId.contains("-")) {
            return List.of(combinedId);
        }
        Pair startAndEndId = StringUtils.splitAtFirst((String)combinedId, (String)"-");
        String start = StringUtils.stripPrefix((String)((String)startAndEndId.getFirst()).trim(), (String)"B").trim();
        String end = StringUtils.stripPrefix((String)((String)startAndEndId.getSecond()).trim(), (String)"B").trim();
        int startId = Integer.parseInt(start);
        int endId = Integer.parseInt(end);
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = startId; i <= endId; ++i) {
            ids.add("B" + i);
        }
        return ids;
    }

    private static Map<String, String> convertToMarkdown(List<String> comments) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String rst : comments) {
            rst = StringUtils.strip((String)rst, (String)"\"\"\"");
            rst = StringUtils.stripPrefix((String)rst, (String)"r\"\"\"");
            BanditCheckDescription check = BanditRestructuredTextToMarkdownConverter.convertRSTToMarkDown(rst, CHECK_NAME_TO_ID);
            String markDown = BanditUpdater.reformatBanditCheckDescriptionExample(check.description());
            Matcher checkIdMatcher = CHECK_ID_PATTERN.matcher(check.readableName());
            if (!checkIdMatcher.find()) continue;
            String checkId = checkIdMatcher.group(0).replace(":", "");
            CHECKID_TO_NAME.put(checkId, check.readableName());
            result.put(checkId, markDown);
        }
        return result;
    }

    @VisibleForTesting
    public static String reformatBanditCheckDescriptionExample(String checkDescription) {
        String[] lines = checkDescription.trim().split("\n");
        StringBuilder outputCheckDescription = new StringBuilder();
        boolean inExample = false;
        boolean inCodeBlock = false;
        for (String line : lines) {
            if (BanditUpdater.skipLineWhenReformating(line, inCodeBlock, inExample)) continue;
            String outputLine = BanditUpdater.processLine(line, inCodeBlock, inExample);
            outputCheckDescription.append(outputLine).append("\n");
            if (line.startsWith("## Example")) {
                inExample = true;
                continue;
            }
            if (inExample && line.startsWith("##")) {
                inExample = false;
                continue;
            }
            if (inExample && REGEX_LEADING_NUMBER_COMPLETE_LINE.matcher(line).matches() && !inCodeBlock) {
                inCodeBlock = true;
                continue;
            }
            if (!BanditUpdater.endOfCodeBlock(line, inCodeBlock, inExample)) continue;
            inCodeBlock = false;
        }
        return outputCheckDescription.toString();
    }

    private static String processLine(String line, boolean inCodeBlock, boolean inExample) {
        Object outputLine;
        if (!inExample) {
            return line;
        }
        if (line.startsWith(">> Issue:")) {
            outputLine = line.replace(">> Issue:", "In the following code snippet the issue is:");
            if (inCodeBlock) {
                outputLine = "```\n" + (String)outputLine;
            }
        } else if (line.startsWith("CWE:")) {
            outputLine = line.replace("CWE:", "For more information on this see:");
        } else if (REGEX_LEADING_NUMBER_COMPLETE_LINE.matcher(line).matches()) {
            outputLine = REGEX_LEADING_NUMBER.matcher(line).replaceFirst("");
            if (!inCodeBlock) {
                outputLine = "``` python\n" + (String)outputLine;
            }
        } else {
            outputLine = line;
        }
        return outputLine;
    }

    private static boolean skipLineWhenReformating(String line, boolean inCodeBlock, boolean inExample) {
        return inExample && (line.startsWith("Severity:") || line.startsWith("Location:") || line.startsWith("``` python")) || inCodeBlock && line.equals("");
    }

    private static boolean endOfCodeBlock(String line, boolean inCodeBlock, boolean inExample) {
        return inExample && line.startsWith(">> Issue:") && inCodeBlock || inCodeBlock && line.startsWith("```");
    }

    private static List<String> extractRST(List<File> files) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            String content = FileSystemUtils.readFileUTF8((File)file);
            List tokens = ScannerUtils.getTokens((String)content, (ELanguage)ELanguage.PYTHON, (String)"Bandit Updater");
            List allTokens = TokenStreamUtils.findAllTokens((List)tokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MULTILINE_COMMENT, ETokenType.DOCUMENTATION_COMMENT}));
            result.addAll(allTokens.stream().map(IToken::getText).toList());
        }
        return result;
    }

    private static List<ToolCheckOption> getAvailableOptions(File file) throws IOException {
        String content = FileSystemUtils.readFileUTF8((File)file);
        Map parsedConfig = (Map)new Yaml().load(content);
        ArrayList<ToolCheckOption> mappings = new ArrayList<ToolCheckOption>();
        for (Map.Entry entry : parsedConfig.entrySet()) {
            Map value = (Map)entry.getValue();
            if (value == null) continue;
            String checkId = CHECK_NAME_TO_ID.get(entry.getKey());
            String checkIdWithoutPrefix = StringUtils.stripPrefix((String)checkId, (String)"bandit.");
            for (Map.Entry optionEntry : value.entrySet()) {
                String optionId = (String)entry.getKey() + "." + (String)optionEntry.getKey();
                if (BanditUpdater.excludeOption(optionId)) continue;
                Object value1 = optionEntry.getValue();
                EToolCheckOptionType type = EToolCheckOptionType.fromType(value1);
                ToolCheckOption option = new ToolCheckOption(checkId, optionId, checkIdWithoutPrefix + ": " + optionId, "", type, switch (type) {
                    case EToolCheckOptionType.BOOLEAN, EToolCheckOptionType.STRING, EToolCheckOptionType.INTEGER -> value1.toString();
                    case EToolCheckOptionType.STRING_LIST -> value1.toString().substring(1, value1.toString().length() - 1);
                    default -> throw new RuntimeException("Detected unsupported type " + String.valueOf(type));
                });
                mappings.add(option);
            }
        }
        return mappings;
    }

    private static boolean excludeOption(String optionId) {
        return "assert_used.skips".equals(optionId);
    }

    private static CheckMapping parseLine(String rawLine) {
        String line = StringUtils.stripPrefix((String)rawLine, (String)"#").trim();
        List strings = StringUtils.splitToList((String)line, (String)":");
        String internalId = ((String)strings.get(0)).trim();
        String name = ((String)strings.get(1)).trim();
        String checkId = "bandit." + internalId;
        CHECK_NAME_TO_ID.put(name, checkId);
        return new CheckMapping(checkId, name, "Correctness", "Possible Bugs", EFindingEnablement.YELLOW);
    }

    private static File generateConfigFile() throws IOException {
        CanonicalFile workingDir = BanditUpdater.getTempWorkingDirectory("bandit");
        FileSystemUtils.ensureDirectoryExists((File)workingDir);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory((File)workingDir);
        builder.command("bandit-config-generator", "--out", "bandit.yml");
        ProcessUtils.execute((ProcessBuilder)builder);
        Path path = Path.of(workingDir.getCanonicalPath(), "bandit.yml");
        return path.toFile();
    }
}

