/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import java.util.Comparator;
import java.util.Objects;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.jspecify.annotations.Nullable;

public class TokenElementChurnWithOriginInfo
extends TokenElementChurnInfo {
    private static final long serialVersionUID = 1L;
    public static final Comparator<TokenElementChurnWithOriginInfo> TIMESTAMP_COMPARATOR = Comparator.comparing(TokenElementChurnWithOriginInfo::getTimestamp).thenComparing(TokenElementChurnInfo::getUniformPath);
    public static final Comparator<TokenElementChurnWithOriginInfo> PATH_COMPARATOR = Comparator.comparing(TokenElementChurnInfo::getUniformPath);
    protected static final String COMMIT_PROPERTY = "commit";
    protected static final String LATEST_COMMIT_WITH_FILE_PRESENT = "latestCommitWithFilePresent";
    protected static final String INTRODUCTION_COMMIT_PROPERTY = "introductionCommit";
    protected static final String ORIGIN_PATH_PROPERTY = "originPath";
    protected static final String ORIGIN_COMMIT_PROPERTY = "originCommit";
    protected static final String CHANGE_ORIGIN_PROPERTY = "changeEntryOrigin";
    @JsonProperty(value="originPath")
    private final @Nullable String originPath;
    @JsonProperty(value="originCommit")
    private final @Nullable CommitDescriptor originCommit;
    @JsonProperty(value="commit")
    private final CommitDescriptor commit;
    @JsonProperty(value="changeEntryOrigin")
    private final EChangeEntryOrigin changeEntryOrigin;
    @JsonProperty(value="latestCommitWithFilePresent")
    private final CommitDescriptor latestCommitWithFilePresent;
    @JsonProperty(value="introductionCommit")
    private final CommitDescriptor introductionCommit;

    public TokenElementChurnWithOriginInfo(CommitDescriptor latestCommitWithFilePresent, CommitDescriptor introductionCommit, RepositoryLogFileHistoryEntry entry) {
        this(entry.getCommit(), latestCommitWithFilePresent, introductionCommit, entry.getUniformPath().toStringAsMigrationFrontier(), entry.getChangeType(), entry.getChangeEntryOrigin(), entry.getOriginPath(), entry.getOriginCommit());
    }

    @JsonCreator
    public TokenElementChurnWithOriginInfo(@JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="latestCommitWithFilePresent") CommitDescriptor latestCommitWithFilePresent, @JsonProperty(value="introductionCommit") CommitDescriptor introductionCommit, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="changeType") EElementHistoryChangeType changeType, @JsonProperty(value="changeEntryOrigin") EChangeEntryOrigin changeEntryOrigin, @JsonProperty(value="originPath") @Nullable String originPath, @JsonProperty(value="originCommit") @Nullable CommitDescriptor originCommit) {
        super(uniformPath, changeType);
        this.commit = commit;
        this.introductionCommit = introductionCommit;
        this.latestCommitWithFilePresent = latestCommitWithFilePresent;
        this.originPath = originPath;
        this.originCommit = originCommit;
        this.changeEntryOrigin = changeEntryOrigin;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public long getTimestamp() {
        return this.commit.getTimestamp();
    }

    public CommitDescriptor getLatestCommitWithFilePresent() {
        return this.latestCommitWithFilePresent;
    }

    public CommitDescriptor getIntroductionCommit() {
        return this.introductionCommit;
    }

    public @Nullable String getOriginPath() {
        return this.originPath;
    }

    public @Nullable CommitDescriptor getOriginCommit() {
        return this.originCommit;
    }

    public EChangeEntryOrigin getChangeEntryOrigin() {
        return this.changeEntryOrigin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenElementChurnWithOriginInfo that = (TokenElementChurnWithOriginInfo)o;
        return Objects.equals(this.originPath, that.originPath) && Objects.equals(this.originCommit, that.originCommit) && Objects.equals(this.commit, that.commit) && Objects.equals(this.introductionCommit, that.introductionCommit) && Objects.equals(this.latestCommitWithFilePresent, that.latestCommitWithFilePresent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originPath, this.originCommit, this.commit, this.latestCommitWithFilePresent, this.introductionCommit);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uniformPath", (Object)this.getUniformPath()).add("changeType", (Object)this.getChangeType()).add(COMMIT_PROPERTY, (Object)this.commit).add(LATEST_COMMIT_WITH_FILE_PRESENT, (Object)this.latestCommitWithFilePresent).add(INTRODUCTION_COMMIT_PROPERTY, (Object)this.introductionCommit).add(ORIGIN_PATH_PROPERTY, (Object)this.originPath).add(ORIGIN_COMMIT_PROPERTY, (Object)this.originCommit).toString();
    }
}

