/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy;

import com.teamscale.index.findings.clangtidy.ClangTidyOutputParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;

public class ModernizeMacroToEnumDeduplicator {
    private static final String CHECK_ID_MODERNIZE_MACRO_TO_ENUM = "modernize-macro-to-enum";
    private static final String GENERIC_MESSAGE = "replace macro with enum";
    private static final String DETAILED_MESSAGE_SUBSTRING = "defines an integral constant; prefer an enum instead";

    public static List<ClangTidyOutputParser.ClangTidyResultItem> filterDuplicates(List<ClangTidyOutputParser.ClangTidyResultItem> items) {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ListMap modernizeMacroToEnumFindingsByLineNumber = new ListMap();
        for (ClangTidyOutputParser.ClangTidyResultItem item : items) {
            if (!CHECK_ID_MODERNIZE_MACRO_TO_ENUM.equals(item.checkId)) continue;
            int lineNumber = item.lineNumber;
            modernizeMacroToEnumFindingsByLineNumber.add((Object)lineNumber, (Object)item);
        }
        ArrayList<ClangTidyOutputParser.ClangTidyResultItem> filteredResults = new ArrayList<ClangTidyOutputParser.ClangTidyResultItem>();
        for (ClangTidyOutputParser.ClangTidyResultItem item : items) {
            if (!CHECK_ID_MODERNIZE_MACRO_TO_ENUM.equals(item.checkId)) {
                filteredResults.add(item);
                continue;
            }
            List itemsOnSameLine = (List)modernizeMacroToEnumFindingsByLineNumber.getCollectionOrEmpty((Object)item.lineNumber);
            if (ModernizeMacroToEnumDeduplicator.isIgnoredDuplicate(item, itemsOnSameLine)) continue;
            filteredResults.add(item);
        }
        return filteredResults;
    }

    private static boolean isIgnoredDuplicate(ClangTidyOutputParser.ClangTidyResultItem item, List<ClangTidyOutputParser.ClangTidyResultItem> itemsOnSameLine) {
        if (!GENERIC_MESSAGE.equals(item.message)) {
            return false;
        }
        for (ClangTidyOutputParser.ClangTidyResultItem otherItem : itemsOnSameLine) {
            boolean isTargetDetailedMessage;
            if (otherItem == item) continue;
            boolean inSameFile = otherItem.sourceFile.equals(item.sourceFile);
            boolean bl = isTargetDetailedMessage = otherItem.message != null && otherItem.message.contains(DETAILED_MESSAGE_SUBSTRING);
            if (!inSameFile || !isTargetDetailedMessage) continue;
            return true;
        }
        return false;
    }
}

