/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.dev_utils;

import com.teamscale.index.configuration.tools.ClangTidyConfiguration;
import com.teamscale.index.findings.IntegratedToolUtils;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class ClangTidyUpdater {
    private static final String CLASS_RESOURCE_DIRECTORY = "server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/clang-tidy/";
    private static final File EXPECTED_VERSION = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/clang-tidy/version.txt");
    private static final File CHECK_OPTIONS_TSV = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/clang-tidy/check-options.tsv");
    private static final Path CHECK_MAPPINGS_TSV = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/clang-tidy/", "check-mappings.tsv");
    private static final Set<String> FOUND_CHECK_OPTION_IDS = new HashSet<String>();

    public static void main(String ... arguments) throws ConQATException, IOException, URISyntaxException {
        FileSystemUtils.writeLines((Path)CHECK_OPTIONS_TSV.toPath(), ClangTidyUpdater.generateCheckOptionsTSV(), (Charset)StandardCharsets.UTF_8);
        FileSystemUtils.writeFileUTF8((Path)EXPECTED_VERSION.toPath(), (String)ClangTidyUpdater.generateExpectedVersion());
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)CHECK_MAPPINGS_TSV, ClangTidyUpdater.generateCheckMappings());
    }

    private static Map<String, CheckMapping> getExistingChecksByCheckId() {
        Resource mappingsFile = Resource.of(ClangTidyConfiguration.class, (String)"clang-tidy/check-mappings.tsv");
        return new TreeMap<String, CheckMapping>(CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile, (boolean)true, (boolean)true));
    }

    @VisibleForTesting
    public static List<String> generateCheckOptionsTSV() {
        LinkedList<String> checkOptions = new LinkedList<String>();
        checkOptions.add("Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value");
        checkOptions.addAll(ClangTidyUpdater.loadCheckOptionsFromClangTidyConfig());
        checkOptions.addAll(ClangTidyUpdater.readCheckOptionsFromDocumentation());
        checkOptions = checkOptions.stream().sorted().toList();
        return checkOptions;
    }

    private static List<String> loadCheckOptionsFromClangTidyConfig() {
        LinkedList<String> checkOptions = new LinkedList<String>();
        String configDump = (String)IntegratedToolUtils.getNonAnalysisCommandLineOutput(ClangTidyRunner.loadConfiguredClangTidyExe(), "--checks=*", "--dump-config").getSecond();
        boolean isInCheckOptionsSection = false;
        for (String line : StringUtils.splitLines((String)configDump)) {
            if ((line = line.trim()).startsWith("CheckOptions:")) {
                isInCheckOptionsSection = true;
                continue;
            }
            if (line.startsWith("...")) {
                isInCheckOptionsSection = false;
            }
            if (!isInCheckOptionsSection) continue;
            String optionName = line.substring(0, line.indexOf(":"));
            String defaultValue = StringUtils.removeSingleQuotes((String)line.substring(line.indexOf(":") + 1).trim());
            String checkId = StringUtils.getFirstPart((String)optionName, (String)".");
            checkOptions.add(ClangTidyUpdater.buildOptionsTSVEntry(checkId, optionName, defaultValue));
            FOUND_CHECK_OPTION_IDS.add(optionName);
        }
        return checkOptions;
    }

    private static List<String> readCheckOptionsFromDocumentation() {
        Map<String, CheckMapping> oldVersionChecksById = ClangTidyUpdater.getExistingChecksByCheckId();
        ArrayList<String> checkOptions = new ArrayList<String>();
        for (String checkID : oldVersionChecksById.keySet()) {
            Optional description = CheckDescriptionLoader.getCheckDescription(ClangTidyConfiguration.class, (String)ClangTidyConfiguration.buildPathToCheckDescriptionFile(checkID));
            if (!description.isPresent()) continue;
            List<String> checkOptionsFromRestructuredText = ClangTidyUpdater.getCheckOptionsFromRestructuredText((String)description.get());
            checkOptions.addAll(checkOptionsFromRestructuredText);
        }
        return checkOptions;
    }

    private static List<String> getCheckOptionsFromRestructuredText(String rstContent) {
        LinkedList<String> checkOptions = new LinkedList<String>();
        List rstLines = StringUtils.splitLinesAsList((String)rstContent);
        String rstTitlePrefix = ".. title:: clang-tidy - ";
        String checkName = "";
        for (String line : rstLines) {
            if (line.startsWith(rstTitlePrefix)) {
                checkName = StringUtils.stripPrefix((String)line, (String)".. title:: clang-tidy - ");
                continue;
            }
            Optional<String> tsvEntry = ClangTidyUpdater.parseCheckOption(line, checkName);
            tsvEntry.ifPresent(checkOptions::add);
        }
        return checkOptions;
    }

    private static Optional<String> parseCheckOption(String line, String checkName) {
        String rstOptionPrefix = ".. option:: ";
        if (!line.startsWith(rstOptionPrefix)) {
            return Optional.empty();
        }
        String simpleOptionName = StringUtils.stripPrefix((String)line, (String)rstOptionPrefix).trim();
        if (simpleOptionName.startsWith("<")) {
            return Optional.empty();
        }
        String optionName = checkName + "." + simpleOptionName;
        if (FOUND_CHECK_OPTION_IDS.contains(optionName)) {
            return Optional.empty();
        }
        return Optional.of(ClangTidyUpdater.buildOptionsTSVEntry(checkName, optionName, ""));
    }

    @VisibleForTesting
    public static String generateExpectedVersion() {
        StringBuilder builder = new StringBuilder();
        builder.append("// Generated by " + ClangTidyUpdater.class.getSimpleName() + "\n");
        String versionOutput = (String)ClangTidyRunner.determineClangTidyVersion().getSecond();
        for (String line : StringUtils.splitLinesAsList((String)versionOutput)) {
            if (!line.contains("LLVM version")) continue;
            int startVersionString = line.indexOf("LLVM version");
            String versionString = line.substring(startVersionString).trim();
            builder.append(versionString);
            return builder.toString();
        }
        return builder.toString();
    }

    @VisibleForTesting
    public static List<CheckMapping> generateCheckMappings() {
        Map<String, CheckMapping> oldVersionChecksById = ClangTidyUpdater.getExistingChecksByCheckId();
        ArrayList<CheckMapping> mappings = new ArrayList<CheckMapping>();
        String newVersionChecksUnparsed = (String)IntegratedToolUtils.getNonAnalysisCommandLineOutput(ClangTidyRunner.loadConfiguredClangTidyExe(), "--checks=*", "--list-checks").getSecond();
        newVersionChecksUnparsed = newVersionChecksUnparsed.replace("Enabled checks:", "");
        Set newVersionChecks = new HashSet(StringUtils.splitLinesAsList((String)newVersionChecksUnparsed)).stream().map(String::trim).filter(entry -> !entry.isEmpty()).collect(Collectors.toSet());
        oldVersionChecksById.forEach((key, checkMapping) -> {
            if (newVersionChecks.contains(key)) {
                mappings.add((CheckMapping)checkMapping);
            }
        });
        for (String check : newVersionChecks) {
            if (oldVersionChecksById.containsKey(check)) continue;
            CheckMapping mapping = new CheckMapping(check, check, "TODO", "TODO", null);
            mappings.add(mapping);
        }
        return mappings;
    }

    private static String buildOptionsTSVEntry(String checkName, String optionName, String defaultValue) {
        return checkName + "\t" + optionName + "\t" + optionName + "\t\tSTRING\t" + defaultValue;
    }
}

