/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cross_file_analysis;

import java.util.ArrayList;
import java.util.Arrays;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public class InPlaceByteArrayWrapper
implements Comparable<InPlaceByteArrayWrapper> {
    public static final ISerializer<InPlaceByteArrayWrapper, byte[]> BYTE_ARRAY_SERIALIZER = new ISerializer<InPlaceByteArrayWrapper, byte[]>(){

        public byte @NonNull [] serialize(InPlaceByteArrayWrapper value) {
            return value.getBytes();
        }

        public @NonNull InPlaceByteArrayWrapper deserialize(byte @NonNull [] value) {
            return new InPlaceByteArrayWrapper(value);
        }
    };
    public static final ISerializer<ArrayList<InPlaceByteArrayWrapper>, byte[]> LIST_OF_BYTE_ARRAY_SERIALIZER = new ISerializer<ArrayList<InPlaceByteArrayWrapper>, byte[]>(){

        public byte @NonNull [] serialize(@NonNull ArrayList<InPlaceByteArrayWrapper> value) throws StorageException {
            ArrayList<byte[]> converted = new ArrayList<byte[]>(value.size());
            for (InPlaceByteArrayWrapper wrapper : value) {
                converted.add(wrapper.getBytes());
            }
            return StorageUtils.serialize(converted);
        }

        public @NonNull ArrayList<InPlaceByteArrayWrapper> deserialize(byte @NonNull [] value) throws StorageException {
            ArrayList list = (ArrayList)StorageUtils.deserialize((byte[])value);
            ArrayList<InPlaceByteArrayWrapper> converted = new ArrayList<InPlaceByteArrayWrapper>(list.size());
            for (byte[] bytes : list) {
                converted.add(new InPlaceByteArrayWrapper(bytes));
            }
            return converted;
        }
    };
    protected byte[] array;

    public InPlaceByteArrayWrapper(byte[] array) {
        this.array = array;
    }

    public byte[] getBytes() {
        return this.array;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InPlaceByteArrayWrapper)) {
            return false;
        }
        InPlaceByteArrayWrapper that = (InPlaceByteArrayWrapper)o;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public int compareTo(InPlaceByteArrayWrapper other) {
        return Arrays.compare(this.array, other.array);
    }
}

