/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.findings.kubescore.KubernetesManifestHandler;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class KubeScoreReportReader
extends FindingReportAnalyzerBase {
    public KubeScoreReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    protected static List<IndexFinding> parseReport(String report, String uniformPath, KubernetesManifestHandler kubernetesManifestHandler) throws ConQATException {
        ArrayList<IndexFinding> findings = new ArrayList<IndexFinding>();
        if (StringUtils.isEmpty((String)report)) {
            return findings;
        }
        JsonNode jsonReport = JsonUtils.deserializeFromJson((String)report);
        for (JsonNode object : jsonReport) {
            String name = object.get("object_name").asText();
            int locationLine = object.get("file_row").asInt();
            JsonNode checks = object.get("checks");
            for (JsonNode check : checks) {
                List<IndexFinding> findingsFromCheck = KubeScoreReportReader.parseFindingsFromCheck(uniformPath, check, locationLine, name, kubernetesManifestHandler.getOriginReferenceForLine(locationLine));
                findings.addAll(findingsFromCheck);
            }
        }
        return findings;
    }

    private static List<IndexFinding> parseFindingsFromCheck(String uniformPath, JsonNode check, int locationLine, String name, String originPath) {
        JsonNode comments;
        int grade = check.get("grade").asInt();
        if (KubeScoreReportReader.skipCheck(check, grade, comments = check.get("comments"))) {
            return CollectionUtils.emptyList();
        }
        String id = "kube-score." + check.get("check").get("id").asText();
        TextRegionLocation location = new TextRegionLocation(uniformPath, -1, -1, locationLine, locationLine);
        ElementLocation secondaryLocation = null;
        if (originPath != null) {
            secondaryLocation = new ElementLocation(originPath);
        }
        return KubeScoreReportReader.convertCommentsToFindings(name, comments, id, (ElementLocation)location, secondaryLocation);
    }

    private static boolean skipCheck(JsonNode check, int grade, JsonNode comments) {
        return check.get("skipped").asBoolean() || grade >= 10 || comments == null;
    }

    private static @NonNull List<IndexFinding> convertCommentsToFindings(String name, JsonNode comments, String id, ElementLocation location, ElementLocation secondaryLocation) {
        ArrayList<IndexFinding> parsedFindings = new ArrayList<IndexFinding>();
        for (JsonNode comment : comments) {
            String description = comment.get("description").asText() + "\n\nKubernetes Object: " + name;
            DetachedFinding detachedFinding = new DetachedFinding(id, "kube-score", comment.get("summary").asText(), location, null, Collections.singletonMap("kube-score Comment", description));
            if (secondaryLocation != null) {
                detachedFinding.addSecondaryLocation(secondaryLocation);
            }
            parsedFindings.add(IndexFinding.asRealtimeFinding((DetachedFinding)detachedFinding));
        }
        return parsedFindings;
    }
}

