/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.ProcessUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

class ComposerExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration TIMEOUT = (Duration)TeamscaleSystemProperties.COMPOSER_TIMEOUT.getValue();
    static final String COMPOSER_EXECUTABLE = "composer";

    ComposerExecutor() {
    }

    public static IComposerInstallResult runComposerInstall(Path workingDirectory, Path cacheDirectory) throws ConQATException {
        ProcessBuilder processBuilder = new ProcessBuilder(COMPOSER_EXECUTABLE, "install", "--no-interaction", "--ignore-platform-reqs", "--no-scripts", "--no-plugins", "--no-ansi", "--no-progress").directory(workingDirectory.toFile());
        processBuilder.environment().put("COMPOSER_CACHE_DIR", cacheDirectory.toAbsolutePath().toString());
        ProcessUtils.ExecutionResult result = ComposerExecutor.execute(processBuilder);
        return IComposerInstallResult.parse(result);
    }

    private static ProcessUtils.ExecutionResult execute(ProcessBuilder processBuilder) throws ConQATException {
        ProcessUtils.ExecutionResult result;
        AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(processBuilder);
        try {
            result = ProcessUtils.execute((ProcessBuilder)processBuilder, null, (Duration)TIMEOUT);
        }
        catch (IOException e) {
            throw new ConQATException("Failed to execute composer", (Throwable)e);
        }
        if (result.terminatedByTimeoutOrInterruption()) {
            throw new ConQATException("Composer did not return in the specified timeout: %s\nProcess result:\n%s".formatted(TIMEOUT, result));
        }
        return result;
    }

    public static sealed interface IComposerInstallResult {
        public static IComposerInstallResult parse(ProcessUtils.ExecutionResult result) {
            return switch (result.getReturnCode()) {
                case 0 -> new Success();
                case 1, 2 -> Failure.parse(result);
                default -> throw new UnsupportedOperationException("Unknown composer error:" + String.valueOf(result));
            };
        }

        public record Success() implements IComposerInstallResult
        {
        }

        public record Failure(UnmodifiableSet<String> invalidRepositories, UnmodifiableSet<String> failingDependencies) implements IComposerInstallResult
        {
            private static final UnmodifiableSet<Pattern> DEPENDENCY_ERROR_PATTERNS = CollectionUtils.asUnmodifiable(Set.of(Pattern.compile("composer.json requires (?<dependency>.*?), it could not be found", 32), Pattern.compile("Run \"composer update (?<dependency>[^\"]+)\" to resolve"), Pattern.compile("Install of (?<dependency>.*?) failed", 32)));
            private static final UnmodifiableSet<Pattern> REPOSITORY_ERROR_PATTERNS = CollectionUtils.asUnmodifiable(Set.of(Pattern.compile("Failed to execute git clone --mirror -- '(?<repository>[^']+)'"), Pattern.compile("No driver found to handle VCS repository (?<repository>.*?)\n\n", 32), Pattern.compile("Failed to update (?<repository>.*?), package information from this repository may be outdated", 32)));
            private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

            private static Failure parse(ProcessUtils.ExecutionResult result) {
                return Failure.parse(result.getStderr());
            }

            @VisibleForTesting
            static @NonNull Failure parse(String stderr) {
                Failure failure = new Failure(Failure.parseInvalidRepositories(stderr), Failure.parseFailingDependencies(stderr));
                if (failure.isEmpty()) {
                    LOGGER.warn("Could not detect the failing repository and/or dependency from stderr:\n{}", (Object)stderr);
                }
                return failure;
            }

            private static UnmodifiableSet<String> parseInvalidRepositories(String stderr) {
                return Failure.parseErrorPatterns(stderr, REPOSITORY_ERROR_PATTERNS, "repository");
            }

            private static UnmodifiableSet<String> parseFailingDependencies(String stderr) {
                return Failure.parseErrorPatterns(stderr, DEPENDENCY_ERROR_PATTERNS, "dependency");
            }

            private static UnmodifiableSet<String> parseErrorPatterns(String stderr, Iterable<Pattern> errorPatterns, String groupName) {
                HashSet<String> result = new HashSet<String>();
                for (Pattern dependencyErrorPattern : errorPatterns) {
                    Matcher matcher = dependencyErrorPattern.matcher(stderr);
                    while (matcher.find()) {
                        String matched = matcher.group(groupName);
                        matched = WHITESPACE_PATTERN.matcher(matched).replaceAll("");
                        result.add(matched);
                    }
                }
                return CollectionUtils.asUnmodifiable(result);
            }

            public boolean isEmpty() {
                return this.invalidRepositories.isEmpty() && this.failingDependencies.isEmpty();
            }
        }
    }
}

