/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep;

import com.teamscale.core.config.TeamscaleSystemProperties;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class SemgrepWslUtils {
    private static final String WINDOWS_PATH_SEPARATOR = "\\";
    private static final String WSL_PATH_SEPARATOR = "/";
    private static final Predicate<String> WINDOWS_DRIVE_PATH = Pattern.compile("^[A-Za-z]:\\\\").asPredicate();
    private static final String WSL_MOUNT_PREFIX = "/mnt/";
    public static final String WSL_EXECUTABLE = "wsl";
    public static final String WSL_SEMGREP_EXECUTABLE = (String)TeamscaleSystemProperties.SEMGREP_WSL_EXECUTABLE_INSTALL_PATH.getValue();
    public static final List<String> WSL_EXECUTABLE_ARGS = List.of("--exec");

    public static boolean isWindows() {
        return SystemUtils.isWindows();
    }

    public static String convertWindowsToWslPath(String windowsPath) {
        Object linuxPath = windowsPath.replace(WINDOWS_PATH_SEPARATOR, WSL_PATH_SEPARATOR);
        if (WINDOWS_DRIVE_PATH.test(windowsPath)) {
            linuxPath = WSL_MOUNT_PREFIX + ((String)linuxPath).substring(0, 1).toLowerCase() + ((String)linuxPath).substring(2);
        }
        return linuxPath;
    }

    public static String convertWslToUniformPath(String wslPath) {
        if (wslPath.startsWith(WSL_MOUNT_PREFIX) && wslPath.length() > WSL_MOUNT_PREFIX.length() + 1) {
            String driveLetter = wslPath.substring(WSL_MOUNT_PREFIX.length(), WSL_MOUNT_PREFIX.length() + 1).toUpperCase();
            return driveLetter + ":/" + wslPath.substring(WSL_MOUNT_PREFIX.length() + 2);
        }
        return wslPath;
    }

    private SemgrepWslUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

