/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep.dev_utils;

import com.teamscale.index.configuration.tools.SemgrepConfiguration;
import com.teamscale.index.findings.semgrep.SemgrepRulesFileReader;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class SemgrepUpdater {
    private static final String GITLAB_LINK_PREFIX = "https://gitlab.com/gitlab-org/security-products/sast-rules/-/blob/main/";
    private static final PrintStream OUT = System.out;
    private static final Path RULES_DIRECTORY = Path.of("server/com.teamscale.index/check-descriptions/semgrep/gitlab-sast-rules", new String[0]);
    private static final Path CHECK_MAPPINGS_TSV = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/semgrep/check-mappings.tsv", new String[0]);

    public static void main(String[] args) throws IOException {
        List<Path> ruleFiles;
        Map oldMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Path)CHECK_MAPPINGS_TSV, (boolean)true, (boolean)true);
        CounterSet ruleIdsUsages = new CounterSet();
        HashMap<String, List<String>> guidelineMappings = new HashMap<String, List<String>>();
        try (Stream<Path> stream = Files.walk(RULES_DIRECTORY, new FileVisitOption[0]);){
            ruleFiles = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        }
        ArrayList<String> targetFileLines = new ArrayList<String>();
        ArrayList<String> ignoredFiles = new ArrayList<String>();
        for (Path path : ruleFiles) {
            if (path.toString().endsWith(".yml")) {
                targetFileLines.add(SemgrepUpdater.processRuleFile(path, (CounterSet<String>)ruleIdsUsages, RULES_DIRECTORY, guidelineMappings, oldMappings));
                continue;
            }
            ignoredFiles.add(path.toString());
        }
        SemgrepUpdater.printIgnoredFileNames(ignoredFiles);
        SemgrepUpdater.printGuidelineMappings(guidelineMappings);
        String header = "ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement\tComments\tUpstream URL";
        StringBuilder output = new StringBuilder(header);
        output.append("\n");
        for (String line : CollectionUtils.sort(targetFileLines)) {
            output.append(line).append("\n");
        }
        SemgrepUpdater.checkEachRuleIdUsedOnlyOnce((CounterSet<String>)ruleIdsUsages);
        SemgrepUpdater.writeCheckMappingsFileAndValidateFileFormat(CHECK_MAPPINGS_TSV, output);
    }

    private static void printGuidelineMappings(Map<String, List<String>> guidelineMappings) {
        for (Map.Entry<String, List<String>> guidelineMapping : guidelineMappings.entrySet()) {
            OUT.println("Guideline Mapping for " + guidelineMapping.getKey());
            for (String line : guidelineMapping.getValue()) {
                OUT.println(line);
            }
            OUT.println();
        }
    }

    private static void printIgnoredFileNames(List<String> ignoredFiles) {
        OUT.println("Ignored " + ignoredFiles.stream().filter(file -> file.endsWith("LICENSE.txt")).count() + " LICENSE.txt files");
        for (String path : ignoredFiles.stream().filter(file -> !file.endsWith("LICENSE.txt")).toList()) {
            OUT.println("Ignoring " + path);
        }
        OUT.println();
    }

    private static void writeCheckMappingsFileAndValidateFileFormat(Path target, StringBuilder output) throws IOException {
        FileSystemUtils.writeFile((Path)target, (String)output.toString(), (Charset)StandardCharsets.UTF_8);
        Map mapping = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Path)target);
        OUT.println(mapping.size() + " rules written");
    }

    private static String processRuleFile(Path path, CounterSet<String> ruleIdsUsages, Path rulesDir, Map<String, List<String>> guidelineMappings, Map<String, CheckMapping> oldMappings) throws IOException {
        List<SemgrepRulesFileReader.SemgrepRule> rules = SemgrepRulesFileReader.readFileContent(path, FileSystemUtils.readFile((Path)path, (Charset)StandardCharsets.UTF_8)).getRules();
        if (rules == null) {
            OUT.println("File has no rule. We need one rule per file: " + String.valueOf(path));
            return "";
        }
        if (rules.size() > 1) {
            OUT.println("File has more than one rule. We assume there is only one rule per file: " + String.valueOf(path));
        }
        SemgrepRulesFileReader.SemgrepRule parsedRule = rules.getFirst();
        SemgrepUpdater.updateGuidelineMapping(guidelineMappings, parsedRule);
        Set<ELanguage> languages = SemgrepUpdater.getLanguagesForRule(parsedRule);
        SemgrepUpdater.validateIdDeterminesLanguages(parsedRule.getId(), languages);
        SemgrepUpdater.validateCAlwaysHasCpp(parsedRule.getId(), languages);
        ruleIdsUsages.inc((Object)parsedRule.getId());
        return SemgrepUpdater.getCheckMappingsFileLine(path, rulesDir, parsedRule, oldMappings.get(parsedRule.getId()));
    }

    private static void updateGuidelineMapping(Map<String, List<String>> guidelineMappings, SemgrepRulesFileReader.SemgrepRule parsedRule) {
        String cwe;
        Optional<String> owasp2021id = SemgrepUpdater.extractOwasp2021id(parsedRule.getMetadata().getOwasp());
        if (owasp2021id.isPresent()) {
            guidelineMappings.putIfAbsent("Owasp2021", new ArrayList());
            guidelineMappings.get("Owasp2021").add(parsedRule.getId() + "\t" + owasp2021id.get() + "\tsemgrep");
        }
        if (!(cwe = parsedRule.getMetadata().getCwe()).isEmpty()) {
            guidelineMappings.putIfAbsent("CWE", new ArrayList());
            guidelineMappings.get("CWE").add(parsedRule.getId() + "\t" + cwe + "\tsemgrep");
        }
    }

    private static Set<ELanguage> getLanguagesForRule(SemgrepRulesFileReader.SemgrepRule parsedRule) {
        return parsedRule.getLanguages().stream().map(ruleLanguage -> SemgrepUpdater.determineELanguage(ruleLanguage, parsedRule.getId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static String getCheckMappingsFileLine(Path path, Path rulesDir, SemgrepRulesFileReader.SemgrepRule parsedRule, CheckMapping oldMapping) {
        String shortDescription = parsedRule.getMetadata().getShortDescription();
        if (shortDescription.isEmpty()) {
            shortDescription = parsedRule.getId();
        }
        String shortDescriptionAndLanguage = shortDescription + " (" + SemgrepUpdater.getLanguagesForRule(parsedRule).stream().map(ELanguage::getReadableName).sorted().collect(Collectors.joining(", ")) + ")";
        String pathSuffix = path.toString().substring(rulesDir.toString().length() + 1);
        String gitlabLink = GITLAB_LINK_PREFIX + pathSuffix.replace("\\", "/");
        if (oldMapping != null) {
            return parsedRule.getId() + "\t" + shortDescriptionAndLanguage + "\t" + oldMapping.category + "\t" + oldMapping.group + "\t" + String.valueOf(oldMapping.defaultEnablement != null ? oldMapping.defaultEnablement : "IGNORED") + "\t" + oldMapping.comments + "\t" + gitlabLink;
        }
        return parsedRule.getId() + "\t" + shortDescriptionAndLanguage + "\tTODO_CATEGORY\tTODO_GROUP\tYELLOW\t\t" + gitlabLink;
    }

    private static Optional<String> extractOwasp2021id(List<String> owasp) {
        if (owasp == null) {
            return Optional.empty();
        }
        for (String owaspLine : owasp) {
            if (!owaspLine.contains(":2021-")) continue;
            String owaspId = owaspLine.substring(0, owaspLine.indexOf(":2021-"));
            owaspId = owaspId.replace("A0", "A");
            return Optional.of("OWASP:" + owaspId);
        }
        return Optional.empty();
    }

    private static Optional<ELanguage> determineELanguage(String languageName, String id) {
        return switch (languageName) {
            case "c" -> Optional.of(ELanguage.C);
            case "cpp" -> Optional.of(ELanguage.CPP);
            case "csharp" -> Optional.of(ELanguage.CS);
            case "java" -> Optional.of(ELanguage.JAVA);
            case "python" -> Optional.of(ELanguage.PYTHON);
            case "go" -> Optional.of(ELanguage.GO);
            case "javascript" -> Optional.of(ELanguage.JAVASCRIPT);
            case "kotlin" -> Optional.of(ELanguage.KOTLIN);
            case "swift" -> Optional.of(ELanguage.SWIFT);
            case "typescript" -> Optional.empty();
            case "generic" -> {
                if ("rules_lgpl_oc_other_rule-ios-self-signed-ssl".equals(id) || "rules_lgpl_oc_other_rule-ios-webview-ignore-ssl".equals(id)) {
                    yield Optional.of(ELanguage.OBJECTIVE_C);
                }
                throw new IllegalStateException("Unexpected language: " + languageName + " in " + id);
            }
            default -> throw new IllegalStateException("Unexpected language: " + languageName + " in " + id);
        };
    }

    private static void validateCAlwaysHasCpp(String id, Set<ELanguage> ruleFileLanguages) {
        if (!(!ruleFileLanguages.contains(ELanguage.C) && !ruleFileLanguages.contains(ELanguage.CPP) || ruleFileLanguages.contains(ELanguage.C) && ruleFileLanguages.contains(ELanguage.CPP))) {
            OUT.println("Assumption violated. Rule " + id + " contains only one of C and C++");
        }
    }

    private static void validateIdDeterminesLanguages(String id, Set<ELanguage> ruleFileLanguages) {
        Set<ELanguage> ruleIdLanguages = SemgrepConfiguration.determineLanguagesFromGitlabSastRuleId(id);
        if (!ruleIdLanguages.equals(ruleFileLanguages)) {
            OUT.println("Assumption violated. Can't determine Languages from Rule ID " + id);
        }
    }

    private static void checkEachRuleIdUsedOnlyOnce(CounterSet<String> ruleIdsUsages) {
        String id;
        Iterator iterator = ruleIdsUsages.getKeysByValueDescending().iterator();
        while (iterator.hasNext() && ruleIdsUsages.getValue((Object)(id = (String)iterator.next())) >= 2) {
            OUT.println("ID " + id + " is used by multiple rules. Our integration does not support that.");
        }
    }
}

