/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.analysis_step;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.findings.sonarlint.SonarLintAnalysisStepParameters;
import com.teamscale.index.findings.sonarlint.SonarLintEnginePool;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import com.teamscale.index.findings.sonarlint.SonarLintFindingsSynchronizerBase;
import com.teamscale.index.findings.sonarlint.SonarLintProcess;
import com.teamscale.index.findings.sonarlint.analysis_step.SonarLintFindingCacheProjectIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.jspecify.annotations.Nullable;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.RuleKey;

public class SonarLintAnalysisStep
extends SonarLintFindingsSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    protected SonarLintFindingCacheProjectIndex findingsCacheIndex;
    private final ListMap<String, SonarLintFinding> cachedFindings = new ListMap();
    private final CodeScopeAware<Set<String>> cachedFindingsPerCodeScope = CodeScopeAware.empty();
    @StepParameterObject
    private final SonarLintAnalysisStepParameters parameters = new SonarLintAnalysisStepParameters();
    private final Map<String, BasicTokenElementInfo> elementsByPath = new HashMap<String, BasicTokenElementInfo>();

    public void execute() throws StorageException {
        CodeScopeAware<Map<String, TokenElementInfo>> elementsToAnalyzePerCodeScope = this.getElementsToAnalyzeAndCachedFindings();
        CodeScopeAware<ListMap<String, IndexFinding>> findingsByPathPerCodeScope = this.getCachedFindings();
        this.analyze(elementsToAnalyzePerCodeScope, findingsByPathPerCodeScope);
        this.synchronizeFindings(findingsByPathPerCodeScope);
    }

    private CodeScopeAware<ListMap<String, IndexFinding>> getCachedFindings() {
        CodeScopeAware findingsByPathPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.cachedFindingsPerCodeScope.getCodeScopeNames()) {
            ListMap cachedFindingsForScope = new ListMap();
            Set cachedFindingsForCodeScope = (Set)this.cachedFindingsPerCodeScope.getValue(codeScopeName);
            for (String uniformPath : cachedFindingsForCodeScope) {
                List collectionOrEmpty = (List)this.cachedFindings.getCollectionOrEmpty((Object)uniformPath);
                if (collectionOrEmpty.isEmpty()) continue;
                cachedFindingsForScope.addAll((Object)uniformPath, this.cachedFindings.getCollection((Object)uniformPath));
            }
            ListMap<String, IndexFinding> sonarLintFindings = this.toIndexFindings((ListMap<String, SonarLintFinding>)cachedFindingsForScope, this.elementsByPath);
            findingsByPathPerCodeScope.setValue(codeScopeName, sonarLintFindings);
        }
        return findingsByPathPerCodeScope;
    }

    private void analyze(CodeScopeAware<Map<String, TokenElementInfo>> elementsToAnalyzePerCodeScope, CodeScopeAware<ListMap<String, IndexFinding>> findingsByPathPerCodeScope) {
        for (CodeScopeName codeScopeName : elementsToAnalyzePerCodeScope.getCodeScopeNames()) {
            if (((List)this.parameters.selectedChecks.getValue(codeScopeName)).isEmpty()) {
                findingsByPathPerCodeScope.setValue(codeScopeName, (Object)new ListMap());
                continue;
            }
            ListMap<String, IndexFinding> sonarLintFindings = this.runSonarLint(codeScopeName, elementsToAnalyzePerCodeScope);
            if (findingsByPathPerCodeScope.contains(codeScopeName)) {
                ListMap value = (ListMap)findingsByPathPerCodeScope.getValue(codeScopeName);
                value.addAll(sonarLintFindings);
                continue;
            }
            findingsByPathPerCodeScope.setValue(codeScopeName, sonarLintFindings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ListMap<String, IndexFinding> runSonarLint(CodeScopeName codeScopeName, CodeScopeAware<Map<String, TokenElementInfo>> elementsToAnalyzePerCodeScope) {
        ListMap<String, IndexFinding> listMap;
        TemporaryDirectory tempDirectory;
        StandaloneSonarLintEngine engine;
        block10: {
            engine = null;
            tempDirectory = SonarLintAnalysisStep.getTempDirectory((String)"sonarlint");
            engine = SonarLintEnginePool.createEngine();
            List includedRules = CollectionUtils.map((Collection)((Collection)this.parameters.selectedChecks.getValue(codeScopeName)), RuleKey::parse);
            ListMap<String, SonarLintFinding> newFindingsByPath = new SonarLintProcess((List)this.parameters.selectedOptions.getValueWithDefault(codeScopeName), (List)this.parameters.checkOptionValues.getValueWithDefault(codeScopeName), (String)this.parameters.javaSourceLevel.getValueWithDefault(codeScopeName)).execute(engine, tempDirectory.getPath().toFile(), includedRules, (Map)elementsToAnalyzePerCodeScope.getValue(codeScopeName));
            this.writeFindingsToCacheIndex(newFindingsByPath);
            listMap = this.toIndexFindings(newFindingsByPath, this.elementsByPath);
            if (tempDirectory == null) break block10;
            tempDirectory.close();
        }
        SonarLintEnginePool.returnEngine(engine);
        return listMap;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (tempDirectory != null) {
                            try {
                                tempDirectory.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error running SonarLint.", (Throwable)e);
                        SonarLintEnginePool.returnEngine(engine);
                    }
                }
                catch (Throwable throwable3) {
                    SonarLintEnginePool.returnEngine(engine);
                    throw throwable3;
                }
            }
        }
        return ListMap.emptyMap();
    }

    private void writeFindingsToCacheIndex(ListMap<String, SonarLintFinding> findingsByPath) throws StorageException {
        if (PreCommitUtils.isPrecommitBranch((String)this.getSchedulingCommit().getBranchName())) {
            return;
        }
        PairList values = new PairList();
        for (String uniformPath : findingsByPath.getKeys()) {
            BasicTokenElementInfo tokenElement = this.elementsByPath.get(uniformPath);
            values.add((Object)tokenElement, new ArrayList(Objects.requireNonNull((List)findingsByPath.getCollection((Object)uniformPath))));
        }
        this.findingsCacheIndex.setFindings((PairList<BasicTokenElementInfo, ArrayList<SonarLintFinding>>)values);
    }

    private CodeScopeAware<Map<String, TokenElementInfo>> getElementsToAnalyzeAndCachedFindings() throws StorageException {
        List<TokenElementInfo> changedElements = this.getAddedOrChangedTokenElements((Set<ELanguage>)SonarLintProcess.ANALYZED_LANGUAGES);
        LOGGER.info("Processing {} changed files relevant for SonarLint", (Object)changedElements.size());
        for (TokenElementInfo element2 : changedElements) {
            this.elementsByPath.put(element2.getUniformPath(), element2);
        }
        changedElements.forEach(element -> this.cachedFindings.addAll((Object)element.getUniformPath(), new ArrayList()));
        List<ArrayList<SonarLintFinding>> cachedFindings = this.findingsCacheIndex.getFindings(changedElements);
        CodeScopeAware elementToAnalyzePerCodeScope = CodeScopeAware.empty();
        CollectionUtils.forEach(changedElements, cachedFindings, (tokenElement, findingsForElement) -> this.getElementsToAnalyzeAndCachedFindings((CodeScopeAware<Map<String, TokenElementInfo>>)elementToAnalyzePerCodeScope, (TokenElementInfo)((Object)tokenElement), (ArrayList<SonarLintFinding>)findingsForElement));
        LOGGER.info("Analyzing {} files with SonarLint", (Object)elementToAnalyzePerCodeScope.getValues().stream().mapToLong(Map::size).sum());
        return elementToAnalyzePerCodeScope;
    }

    private void getElementsToAnalyzeAndCachedFindings(CodeScopeAware<Map<String, TokenElementInfo>> elementToAnalyzePerCodeScope, TokenElementInfo tokenElement, @Nullable ArrayList<SonarLintFinding> findingsForElement) {
        if (findingsForElement == null) {
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement);
            if (!elementToAnalyzePerCodeScope.contains(codeScopeName)) {
                elementToAnalyzePerCodeScope.setValue(codeScopeName, new HashMap());
            }
            ((Map)elementToAnalyzePerCodeScope.getValue(codeScopeName)).put(tokenElement.getUniformPath(), tokenElement);
        } else {
            LOGGER.info("Using cached SonarLint findings for {}", (Object)tokenElement.getUniformPath());
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement);
            this.cachedFindings.addAll((Object)tokenElement.getUniformPath(), findingsForElement);
            if (this.cachedFindingsPerCodeScope.contains(codeScopeName)) {
                Set value = (Set)this.cachedFindingsPerCodeScope.getValue(codeScopeName);
                value.add(tokenElement.getUniformPath());
            } else {
                this.cachedFindingsPerCodeScope.setValue(codeScopeName, (Object)CollectionUtils.asHashSet((Object[])new String[]{tokenElement.getUniformPath()}));
            }
        }
    }
}

