/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.findings.sonarlint.SonarLintAnalysisStepParameters;
import com.teamscale.index.findings.sonarlint.SonarLintProcess;
import com.teamscale.index.findings.sonarlint.independent_analysis.ISonarLintIndependentAnalysisServiceApi;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFileInfo;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisRequestParameters;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisSessionsIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SonarLintIndependentAnalysisPush
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource.Named(index=TokenElementIndex.class, name="content")
    private KeyDelta contentDelta;
    @IndexAccess.Named(mode=EIndexAccessMode.READ_ONLY, name="content")
    private TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SonarLintIndependentAnalysisSessionsIndex requestedAnalysisIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptions;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex credentialsProvider;
    @StepParameterObject
    private final SonarLintAnalysisStepParameters parameters = new SonarLintAnalysisStepParameters();
    private ISonarLintIndependentAnalysisServiceApi service;

    public void execute() throws Exception {
        ExternalCredentials credentials = SonarLintIndependentAnalysisUtils.getSonarLintAnalysisServiceCredentials(this.serverOptions, (IExternalCredentialsProvider)this.credentialsProvider);
        this.service = (ISonarLintIndependentAnalysisServiceApi)Retrofit.builder((String)credentials.uri).withBasicNTLMAuthentication(credentials.username, credentials.password).withInteractionLogger(LOGGER).create(ISonarLintIndependentAnalysisServiceApi.class);
        this.adviseAddedOrChangedFiles(this.contentDelta.getAddedOrChangedKeysAsStrings());
        SonarLintIndependentAnalysisPush.adviseDeletedFiles(this.contentDelta.getDeletedKeysAsStrings());
    }

    private void adviseAddedOrChangedFiles(List<String> addedOrChangedKeysAsStrings) throws StorageException, ServiceCallException {
        List<BasicTokenElementInfo> nonNullTokenElements = this.loadAddedOrChangedTokenElements(addedOrChangedKeysAsStrings);
        CodeScopeAware<List<BasicTokenElementInfo>> tokenElementsPerCodeScope = CodeScopeUtils.groupElementsByCodeScope(nonNullTokenElements);
        for (CodeScopeName codeScopeName : tokenElementsPerCodeScope.getCodeScopeNames()) {
            List selectedChecksForCodeScope = (List)this.parameters.selectedChecks.getValue(codeScopeName);
            if (selectedChecksForCodeScope.isEmpty()) continue;
            List tokenElementsForScope = (List)tokenElementsPerCodeScope.getValue(codeScopeName);
            List<SonarLintFileInfo> addedOrChangedFileInfos = tokenElementsForScope.stream().map(tokenElement -> new SonarLintFileInfo(tokenElement.getUniformPath(), SonarLintIndependentAnalysisUtils.generateSonarLintFileHash(tokenElement))).toList();
            String sessionKey = this.requestToSonarLintService(new SonarLintIndependentAnalysisRequestParameters(selectedChecksForCodeScope, (List)this.parameters.selectedOptions.getValueWithDefault(codeScopeName), (List)this.parameters.checkOptionValues.getValueWithDefault(codeScopeName), (String)this.parameters.javaSourceLevel.getValueWithDefault(codeScopeName), addedOrChangedFileInfos));
            this.requestedAnalysisIndex.storeSession(sessionKey, codeScopeName);
        }
    }

    private List<BasicTokenElementInfo> loadAddedOrChangedTokenElements(List<String> addedOrChangedKeysAsStrings) throws StorageException {
        List<@Nullable TokenElementInfo> tokenElements = this.tokenElementIndex.getTokenElements(addedOrChangedKeysAsStrings);
        ArrayList<@NonNull BasicTokenElementInfo> addedOrChangedTokenElements = new ArrayList<BasicTokenElementInfo>();
        for (int i = 0; i < addedOrChangedKeysAsStrings.size(); ++i) {
            String path = addedOrChangedKeysAsStrings.get(i);
            BasicTokenElementInfo tokenElement = tokenElements.get(i);
            if (tokenElement == null) {
                LOGGER.warn("Encountered unexpected null in token elements index for path '{}'.", (Object)path);
                continue;
            }
            if (!SonarLintProcess.ANALYZED_LANGUAGES.contains((Object)tokenElement.getLanguage())) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> path;
                supplierArray[1] = () -> ((BasicTokenElementInfo)tokenElement).getLanguage();
                supplierArray[2] = () -> SonarLintProcess.ANALYZED_LANGUAGES.stream().map(ELanguage::getReadableName).collect(Collectors.joining(", "));
                LOGGER.trace("Skipping SonarLint analysis of path '{}', because {} is not in the analyzed languages {}.", supplierArray);
                continue;
            }
            addedOrChangedTokenElements.add(tokenElement);
        }
        return addedOrChangedTokenElements;
    }

    private static void adviseDeletedFiles(List<String> deletedKeys) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = deletedKeys::size;
        LOGGER.trace("Ignored {} keys for deleted files.", supplierArray);
    }

    private String requestToSonarLintService(SonarLintIndependentAnalysisRequestParameters parameters) throws ServiceCallException, StorageException {
        LOGGER.debug("Requesting analysis for '{}' infos from external SonarLint analysis service.", (Object)parameters.fileInfos().size());
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        return this.service.requestAnalysisAndOpenSession((IProjectId)this.getProjectId(), schedulingCommit.toUnresolvedCommitDescriptor(), this.readBaseUrlOption(), parameters);
    }

    private String readBaseUrlOption() throws StorageException, ServiceCallException {
        String baseUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)this.serverOptions);
        if (baseUrl == null) {
            throw new ServiceCallException("Please set the base URL in admin settings. Without a base URL, the external service will not know how to contact Teamscale once the analysis results are available.");
        }
        return baseUrl;
    }
}

