/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.swiftlint;

import com.teamscale.index.findings.IntegratedToolUpdateUtils;
import com.teamscale.index.findings.swiftlint.SwiftLintRunner;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class SwiftLintCheckMappingsAndOptionsUpdater {
    private static final Set<String> IGNORED_OPTIONS_KEYWORDS = Set.of("warning", "error", "(severity) warning", "(severity) error", "N/A", "severity: warning", "severity: error");
    private static final File DEFAULT_RULES_FILE = new File("server/com.teamscale.service/src/main/resources/com/teamscale/service/project/analysis_profile/swiftlint-default-rules.txt");
    private static final Path CHECK_MAPPINGS_TSV = Path.of("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/", "message/swiftlint/check-mappings.tsv");
    private static final File CHECK_OPTIONS_TSV = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/message/swiftlint/check-options.tsv");
    private static final Predicate<String> MATCHES_INTEGER = Pattern.compile("[+-]?\\d+").asMatchPredicate();
    private static final Predicate<String> MATCHES_DOUBLE_LIST = Pattern.compile("([+-]?\\d+\\.\\d+\\s*,\\s*)*([+-]?\\d+\\.\\d+)").asMatchPredicate();
    private static final Predicate<String> MATCHES_INTEGER_LIST = Pattern.compile("([+-]?\\d+\\s*,\\s*)*([+-]?\\d+)").asMatchPredicate();
    private final ListMap<String, ToolCheck> warningAndErrorOptionsByPrefix = new ListMap();
    private static final PrintStream OUT = System.out;

    public static void main() throws Exception {
        Pair<Integer, String> rules = SwiftLintRunner.getNonAnalysisCommandLineOutput("rules", "--verbose");
        SwiftLintCheckMappingsAndOptionsUpdater updater = new SwiftLintCheckMappingsAndOptionsUpdater();
        List<ToolCheck> toolChecks = updater.parseRules((String)rules.getSecond());
        SwiftLintCheckMappingsAndOptionsUpdater.updateCheckOptionsFile(toolChecks.stream().filter(t -> t.option != null).map(t -> t.option).toList());
        SwiftLintCheckMappingsAndOptionsUpdater.updateMappingsFile(toolChecks);
        SwiftLintCheckMappingsAndOptionsUpdater.updateDefaultRulesFile(toolChecks);
    }

    private static boolean looksLikeList(String text) {
        return text.startsWith("[") && text.endsWith("]");
    }

    private List<ToolCheck> parseRules(String commandlineOutput) {
        ArrayList<ToolCheck> toolCheckOptions = new ArrayList<ToolCheck>();
        List lines = StringUtils.splitLinesAsList((String)commandlineOutput);
        lines.removeFirst();
        lines.removeFirst();
        lines.removeFirst();
        lines.removeLast();
        for (String rule : lines) {
            toolCheckOptions.addAll(this.parseLine(rule));
        }
        toolCheckOptions.addAll(this.addMissingOptions());
        return toolCheckOptions;
    }

    private static String getDefaultRulesDoc(String version) {
        return "# This file lists those SwiftLint rules that are enabled by default in version $version of SwiftLint. The file is\n# generated by SwiftLintCheckMappingsAndOptionsUpdater.java.\n".replace("$version", version).trim();
    }

    private static void updateDefaultRulesFile(List<ToolCheck> toolChecks) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        Pair<Integer, String> rules = SwiftLintRunner.getNonAnalysisCommandLineOutput("--version");
        output.add(SwiftLintCheckMappingsAndOptionsUpdater.getDefaultRulesDoc(((String)rules.getSecond()).trim()));
        output.addAll(new TreeSet<String>(toolChecks.stream().filter(t -> !t.optIn).map(t -> t.checkId).toList()));
        FileSystemUtils.writeLinesUTF8((Path)DEFAULT_RULES_FILE.toPath(), output);
    }

    private static void updateMappingsFile(List<ToolCheck> toolChecks) throws IOException {
        OUT.println("Updating mappings file...");
        Map oldMappings = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Path)CHECK_MAPPINGS_TSV, (boolean)true, (boolean)true);
        Set newCheckIds = toolChecks.stream().map(t -> t.checkId).collect(Collectors.toSet());
        HashSet removedCheckIds = new HashSet();
        oldMappings.keySet().removeIf(oldCheckId -> {
            boolean removeCheckId;
            boolean bl = removeCheckId = !newCheckIds.contains(oldCheckId) && !oldCheckId.equals("custom_rules");
            if (removeCheckId) {
                removedCheckIds.add(oldCheckId);
            }
            return removeCheckId;
        });
        OUT.printf("Removed %d old checks%n", removedCheckIds.size());
        if (!removedCheckIds.isEmpty()) {
            OUT.printf("Removed checks:%n%s%n%n", removedCheckIds.stream().sorted().collect(Collectors.joining("\n")));
        }
        ArrayList updatedMappings = new ArrayList(oldMappings.values());
        HashSet<String> addedCheckIds = new HashSet<String>();
        for (String newCheckId : newCheckIds) {
            if (oldMappings.containsKey(newCheckId)) continue;
            addedCheckIds.add(newCheckId);
            updatedMappings.add(new CheckMapping(newCheckId, SwiftLintCheckMappingsAndOptionsUpdater.guessReadableName(newCheckId), "TODO", "TODO", EFindingEnablement.RED));
        }
        OUT.printf("Added %d new checks%n", addedCheckIds.size());
        if (!addedCheckIds.isEmpty()) {
            OUT.printf("Added checks:%n%s%n%n", addedCheckIds.stream().sorted().collect(Collectors.joining("\n")));
        }
        Set analyzerCheckIds = toolChecks.stream().filter(t -> t.analyzerRule).map(t -> t.checkId).collect(Collectors.toSet());
        ListIterator<CheckMapping> it = updatedMappings.listIterator();
        while (it.hasNext()) {
            CheckMapping updatedCheck = (CheckMapping)it.next();
            if (!analyzerCheckIds.contains(updatedCheck.checkId)) continue;
            Object comment = updatedCheck.comments;
            if (StringUtils.isEmpty((String)comment)) {
                comment = "analyzerRules are not supported";
            } else if (!((String)comment).startsWith("analyzerRules")) {
                comment = "analyzerRules are not supported -- " + (String)comment;
            }
            it.set(new CheckMapping(updatedCheck.checkId, updatedCheck.getReadableCheckName(), updatedCheck.category, updatedCheck.group, null, (String)comment, updatedCheck.upstreamURL, updatedCheck.autoAllowed));
        }
        if (!analyzerCheckIds.isEmpty()) {
            OUT.printf("Set %d analyzer checks to IGNORED%n", analyzerCheckIds.size());
            OUT.printf("IGNORED analyzer checks:%n%s%n%n", analyzerCheckIds.stream().sorted().collect(Collectors.joining("\n")));
        }
        CheckMappingAndCheckOptionTSVUtils.writeCheckMappingsToFile((Path)CHECK_MAPPINGS_TSV, updatedMappings);
    }

    private static String guessReadableName(String checkId) {
        List components = StringUtils.splitToList((String)checkId, (String)"_");
        String guessedName = components.stream().filter(Predicate.not(StringUtils::isEmpty)).map(StringUtils::toFirstUpper).collect(Collectors.joining(" "));
        return IntegratedToolUpdateUtils.makeMarkdownUnambiguous(guessedName);
    }

    private static void updateCheckOptionsFile(List<ToolCheckOption> toolCheckOptions) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value");
        strings.addAll(SwiftLintCheckMappingsAndOptionsUpdater.toTSV(toolCheckOptions));
        FileSystemUtils.writeLinesUTF8((Path)CHECK_OPTIONS_TSV.toPath(), strings);
    }

    private static List<String> toTSV(List<ToolCheckOption> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (ToolCheckOption option : options) {
            String optionId = StringUtils.getLastPart((String)option.fullQualifiedID, (String)"#");
            result.add(option.checkId + "\t" + optionId + "\t" + option.getReadableName() + "\t" + option.getDescription() + "\t" + String.valueOf(option.type) + "\t" + StringUtils.emptyIfNull((String)option.getDefaultValue()));
        }
        return result;
    }

    @VisibleForTesting
    public List<ToolCheck> parseLine(String line) {
        ArrayList<ToolCheck> toolCheckOptions = new ArrayList<ToolCheck>();
        line = SwiftLintCheckMappingsAndOptionsUpdater.fixLinesWithInconsistentSyntax(line).trim();
        List parts = StringUtils.splitToList((String)(line = StringUtils.strip((String)line, (String)"|")), (String)"\\s+\\|\\s+");
        if (parts.size() < 2) {
            return toolCheckOptions;
        }
        String rule = ((String)parts.get(0)).trim();
        if (rule.equals("custom_rules")) {
            return Collections.emptyList();
        }
        boolean optIn = "yes".equals(((String)parts.get(1)).trim());
        boolean analyzerRule = "yes".equals(((String)parts.get(5)).trim());
        String configuration = ((String)parts.getLast()).trim();
        List configurationOptions = StringUtils.splitTopLevel((String)configuration, (char)';', (char)'[', (char)']');
        for (String optionGroup : configurationOptions) {
            toolCheckOptions.addAll(this.processOptionGroup(rule, optIn, analyzerRule, optionGroup));
        }
        return toolCheckOptions;
    }

    private List<ToolCheck> processOptionGroup(String rule, boolean optIn, boolean analyzerRule, String optionGroup) {
        boolean composedOption;
        String trimmedOptionGroup = optionGroup.trim();
        if (IGNORED_OPTIONS_KEYWORDS.contains(trimmedOptionGroup) || trimmedOptionGroup.contains("_severity:")) {
            return List.of(new ToolCheck(null, rule, optIn, analyzerRule));
        }
        boolean containsColon = optionGroup.contains(":");
        Pair splittedOptionName = containsColon ? StringUtils.splitAtFirst((String)optionGroup, (char)':') : StringUtils.splitAtLast((String)optionGroup, (char)' ');
        String optionName = ((String)splittedOptionName.getFirst()).strip();
        String defaultValue = ((String)splittedOptionName.getSecond()).strip();
        boolean composedWarningOption = optionGroup.contains(" warning:");
        boolean bl = composedOption = composedWarningOption && optionGroup.contains("error:");
        if (composedOption || composedWarningOption) {
            return SwiftLintCheckMappingsAndOptionsUpdater.parseComposedOptions(rule, optIn, analyzerRule, optionName, defaultValue);
        }
        EToolCheckOptionType defaultValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(defaultValue);
        boolean nestedOption = optionGroup.contains("(") && optionGroup.contains(")");
        return List.of(this.processNonComposedOption(rule, optIn, analyzerRule, nestedOption, optionName, defaultValue, defaultValueType));
    }

    private ToolCheck processNonComposedOption(String rule, boolean optIn, boolean analyzerRule, boolean nestedOption, String optionName, String defaultValue, EToolCheckOptionType defaultValueType) {
        ToolCheck toolCheck = nestedOption ? SwiftLintCheckMappingsAndOptionsUpdater.parseNestedOption(rule, optIn, analyzerRule, optionName, defaultValue) : SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, analyzerRule, optionName, defaultValue, defaultValueType);
        if (toolCheck.option.getReadableName().endsWith(".warning")) {
            this.warningAndErrorOptionsByPrefix.add((Object)toolCheck.option.getReadableName().replace(".warning", ""), (Object)toolCheck);
        }
        if (toolCheck.option.getReadableName().endsWith(".error")) {
            this.warningAndErrorOptionsByPrefix.add((Object)toolCheck.option.getReadableName().replace(".error", ""), (Object)toolCheck);
        }
        return toolCheck;
    }

    private static List<ToolCheck> parseComposedOptions(String rule, boolean optIn, boolean analyzerRule, String optionName, String defaultValue) {
        String warningOptionName = optionName.concat(".warning");
        String warningInfo = (String)StringUtils.splitAtLast((String)defaultValue, (char)',').getFirst();
        String warningDefaultValue = ((String)StringUtils.splitAtLast((String)warningInfo, (char)':').getSecond()).trim();
        EToolCheckOptionType defaultWarningValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(warningDefaultValue);
        ToolCheck warningCheck = SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, analyzerRule, warningOptionName, warningDefaultValue, defaultWarningValueType);
        String errorOptionName = optionName.concat(".error");
        String errorInfo = (String)StringUtils.splitAtLast((String)defaultValue, (char)',').getSecond();
        String errorDefaultValue = ((String)StringUtils.splitAtLast((String)errorInfo, (char)':').getSecond()).trim();
        EToolCheckOptionType defaultErrorValueType = defaultWarningValueType;
        if (!StringUtils.isEmpty((String)errorDefaultValue)) {
            defaultErrorValueType = SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(errorDefaultValue);
        }
        ToolCheck errorCheck = SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, analyzerRule, errorOptionName, errorDefaultValue, defaultErrorValueType);
        return List.of(warningCheck, errorCheck);
    }

    private static ToolCheck parseNestedOption(String rule, boolean optIn, boolean analyzerRule, String optionName, String defaultValue) {
        String mainOptionName = ((String)optionName).substring(((String)optionName).indexOf("(") + 1, ((String)optionName).indexOf(")"));
        String subOptionName = (String)StringUtils.splitAtLast((String)optionName, (char)' ').getSecond();
        if (subOptionName.equals("w")) {
            subOptionName = "warning";
        }
        if (subOptionName.equals("e")) {
            subOptionName = "error";
        }
        optionName = subOptionName.isEmpty() ? mainOptionName : mainOptionName + "." + subOptionName;
        optionName = ((String)optionName).replace(" ", "_");
        return SwiftLintCheckMappingsAndOptionsUpdater.buildToolCheck(rule, optIn, analyzerRule, (String)optionName, defaultValue, SwiftLintCheckMappingsAndOptionsUpdater.getTypeFromValue(defaultValue));
    }

    private static ToolCheck buildToolCheck(String checkId, boolean optIn, boolean analyzerRule, String optionName, String defaultValue, EToolCheckOptionType type) {
        String fixedCheckID = SwiftLintCheckMappingsAndOptionsUpdater.fixCheckId(checkId);
        Pair<EToolCheckOptionType, String> fixedTypeAndValue = SwiftLintCheckMappingsAndOptionsUpdater.fixTypeAndDefaultValue(optionName, type, defaultValue);
        optionName = SwiftLintCheckMappingsAndOptionsUpdater.fixOptionName(checkId, optionName, (String)fixedTypeAndValue.getSecond());
        ToolCheckOption option = new ToolCheckOption(fixedCheckID, optionName, fixedCheckID + "." + optionName, "", (EToolCheckOptionType)fixedTypeAndValue.getFirst(), (String)fixedTypeAndValue.getSecond());
        return new ToolCheck(option, option.checkId, optIn, analyzerRule);
    }

    private static EToolCheckOptionType getTypeFromValue(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return EToolCheckOptionType.BOOLEAN;
        }
        if (MATCHES_INTEGER.test(value)) {
            return EToolCheckOptionType.INTEGER;
        }
        if (SwiftLintCheckMappingsAndOptionsUpdater.looksLikeList(value)) {
            String listContents = value.substring(1, value.length() - 1);
            if (MATCHES_INTEGER_LIST.test(listContents)) {
                OUT.printf("WARNING: Saw an option value that looks like a list of integers: %s\n         This will be handled as a normal string list.\n         Do we need to add support for EToolCheckOptionType.INTEGER_LIST?\n", listContents);
            }
            if (MATCHES_DOUBLE_LIST.test(listContents)) {
                return EToolCheckOptionType.DOUBLE_LIST;
            }
            return EToolCheckOptionType.STRING_LIST;
        }
        return EToolCheckOptionType.STRING;
    }

    private static String fixLinesWithInconsistentSyntax(String line) {
        int index;
        if (line.contains("required_enum_case") && (index = line.indexOf("{Protocol Name}: {Case Name 1}: {warning|error}, {Case Name 2}: {warning|error}")) != -1) {
            return line.substring(0, index) + "yaml_config:";
        }
        return line;
    }

    private static String fixCheckId(String checkId) {
        if ("nesting".equals(checkId)) {
            return "swift-nesting";
        }
        if ("cyclomatic_complexity".equals(checkId)) {
            return "swift-cyclomatic_complexity";
        }
        return checkId;
    }

    private static String fixOptionName(String checkId, String originalOptionName, String fixedDefaultValue) {
        Object fixedOptionName = originalOptionName.replace(" ", "_");
        if ("expiring_todo".equals(checkId) && "date_delimiters".equals(fixedOptionName) || SwiftLintCheckMappingsAndOptionsUpdater.looksLikeList(fixedDefaultValue)) {
            fixedOptionName = (String)fixedOptionName + ".yaml_config";
        }
        return fixedOptionName;
    }

    private static Pair<EToolCheckOptionType, String> fixTypeAndDefaultValue(String optionId, EToolCheckOptionType type, String defaultValue) {
        Pair<EToolCheckOptionType, String> fixed = SwiftLintCheckMappingsAndOptionsUpdater.fixTypeAndDefaultValueForSpecificOptions(optionId, defaultValue);
        if (fixed != null) {
            return fixed;
        }
        return SwiftLintCheckMappingsAndOptionsUpdater.fixTypeAndDefaultValueBasedOnType(type, defaultValue);
    }

    private static @Nullable Pair<EToolCheckOptionType, String> fixTypeAndDefaultValueForSpecificOptions(String optionId, String defaultValue) {
        if ("yaml_config".equals(optionId)) {
            return Pair.createPair((Object)EToolCheckOptionType.MULTILINE_STRING, (Object)defaultValue);
        }
        if (optionId.endsWith("_deployment_target")) {
            return Pair.createPair((Object)EToolCheckOptionType.STRING, (Object)defaultValue);
        }
        if (optionId.endsWith("date_delimiters")) {
            String[] lines = StringUtils.splitByWholeSeparator((String)defaultValue, (String)",");
            CCSMAssert.isTrue((lines.length == 2 ? 1 : 0) != 0, () -> "Expected two date_delimiter subentries, but got: %d -- %s".formatted(lines.length, defaultValue));
            String yamlDefaultValue = Arrays.stream(lines).map(String::strip).collect(Collectors.joining("\\n"));
            return Pair.createPair((Object)EToolCheckOptionType.MULTILINE_STRING, (Object)yamlDefaultValue);
        }
        return null;
    }

    private static Pair<EToolCheckOptionType, String> fixTypeAndDefaultValueBasedOnType(EToolCheckOptionType originalType, String defaultValue) {
        return switch (originalType) {
            case EToolCheckOptionType.STRING_LIST -> {
                String valueWithoutDelimiter = defaultValue.substring(1, defaultValue.length() - 1);
                if (SwiftLintCheckMappingsAndOptionsUpdater.looksLikeList(valueWithoutDelimiter)) {
                    yield Pair.createPair((Object)EToolCheckOptionType.MULTILINE_STRING, (Object)defaultValue);
                }
                String[] splitDefaultValues = StringUtils.splitByWholeSeparator((String)valueWithoutDelimiter, (String)",");
                yield Pair.createPair((Object)originalType, (Object)Stream.of(splitDefaultValues).map(SwiftLintCheckMappingsAndOptionsUpdater::fixStringQuotes).collect(Collectors.joining(",")));
            }
            case EToolCheckOptionType.STRING -> Pair.createPair((Object)originalType, (Object)SwiftLintCheckMappingsAndOptionsUpdater.fixStringQuotes(defaultValue));
            case EToolCheckOptionType.DOUBLE_LIST -> {
                if (SwiftLintCheckMappingsAndOptionsUpdater.looksLikeList(defaultValue)) {
                    yield Pair.createPair((Object)originalType, (Object)defaultValue.substring(1, defaultValue.length() - 1));
                }
                yield Pair.createPair((Object)originalType, (Object)defaultValue);
            }
            default -> Pair.createPair((Object)originalType, (Object)defaultValue);
        };
    }

    private static String fixStringQuotes(String value) {
        return StringUtils.removeDoubleQuotes((String)value.trim());
    }

    public List<ToolCheck> addMissingOptions() {
        ArrayList<ToolCheck> missingToolChecks = new ArrayList<ToolCheck>();
        for (String key : this.warningAndErrorOptionsByPrefix.getKeys()) {
            List toolChecks = (List)this.warningAndErrorOptionsByPrefix.getCollection((Object)key);
            if (toolChecks == null || toolChecks.size() != 1) continue;
            ToolCheckOption toolCheckOption = ((ToolCheck)toolChecks.getFirst()).option;
            ToolCheck toolCheck = new ToolCheck(SwiftLintCheckMappingsAndOptionsUpdater.getMissingOption(toolCheckOption), toolCheckOption.checkId, ((ToolCheck)toolChecks.getFirst()).optIn, ((ToolCheck)toolChecks.getFirst()).analyzerRule);
            missingToolChecks.add(toolCheck);
        }
        return missingToolChecks;
    }

    private static ToolCheckOption getMissingOption(ToolCheckOption option) {
        String newReadableName;
        String newOptionId;
        if (option.optionId.contains("warning")) {
            newOptionId = option.optionId.replace("warning", "error");
            newReadableName = option.getReadableName().replace("warning", "error");
        } else {
            newOptionId = option.optionId.replace("error", "warning");
            newReadableName = option.getReadableName().replace("error", "warning");
        }
        return new ToolCheckOption(option.checkId, newOptionId, newReadableName, option.getDescription(), option.type, null);
    }

    public record ToolCheck(ToolCheckOption option, String checkId, boolean optIn, boolean analyzerRule) {
    }
}

