/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.swiftlint;

import com.teamscale.index.findings.YamlLinterConfigurationFileGenerator;
import java.util.List;
import java.util.ListIterator;

public class SwiftLintConfigurationFileGenerator {
    private final YamlLinterConfigurationFileGenerator yamlGenerator;

    public SwiftLintConfigurationFileGenerator(List<String> selectedChecks, List<String> selectedOptions, List<String> checkOptionValues, List<String> checkOptionTypes) {
        SwiftLintConfigurationFileGenerator.fixCheckIDs(selectedChecks, selectedOptions);
        this.yamlGenerator = new YamlLinterConfigurationFileGenerator("only_rules", selectedChecks, selectedOptions, checkOptionValues, checkOptionTypes);
    }

    public String generateConfiguration() {
        return this.yamlGenerator.generateConfiguration();
    }

    private static void fixCheckIDs(List<String> selectedChecks, List<String> selectedOptions) {
        String next;
        ListIterator<String> iterator = selectedChecks.listIterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if ("swift-nesting".equals(next)) {
                iterator.set("nesting");
                continue;
            }
            if (!"swift-cyclomatic_complexity".equals(next)) continue;
            iterator.set("cyclomatic_complexity");
        }
        iterator = selectedOptions.listIterator();
        while (iterator.hasNext()) {
            String fixedEntry;
            next = iterator.next();
            if (next.startsWith("swift-nesting")) {
                fixedEntry = next.replace("swift-nesting", "nesting");
                iterator.set(fixedEntry);
                continue;
            }
            if (!next.startsWith("swift-cyclomatic_complexity")) continue;
            fixedEntry = next.replace("swift-cyclomatic_complexity", "cyclomatic_complexity");
            iterator.set(fixedEntry);
        }
    }
}

