/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.abap.CommitInfo;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.abap.UniqueAbapElementName;

public class CommitCluster
implements Comparable<CommitCluster> {
    private final List<UniqueAbapElementName> elements = new ArrayList<UniqueAbapElementName>();
    private final CommitInfo commitInfo;
    private Instant commitTime;

    public CommitCluster(CommitInfo commitInfo) {
        this.commitInfo = commitInfo;
    }

    void addElement(UniqueAbapElementName element, Instant updateTime) {
        if (this.commitTime == null || updateTime.isAfter(this.commitTime)) {
            this.commitTime = updateTime;
        }
        this.elements.add(element);
    }

    public Instant getCommitTime() {
        return this.commitTime;
    }

    public CommitInfo getCommitInfo() {
        return this.commitInfo;
    }

    List<UniqueAbapElementName> getElements() {
        return this.elements;
    }

    @Override
    public int compareTo(CommitCluster other) {
        int result = this.commitTime.compareTo(other.commitTime);
        if (result != 0) {
            return result;
        }
        return Long.compare(System.identityHashCode(this), System.identityHashCode(other));
    }

    public String toString() {
        return String.valueOf(this.commitInfo) + "@" + String.valueOf(this.commitTime) + ": " + String.valueOf(this.elements);
    }
}

